/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.objects.items.ShipConfiguration;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.ControllerState;
import slimeattack07.naval_warfare.util.NWBasicMethods;

public class ShipItem
extends BlockItem {
    public final String TIER;
    public String name = null;
    public final boolean PLACEABLE;

    public ShipItem(Block blockIn, CreativeModeTab group, boolean placeable) {
        super(blockIn, new Item.Properties().m_41491_(group));
        if (blockIn instanceof ShipBlock) {
            ShipBlock ship = (ShipBlock)blockIn;
            this.TIER = this.tierToColor(ship.getTier());
        } else {
            this.TIER = "white";
        }
        this.PLACEABLE = placeable;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public Component m_7626_(ItemStack stack) {
        if (this.name == null) {
            this.name = this.getRegistryName().toString().replace(":", ".");
        }
        return Component.Serializer.m_130701_((String)("{\"translate\":\"block." + this.name + "\",\"color\":\"" + this.TIER + "\"}"));
    }

    private String tierToColor(int tier) {
        switch (tier) {
            case 1: {
                return "gold";
            }
            case 2: {
                return "dark_gray";
            }
            case 3: {
                return "yellow";
            }
            case 4: {
                return "gray";
            }
            case 5: {
                return "aqua";
            }
        }
        return "red";
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        String ship = this.getRegistryName().toString();
        Block block = this.m_40614_();
        if (!(block instanceof ShipBlock)) {
            return InteractionResult.SUCCESS;
        }
        ShipBlock shipblock = (ShipBlock)block;
        if (state.m_60734_() instanceof GameController) {
            GameController controller = (GameController)state.m_60734_();
            if (controller.validateController(level, pos)) {
                GameControllerTE te = (GameControllerTE)level.m_7702_(pos);
                if (!controller.getState(state).equals((Object)ControllerState.EDIT_CONFIG) || te.board_size <= 0) {
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.cannot_register");
                    return InteractionResult.SUCCESS;
                }
                if (!player.m_6047_()) {
                    if (!this.PLACEABLE) {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.not_usable");
                        return InteractionResult.SUCCESS;
                    }
                    if (te.register(ship, player, shipblock)) {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.ship_registered");
                    } else {
                        NWBasicMethods.messagePlayerActionbarBack(player, "message.naval_warfare.already_registered", ": " + ShipConfiguration.MAX_HEALTH_ALLOWED);
                    }
                } else {
                    if (!this.PLACEABLE) {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.not_usable");
                        return InteractionResult.SUCCESS;
                    }
                    if (te.deregister(ship, player, shipblock)) {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.ship_deregistered");
                    } else {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.not_registered");
                    }
                }
            } else {
                NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.controller_corrupt");
            }
            return InteractionResult.SUCCESS;
        }
        block = state.m_60734_();
        if (context.m_43719_().equals((Object)Direction.UP) && (block.equals(NWBlocks.BOARD.get()) || block.equals(NWBlocks.SHIP_DISPLAY.get()))) {
            return super.m_6225_(context);
        }
        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.only_place_on_board");
        return InteractionResult.SUCCESS;
    }
}

