/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import slimeattack07.naval_warfare.NavalWarfare;
import slimeattack07.naval_warfare.config.NavalWarfareConfig;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.BoardRedirect;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.BoardState;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.Spell;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.EnergyShield;
import slimeattack07.naval_warfare.util.abilities.Heatseaker;
import slimeattack07.naval_warfare.util.abilities.Raft;
import slimeattack07.naval_warfare.util.abilities.Sonar;

public class SpellWand
extends Item {
    public SpellWand() {
        super(new Item.Properties().m_41491_(NavalWarfare.NAVAL_WARFARE).m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        boolean backwards = playerIn == null ? false : playerIn.m_6047_();
        this.cycleMode(stack, backwards);
        NWBasicMethods.messagePlayerActionbarBack(playerIn, "descriptions.naval_warfare.spell", ": " + this.getSpell(stack).getName());
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    private void cycleMode(ItemStack stack, boolean backwards) {
        if (stack.m_41720_() instanceof SpellWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            try {
                Spell spell = Spell.valueOf(nw.m_128461_("spell").toUpperCase());
                if (spell != null) {
                    spell = spell.cycle(backwards);
                    nw.m_128473_("spell");
                    nw.m_128359_("spell", spell.toString());
                }
            }
            catch (IllegalArgumentException e) {
                return;
            }
        }
    }

    public Spell getSpell(ItemStack stack) {
        if (stack.m_41720_() instanceof SpellWand) {
            try {
                this.prepare(stack);
                CompoundTag nbt = stack.m_41784_();
                CompoundTag nw = nbt.m_128469_("naval_warfare");
                return Spell.valueOf(nw.m_128461_("spell"));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        this.prepare(stack);
        CompoundTag nbt = stack.m_41784_();
        CompoundTag nw = nbt.m_128469_("naval_warfare");
        String s = nw.m_128461_("spell");
        try {
            Spell spell = Spell.valueOf(s.toUpperCase());
            tooltip.add((Component)NWBasicMethods.createGrayText(spell.getName()));
        }
        catch (IllegalArgumentException e) {
            tooltip.add((Component)NWBasicMethods.createGrayText(s));
        }
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    private void prepare(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("naval_warfare")) {
            CompoundTag nw = new CompoundTag();
            ListTag highlighted = new ListTag();
            nw.m_128359_("spell", Spell.RAFT.toString());
            nw.m_128365_("highlighted", (Tag)highlighted);
            nbt.m_128365_("naval_warfare", (Tag)nw);
            stack.m_41751_(nbt);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (state.m_60734_() instanceof Board) {
            this.deselect(level, stack);
            Board board = (Board)state.m_60734_();
            if (board.validateBoard(level, pos)) {
                BoardTE te = (BoardTE)level.m_7702_(pos);
                ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                Ability ability = this.getAbility(level, stack);
                if (ability != null) {
                    if (ability.targetDefensive() && state.m_60734_() instanceof BoardRedirect) {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.target_defensive");
                    } else if (!ability.targetDefensive() && !(state.m_60734_() instanceof BoardRedirect)) {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.target_offensive");
                    } else if (!board.ownsBlock(player, level, te.getController())) {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.not_owner_b");
                    } else {
                        for (BoardTE bte : ability.getTiles(level, te)) {
                            positions.add(bte.m_58899_());
                        }
                        this.setHighlighted(stack, pos, positions);
                        this.select(level, stack);
                    }
                } else {
                    NWBasicMethods.messagePlayerActionbar(player, "spell.naval_warfare.corrupt");
                }
            }
        } else if (state.m_60734_() instanceof GameController) {
            GameController controller = (GameController)state.m_60734_();
            Ability ability = this.getAbility(level, stack);
            GameControllerTE cte = (GameControllerTE)level.m_7702_(pos);
            if (cte == null) {
                NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.controller_corrupt");
                return InteractionResult.SUCCESS;
            }
            BlockPos origin = this.getOrigin(stack);
            Block block = level.m_8055_(origin).m_60734_();
            if (block instanceof Board) {
                Board board = (Board)block;
                if (board.validateBoard(level, origin)) {
                    BoardTE te = (BoardTE)level.m_7702_(origin);
                    if (ability != null) {
                        if (cte.hasSpell()) {
                            if (!controller.activateActiveAbility(level, player, pos, te, ability, stack, true)) {
                                NWBasicMethods.messagePlayerActionbar(player, "ability.naval_warfare.error");
                            }
                        } else {
                            NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.no_spell");
                        }
                    } else {
                        NWBasicMethods.messagePlayerActionbar(player, "spell.naval_warfare.corrupt");
                    }
                    this.deselect(level, stack);
                } else {
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.board_corrupt");
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public static Ability spellToAbility(Spell spell) {
        if (spell == null) {
            return null;
        }
        switch (spell) {
            case SHIELD: {
                double width = (double)((Integer)NavalWarfareConfig.magic_shield_width.get() + 1) / 2.0;
                double length = (double)((Integer)NavalWarfareConfig.magic_shield_length.get() + 1) / 2.0;
                NavalWarfare.LOGGER.info("cwidth is " + NavalWarfareConfig.magic_shield_width.get());
                NavalWarfare.LOGGER.info("width, length is " + width + ", " + length);
                return new EnergyShield(1, 0, "magic_shield", "spell_shield", (Integer)NavalWarfareConfig.magic_shield_health.get(), (int)Math.ceil(length), (int)Math.floor(length), (int)Math.ceil(width), (int)Math.floor(width));
            }
            case HEATSEAKER: {
                return new Heatseaker();
            }
            case RAFT: {
                return new Raft((ShipBlock)NWBlocks.RAFT.get());
            }
            case SONAR: {
                return new Sonar();
            }
        }
        return null;
    }

    public Ability getAbility(Level level, ItemStack stack) {
        if (stack.m_41720_() instanceof SpellWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            try {
                Spell spell = Spell.valueOf(nw.m_128461_("spell").toUpperCase());
                return SpellWand.spellToAbility(spell);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public BlockPos getOrigin(ItemStack stack) {
        if (stack.m_41720_() instanceof SpellWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            CompoundTag origin = nw.m_128469_("origin");
            return new BlockPos(origin.m_128451_("x"), origin.m_128451_("y"), origin.m_128451_("z"));
        }
        return null;
    }

    public void select(Level level, ItemStack stack) {
        if (stack.m_41720_() instanceof SpellWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            ListTag list = nw.m_128437_("highlighted", 10);
            for (Tag inbt : list) {
                CompoundTag cnbt = (CompoundTag)inbt;
                BlockPos pos = new BlockPos(cnbt.m_128451_("x"), cnbt.m_128451_("y"), cnbt.m_128451_("z"));
                BlockState state = level.m_8055_(pos);
                if (!(state.m_60734_() instanceof Board)) continue;
                Board board = (Board)state.m_60734_();
                BoardState bstate = board.getBoardState(state);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)Board.STATE, (Comparable)((Object)bstate.select())));
            }
        }
    }

    public void deselect(Level level, ItemStack stack) {
        if (stack.m_41720_() instanceof SpellWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            ListTag list = nw.m_128437_("highlighted", 10);
            for (Tag inbt : list) {
                CompoundTag cnbt = (CompoundTag)inbt;
                BlockPos pos = new BlockPos(cnbt.m_128451_("x"), cnbt.m_128451_("y"), cnbt.m_128451_("z"));
                BlockState state = level.m_8055_(pos);
                if (!(state.m_60734_() instanceof Board)) continue;
                Board board = (Board)state.m_60734_();
                BoardState bstate = board.getBoardState(state);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)Board.STATE, (Comparable)((Object)bstate.deselect())));
            }
            this.setHighlighted(stack, null, new ArrayList<BlockPos>());
        }
    }

    public void setHighlighted(ItemStack stack, BlockPos origin, ArrayList<BlockPos> highlighted) {
        if (stack.m_41720_() instanceof SpellWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            nw.m_128473_("origin");
            nw.m_128473_("highlighted");
            if (origin != null) {
                CompoundTag originnbt = new CompoundTag();
                originnbt.m_128405_("x", origin.m_123341_());
                originnbt.m_128405_("y", origin.m_123342_());
                originnbt.m_128405_("z", origin.m_123343_());
                nw.m_128365_("origin", (Tag)originnbt);
            }
            ListTag ListTag2 = new ListTag();
            for (BlockPos pos : highlighted) {
                CompoundTag pnbt = new CompoundTag();
                pnbt.m_128405_("x", pos.m_123341_());
                pnbt.m_128405_("y", pos.m_123342_());
                pnbt.m_128405_("z", pos.m_123343_());
                ListTag2.add((Object)pnbt);
            }
            nw.m_128365_("highlighted", (Tag)ListTag2);
        }
    }

    public void setNBT(ItemStack stack, String ability) {
        if (stack.m_41720_() instanceof SpellWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            nw.m_128473_("spell");
            nw.m_128359_("spell", NWBasicMethods.getTranslation(ability));
        }
    }
}

