/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import slimeattack07.naval_warfare.NavalWarfare;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.objects.items.ShipConfiguration;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.ControllerState;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.UtilityMode;
import slimeattack07.naval_warfare.util.abilities.Seaworthy;
import slimeattack07.naval_warfare.util.helpers.ShipSaveHelper;

public class UtilityTool
extends Item {
    public UtilityTool() {
        super(new Item.Properties().m_41491_(NavalWarfare.NAVAL_WARFARE).m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        UtilityMode mode = this.getMode(context.m_43722_());
        if (state.m_60734_() instanceof GameController) {
            if (!this.validateInteraction(level, pos)) {
                NWBasicMethods.messagePlayer(player, "message.naval_warfare.utility_tool.only_in_edit");
                return InteractionResult.SUCCESS;
            }
            BlockEntity tile = level.m_7702_(pos);
            if (tile instanceof GameControllerTE) {
                GameControllerTE gte = (GameControllerTE)tile;
                if (gte.hasRegInBuffer()) {
                    NWBasicMethods.messagePlayer(player, "message.naval_warfare.still_randomizing");
                    return InteractionResult.SUCCESS;
                }
                tile = level.m_7702_(gte.getZero());
                if (tile instanceof BoardTE) {
                    BoardTE bte = (BoardTE)tile;
                    this.handleInteractionController(level, mode, gte, bte, player);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (state.m_60734_() instanceof ShipBlock) {
            BoardTE bte;
            if (!this.validateInteraction(level, pos)) {
                NWBasicMethods.messagePlayer(player, "message.naval_warfare.utility_tool.only_in_edit");
                return InteractionResult.SUCCESS;
            }
            if (!mode.equals((Object)UtilityMode.RANDOMIZE_PLACEMENT_ONE)) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity tile = level.m_7702_(pos.m_7495_());
            if (tile instanceof BoardTE && (tile = level.m_7702_((bte = (BoardTE)tile).getController())) instanceof GameControllerTE) {
                GameControllerTE gte = (GameControllerTE)tile;
                level.m_7471_(pos, true);
                gte.addRegisterToBuffer(state.m_60734_().getRegistryName().toString());
            }
        }
        return InteractionResult.SUCCESS;
    }

    private boolean validateInteraction(Level level, BlockPos pos) {
        BlockEntity tile;
        BlockPos c_pos = pos;
        BlockState state = level.m_8055_(c_pos);
        if (state.m_60734_() instanceof ShipBlock) {
            c_pos = pos.m_7495_();
            state = level.m_8055_(c_pos);
        }
        if (state.m_60734_().equals(NWBlocks.BOARD.get()) && (tile = level.m_7702_(c_pos)) instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            c_pos = te.getController();
            state = level.m_8055_(c_pos);
        }
        if (state.m_60734_() instanceof GameController) {
            GameController c = (GameController)state.m_60734_();
            return c.getState(state).equals((Object)ControllerState.EDIT_CONFIG);
        }
        return false;
    }

    private void handleInteractionController(Level level, UtilityMode mode, GameControllerTE gte, BoardTE bte, Player player) {
        Board board = (Board)bte.m_58900_().m_60734_();
        Direction facing = board.getControllerFacing(level, bte.m_58899_());
        block0 : switch (mode) {
            case RANDOMIZE_PLACEMENT_ALL: {
                ArrayList<ShipSaveHelper> ships = bte.collectShips(level, bte.m_58899_(), board.getControllerFacing(level, bte.m_58899_()), player);
                if (ships == null) {
                    return;
                }
                for (ShipSaveHelper ssh : ships) {
                    BlockPos ssh_pos = bte.locateId(bte.m_58899_(), ssh.getPos(), facing);
                    if (ssh_pos == null) continue;
                    ssh_pos = ssh_pos.m_7494_();
                    level.m_7471_(ssh_pos, true);
                }
                for (ShipSaveHelper ssh : ships) {
                    gte.addRegisterToBuffer(ssh.getShip().toString());
                }
                break;
            }
            case PLACE_RANDOM_SHIP: {
                String ship = this.returnRandomShip(gte.getHP(), gte.getRegistered(), player, true);
                if (ship == null) break;
                int extra_tiles = this.regnameToExtraTiles(ship);
                if (extra_tiles > 0) {
                    gte.setBoardSize(gte.getBoardSize() + extra_tiles);
                    gte.resetBoard(player);
                }
                gte.addRegisterToBuffer(ship);
                break;
            }
            case FILL_WITH_RANDOM_SHIPS: {
                int hp = gte.getHP();
                int extra_tiles = 0;
                ArrayList<String> registered = new ArrayList<String>(gte.getRegistered());
                ArrayList<String> ships = new ArrayList<String>();
                for (int i = 0; i < 1000; ++i) {
                    String ship = this.returnRandomShip(hp, registered, player, false);
                    if (ship != null) {
                        ships.add(ship);
                        registered.add(ship);
                        hp += this.regnameToHP(ship);
                        extra_tiles += this.regnameToExtraTiles(ship);
                        continue;
                    }
                    if (ships.isEmpty()) {
                        if (player.m_7500_() && player.m_6047_()) {
                            NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.utility_tool.failed_ship_gen");
                            break block0;
                        }
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.utility_tool.no_valid_ships");
                        break block0;
                    }
                    if (extra_tiles > 0) {
                        gte.setBoardSize(gte.getBoardSize() + extra_tiles);
                        gte.resetBoard(player);
                    }
                    for (String s : ships) {
                        gte.addRegisterToBuffer(s);
                    }
                    break block0;
                }
                break;
            }
        }
    }

    @Nullable
    private String returnRandomShip(int hp, ArrayList<String> registered, Player player, boolean message) {
        boolean creative;
        boolean bl = creative = player.m_7500_() && player.m_6047_();
        if (creative) {
            ArrayList<String> valid = this.fetchValidShips(hp, registered);
            if (!valid.isEmpty()) {
                ThreadLocalRandom rand = ThreadLocalRandom.current();
                int i = rand.nextInt(valid.size());
                return valid.get(i);
            }
            if (message) {
                NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.utility_tool.failed_ship_gen");
            }
        } else {
            ArrayList<ItemStack> ships = new ArrayList<ItemStack>();
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!stack.m_41720_().getTags().contains(new ResourceLocation("naval_warfare", "ships"))) continue;
                ships.add(stack);
            }
            if (!(ships = this.filterInvalidShips(hp, ships, registered)).isEmpty()) {
                ThreadLocalRandom rand = ThreadLocalRandom.current();
                int i = rand.nextInt(ships.size());
                return ships.get(i).m_41720_().getRegistryName().toString();
            }
            if (message) {
                NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.utility_tool.no_valid_ships");
            }
        }
        return null;
    }

    private int regnameToHP(String name) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        if (block != null && block instanceof ShipBlock) {
            ShipBlock ship = (ShipBlock)block;
            return ship.getMaxHP();
        }
        return 0;
    }

    private int regnameToExtraTiles(String name) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        if (block != null && block instanceof ShipBlock) {
            ShipBlock ship = (ShipBlock)block;
            return ship.hasPassiveAbility() && ship.PASSIVE_ABILITY instanceof Seaworthy ? ship.PASSIVE_ABILITY.getAmount() : 0;
        }
        return 0;
    }

    private ArrayList<ItemStack> filterInvalidShips(int hp, ArrayList<ItemStack> ships, ArrayList<String> registered) {
        ArrayList<ItemStack> valid = new ArrayList<ItemStack>();
        int max_hp_allowed = ShipConfiguration.MAX_HEALTH_ALLOWED - hp;
        max_hp_allowed = Math.min(max_hp_allowed, 5);
        String tag = "naval_warfare:ships_hp";
        ResourceLocation t1 = new ResourceLocation("naval_warfare", "ships_t1");
        block0: for (ItemStack stack : ships) {
            if (registered.contains(stack.m_41720_().getRegistryName().toString())) continue;
            Set tags = stack.m_41720_().getTags();
            for (int i = 2; i <= max_hp_allowed; ++i) {
                if (!tags.contains(new ResourceLocation(tag + i)) || tags.contains(t1)) continue;
                valid.add(stack);
                continue block0;
            }
        }
        return valid;
    }

    private ArrayList<String> fetchValidShips(int hp, ArrayList<String> registered) {
        ArrayList<String> valid = new ArrayList<String>();
        int max_hp_allowed = ShipConfiguration.MAX_HEALTH_ALLOWED - hp;
        max_hp_allowed = Math.min(max_hp_allowed, 5);
        String tag = "naval_warfare:ships_hp";
        ResourceLocation t1 = new ResourceLocation("naval_warfare", "ships_t1");
        block0: for (RegistryObject regob : NWBlocks.NW_SHIPS.getEntries()) {
            String name = ((Block)regob.get()).getRegistryName().toString();
            if (registered.contains(name)) continue;
            Set tags = ((Block)regob.get()).getTags();
            for (int i = 2; i <= max_hp_allowed; ++i) {
                if (!tags.contains(new ResourceLocation(tag + i)) || tags.contains(t1)) continue;
                valid.add(name);
                continue block0;
            }
        }
        return valid;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        this.cycleMode(stack);
        NWBasicMethods.messagePlayerActionbarBack(playerIn, "descriptions.naval_warfare.tool_mode", ": " + this.getMode(stack).getName());
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        this.prepare(stack);
        CompoundTag nbt = stack.m_41784_();
        CompoundTag nw = nbt.m_128469_("naval_warfare");
        tooltip.add((Component)NWBasicMethods.createGrayText("descriptions.naval_warfare.tool_mode", ": " + UtilityMode.valueOf(nw.m_128461_("mode")).getName()));
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    private void prepare(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("naval_warfare")) {
            CompoundTag nw = new CompoundTag();
            nw.m_128359_("mode", UtilityMode.RANDOMIZE_PLACEMENT_ONE.toString());
            nbt.m_128365_("naval_warfare", (Tag)nw);
            stack.m_41751_(nbt);
        }
    }

    public UtilityMode getMode(ItemStack stack) {
        if (stack.m_41720_() instanceof UtilityTool) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            return UtilityMode.valueOf(nw.m_128461_("mode"));
        }
        return UtilityMode.RANDOMIZE_PLACEMENT_ONE;
    }

    private void cycleMode(ItemStack stack) {
        if (stack.m_41720_() instanceof UtilityTool) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            String old_mode = nw.m_128461_("mode");
            UtilityMode mode = UtilityMode.valueOf(old_mode);
            if (mode != null) {
                mode = mode.cycle();
            }
            nw.m_128473_("mode");
            nw.m_128359_("mode", mode.toString());
        }
    }

    public void setMode(ItemStack stack, UtilityMode mode) {
        if (stack.m_41720_() instanceof UtilityTool) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            nw.m_128473_("mode");
            nw.m_128359_("mode", mode.toString());
        }
    }
}

