/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.structures;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class CaptainsCabin
extends StructureFeature<JigsawConfiguration> {
    public CaptainsCabin(Codec<JigsawConfiguration> codec) {
        super(codec, CaptainsCabin::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos pos = context.f_197355_().m_45615_();
        int landHeight = context.f_197352_().m_156179_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(pos.m_123341_(), pos.m_123343_(), context.f_197357_());
        BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
        return topBlock.m_60819_().m_76178_() && !CaptainsCabin.isNearVillage(context.f_197352_(), context.f_197354_(), context.f_197355_(), 5);
    }

    private static boolean isNearVillage(ChunkGenerator chunkGenerator, long seed, ChunkPos chunkPos, int range) {
        StructureFeatureConfiguration structurefeatureconfiguration = chunkGenerator.m_62205_().m_64593_(StructureFeature.f_67028_);
        if (structurefeatureconfiguration == null) {
            return false;
        }
        int chunkX = chunkPos.f_45578_;
        int chunkZ = chunkPos.f_45579_;
        for (int i = chunkX - range; i <= chunkX + range; ++i) {
            for (int j = chunkZ - range; j <= chunkZ + range; ++j) {
                ChunkPos chunkpos = StructureFeature.f_67028_.m_191122_(structurefeatureconfiguration, seed, i, j);
                if (i != chunkpos.f_45578_ || j != chunkpos.f_45579_) continue;
                return true;
            }
        }
        return false;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!CaptainsCabin.isFeatureChunk(context)) {
            return Optional.empty();
        }
        JigsawConfiguration config = new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175512_(Registry.f_122884_).m_7745_(new ResourceLocation("naval_warfare", "captains_cabin/start_pool")), 10);
        PieceGeneratorSupplier.Context new_context = new PieceGeneratorSupplier.Context(context.f_197352_(), context.f_197353_(), context.f_197354_(), context.f_197355_(), (FeatureConfiguration)config, context.f_197357_(), context.f_197358_(), context.f_197359_(), context.f_197360_());
        BlockPos pos = context.f_197355_().m_151394_(0);
        Optional structurePiecesGenerator = JigsawPlacement.m_197210_((PieceGeneratorSupplier.Context)new_context, PoolElementStructurePiece::new, (BlockPos)pos, (boolean)false, (boolean)true);
        return structurePiecesGenerator;
    }
}

