/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.tileentity;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.init.NWTileEntityTypes;
import slimeattack07.naval_warfare.objects.items.BattleLog;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.NBTHelper;
import slimeattack07.naval_warfare.util.helpers.ShipSaveHelper;

public class BattleRecorderTE
extends BlockEntity {
    public ArrayList<BattleLogHelper> actions = new ArrayList();
    public int own_size = 0;
    public int opp_size = 0;
    public ArrayList<ShipSaveHelper> own_ships = new ArrayList();
    public ArrayList<ShipSaveHelper> opp_ships = new ArrayList();
    public Direction own_dir = Direction.NORTH;
    public Direction opp_dir = Direction.NORTH;

    public BattleRecorderTE(BlockPos pos, BlockState state) {
        super((BlockEntityType)NWTileEntityTypes.BATTLE_RECORDER.get(), pos, state);
    }

    public ArrayList<BattleLogHelper> getActions() {
        return this.actions;
    }

    public ArrayList<ShipSaveHelper> getOwnShips() {
        return this.own_ships;
    }

    public ArrayList<ShipSaveHelper> getOppShips() {
        return this.opp_ships;
    }

    public void addAction(BattleLogHelper action) {
        this.actions.add(action);
    }

    public void addOwnShip(ShipSaveHelper ship) {
        this.own_ships.add(ship);
    }

    public void addOppShip(ShipSaveHelper ship) {
        this.opp_ships.add(ship);
    }

    public void setOwnShips(ArrayList<ShipSaveHelper> ssh) {
        this.own_ships = ssh;
    }

    public void setOppShips(ArrayList<ShipSaveHelper> ssh) {
        this.opp_ships = ssh;
    }

    public void setOwnSize(int size) {
        this.own_size = size;
    }

    public void setOppSize(int size) {
        this.opp_size = size;
    }

    public void setOwnDir(Direction dir) {
        this.own_dir = dir;
    }

    public void setOppDir(Direction dir) {
        this.opp_dir = dir;
    }

    public void reset() {
        this.actions.clear();
        this.own_ships.clear();
        this.opp_ships.clear();
        this.own_size = 0;
        this.opp_size = 0;
        this.own_dir = Direction.NORTH;
        this.opp_dir = Direction.NORTH;
    }

    public void generateLog(Player player, String p1, String p2) {
        if (!this.actions.isEmpty()) {
            ItemStack stack = new ItemStack((ItemLike)NWItems.BATTLE_LOG.get());
            Date now = new Date();
            SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            String name = p1 + " vs " + p2 + " (" + format.format(now) + ")";
            CompoundTag tag = NBTHelper.toNBT((Object)this);
            BattleLog log = (BattleLog)stack.m_41720_();
            tag.m_128359_("info", name);
            log.setLog(stack, tag);
            NWBasicMethods.addOrSpawn(player, stack, this.f_58857_, this.f_58858_.m_7494_());
        }
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("naval_warfare", (Tag)NBTHelper.toNBT((Object)this));
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        CompoundTag initvalues = compound.m_128469_("naval_warfare");
        if (initvalues != null) {
            ShipSaveHelper ssh;
            CompoundTag cnbt;
            ListTag list;
            this.own_size = initvalues.m_128451_("own_size");
            this.opp_size = initvalues.m_128451_("opp_size");
            this.own_dir = Direction.valueOf((String)initvalues.m_128461_("own_dir"));
            this.opp_dir = Direction.valueOf((String)initvalues.m_128461_("opp_dir"));
            this.actions = new ArrayList();
            if (initvalues.m_128441_("actions")) {
                list = initvalues.m_128437_("actions", 10);
                for (Tag nbt : list) {
                    cnbt = (CompoundTag)nbt;
                    BattleLogHelper cah = NBTHelper.readBLH(cnbt);
                    this.addAction(cah);
                }
            }
            this.own_ships = new ArrayList();
            if (initvalues.m_128441_("own_ships")) {
                list = initvalues.m_128437_("own_ships", 10);
                for (Tag nbt : list) {
                    cnbt = (CompoundTag)nbt;
                    ssh = NBTHelper.readSSH(cnbt);
                    this.addOwnShip(ssh);
                }
            }
            this.opp_ships = new ArrayList();
            if (initvalues.m_128441_("opp_ships")) {
                list = initvalues.m_128437_("opp_ships", 10);
                for (Tag nbt : list) {
                    cnbt = (CompoundTag)nbt;
                    ssh = NBTHelper.readSSH(cnbt);
                    this.addOppShip(ssh);
                }
            }
        }
    }
}

