/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.tileentity;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import slimeattack07.naval_warfare.NavalWarfare;
import slimeattack07.naval_warfare.init.NWTileEntityTypes;
import slimeattack07.naval_warfare.objects.blocks.BattleViewer;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.DirectionalDisBlock;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.ViewerState;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.NBTHelper;

public class BattleViewerTE
extends BlockEntity {
    public ArrayList<BattleLogHelper> actions = new ArrayList();
    public boolean playing = false;
    public int timer = 0;
    public BlockPos zero = null;
    public BlockPos opponent_zero = null;
    public float speed = 1.0f;
    public UUID uuid = null;

    public BattleViewerTE(BlockPos pos, BlockState state) {
        super((BlockEntityType)NWTileEntityTypes.BATTLE_VIEWER.get(), pos, state);
    }

    public ArrayList<BattleLogHelper> getActions() {
        return this.actions;
    }

    public void addAction(BattleLogHelper action) {
        this.actions.add(action);
    }

    public void setActions(ListTag new_actions) {
        this.actions.clear();
        for (Tag tag : new_actions) {
            CompoundTag ctag = (CompoundTag)tag;
            BattleLogHelper blh = NBTHelper.readBLH(ctag);
            this.actions.add(blh);
        }
    }

    public void reset() {
        this.playing = false;
        if (this.zero != null && this.f_58857_.m_8055_(this.zero).m_60734_() instanceof Board) {
            this.f_58857_.m_46597_(this.zero, Blocks.f_50016_.m_49966_());
        }
        this.actions.clear();
        this.zero = null;
        this.opponent_zero = null;
        this.timer = 0;
        BlockState state = this.m_58900_();
        if (state.m_60734_() instanceof BattleViewer) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)BattleViewer.VIEWER_STATE, (Comparable)((Object)ViewerState.IDLE)));
        }
    }

    public void setZero(BlockPos new_zero) {
        this.zero = new_zero;
    }

    public void setOpponentZero(BlockPos new_opponent_zero) {
        this.opponent_zero = new_opponent_zero;
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("naval_warfare", (Tag)NBTHelper.toNBT((Object)this));
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        CompoundTag initvalues = compound.m_128469_("naval_warfare");
        if (initvalues != null) {
            this.playing = initvalues.m_128471_("playing");
            this.timer = initvalues.m_128451_("timer");
            this.zero = NBTHelper.readBlockPos(initvalues.m_128469_("zero"));
            this.opponent_zero = NBTHelper.readBlockPos(initvalues.m_128469_("opponent_zero"));
            this.speed = initvalues.m_128457_("speed");
            String u = initvalues.m_128461_("uuid");
            try {
                this.uuid = UUID.fromString(u);
            }
            catch (IllegalArgumentException e) {
                this.uuid = null;
            }
            this.actions = new ArrayList();
            if (initvalues.m_128441_("actions")) {
                ListTag list = initvalues.m_128437_("actions", 10);
                for (Tag nbt : list) {
                    CompoundTag cnbt = (CompoundTag)nbt;
                    BattleLogHelper cah = NBTHelper.readBLH(cnbt);
                    this.addAction(cah);
                }
            }
        }
    }

    private boolean hasActions() {
        return !this.actions.isEmpty();
    }

    public BlockPos findBoard(int id, boolean opponent) {
        BlockEntity ztile;
        if (this.zero == null || this.opponent_zero == null) {
            return null;
        }
        BlockEntity blockEntity = ztile = opponent ? this.f_58857_.m_7702_(this.opponent_zero) : this.f_58857_.m_7702_(this.zero);
        if (ztile instanceof BoardTE) {
            BoardTE zte = (BoardTE)ztile;
            return zte.locateId(zte.m_58899_(), id, this.getFacing());
        }
        return null;
    }

    private Direction getFacing() {
        BattleViewer viewer = (BattleViewer)this.m_58900_().m_60734_();
        return viewer.getFacing(this.m_58900_());
    }

    private void removeFirstAction() {
        this.actions.remove(0);
    }

    private void updateViewerState(boolean opponent) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof BattleViewer) {
            ViewerState v_state = opponent ? ViewerState.OPPONENT : ViewerState.OWN;
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BattleViewer.VIEWER_STATE, (Comparable)((Object)v_state)));
        }
    }

    private void tryAction() {
        BattleLogHelper blh = this.actions.get(0);
        if (blh.action == null) {
            NavalWarfare.LOGGER.warn("BattleViewer BlockEntity at " + this.f_58858_.m_123344_() + " got corrupt action. Skipping action: " + blh);
            this.removeFirstAction();
            return;
        }
        if (blh.action.updateViewerState()) {
            this.updateViewerState(blh.opponent);
        }
        switch (blh.action) {
            case DELAY: {
                this.removeFirstAction();
                break;
            }
            case BOARDSTATE: {
                this.doBoardStateAction(blh);
                break;
            }
            case DROP_BLOCK: {
                this.doDropAction(blh);
                break;
            }
            case DROP_BLOCKS: {
                this.doDropsAction(blh);
                break;
            }
            case SHIPSTATE: {
                this.doShipStateAction(blh);
                break;
            }
            case PLAY_SOUND: {
                this.doSoundAction(blh);
                break;
            }
            case PLAY_SOUNDS: {
                this.doSoundsAction(blh);
                break;
            }
            case SUMMON_DEPLOYABLE: {
                this.doDeployableAction(blh);
                break;
            }
            case SET_BLOCK: {
                this.doSetBlockAction(blh);
                break;
            }
            case SET_BLOCKS: {
                this.doSetBlocksAction(blh);
                break;
            }
            case SET_DIS_BLOCK: {
                this.doSetDisBlockAction(blh);
                break;
            }
            case MESSAGE: {
                this.doMessageAction(blh);
                break;
            }
            default: {
                NavalWarfare.LOGGER.warn("I don't know how to execute this action! Please report this to the mod author! Action is: " + blh);
                this.removeFirstAction();
            }
        }
    }

    private boolean shouldDoAction() {
        if (this.speed == 0.0f) {
            this.speed = 1.0f;
        }
        return !this.actions.isEmpty() && (float)this.timer >= (float)this.actions.get((int)0).delay / this.speed;
    }

    private void doMessageAction(BattleLogHelper blh) {
        if (this.uuid == null) {
            this.removeFirstAction();
            return;
        }
        Player player = this.f_58857_.m_46003_(this.uuid);
        if (blh.message != null && player != null) {
            player.m_6352_((Component)Component.Serializer.m_130701_((String)blh.message), Util.f_137441_);
        }
        this.removeFirstAction();
    }

    private void doDeployableAction(BattleLogHelper blh) {
        BlockPos pos = this.findBoard(blh.id, blh.opponent);
        if (pos != null && blh.resource != null) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(blh.resource);
            pos = pos.m_7494_();
            if (block != null && block instanceof ShipBlock) {
                ShipBlock ship = (ShipBlock)block;
                boolean success = ship.summonShip(this.f_58857_, pos, (BlockState)ship.m_49966_().m_61124_((Property)ShipBlock.FACING, (Comparable)blh.dir), true, false);
                BlockEntity tile = this.f_58857_.m_7702_(pos);
                if (success && tile instanceof BoardTE && ship.hasPassiveAbility() && ship.PASSIVE_ABILITY.getPassiveType().equals((Object)PassiveType.DEPLOYED)) {
                    BoardTE bte = (BoardTE)tile;
                    ship.PASSIVE_ABILITY.activate(this.f_58857_, null, bte);
                }
            }
        }
        this.removeFirstAction();
    }

    private void doBoardStateAction(BattleLogHelper blh) {
        BlockState state;
        BlockPos pos = this.findBoard(blh.id, blh.opponent);
        if (pos != null && blh.board_state != null && (state = this.f_58857_.m_8055_(pos)).m_60734_() instanceof Board) {
            this.f_58857_.m_46597_(pos, (BlockState)state.m_61124_((Property)Board.STATE, (Comparable)((Object)blh.board_state)));
        }
        this.removeFirstAction();
    }

    private void doSetBlockAction(BattleLogHelper blh) {
        BlockPos pos = this.findBoard(blh.id, blh.opponent);
        if (pos != null && blh.resource != null) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(blh.resource);
            BlockState state = this.f_58857_.m_8055_(pos);
            if (state.m_60734_() instanceof Board) {
                this.f_58857_.m_46597_(pos.m_6630_(blh.offset), block.m_49966_());
            }
        }
        this.removeFirstAction();
    }

    private void doSetBlocksAction(BattleLogHelper blh) {
        if (blh.positions != null) {
            for (int id : blh.positions) {
                BlockPos pos = this.findBoard(id, blh.opponent);
                if (pos == null || blh.resource == null) continue;
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(blh.resource);
                BlockState state = this.f_58857_.m_8055_(pos);
                if (!(state.m_60734_() instanceof Board)) continue;
                this.f_58857_.m_46597_(pos.m_6630_(blh.offset), block.m_49966_());
            }
        }
        this.removeFirstAction();
    }

    private void doSetDisBlockAction(BattleLogHelper blh) {
        BlockPos pos = this.findBoard(blh.id, blh.opponent);
        if (pos != null && blh.resource != null) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(blh.resource);
            BlockState state = this.f_58857_.m_8055_(pos);
            if (state.m_60734_() instanceof Board && block != null) {
                BlockState dis_state = block.m_49966_();
                if (block instanceof DirectionalDisBlock && blh.dir != null) {
                    Direction dir = NWBasicMethods.rotateToMatch(blh.dir, this.getFacing(), blh.dir);
                    dis_state = (BlockState)dis_state.m_61124_((Property)DirectionalDisBlock.FACING, (Comparable)dir);
                }
                this.f_58857_.m_46597_(pos.m_6630_(blh.offset), dis_state);
            }
        }
        this.removeFirstAction();
    }

    private void doShipStateAction(BattleLogHelper blh) {
        BlockState state;
        BlockPos pos = this.findBoard(blh.id, blh.opponent);
        if (pos != null && blh.ship_state != null && (state = this.f_58857_.m_8055_(pos.m_7494_())).m_60734_() instanceof ShipBlock) {
            this.f_58857_.m_46597_(pos.m_7494_(), (BlockState)state.m_61124_((Property)ShipBlock.SHIP_STATE, (Comparable)((Object)blh.ship_state)));
        }
        this.removeFirstAction();
    }

    private void doDropAction(BattleLogHelper blh) {
        BlockPos pos;
        Block block;
        if (blh.resource != null && (block = (Block)ForgeRegistries.BLOCKS.getValue(blh.resource)) != null && (pos = this.findBoard(blh.id, blh.opponent)) != null) {
            NWBasicMethods.dropBlock(this.f_58857_, pos, block);
        }
        this.removeFirstAction();
    }

    private void doDropsAction(BattleLogHelper blh) {
        Block block;
        if (blh.resource != null && blh.positions != null && (block = (Block)ForgeRegistries.BLOCKS.getValue(blh.resource)) != null) {
            for (int i : blh.positions) {
                BlockPos pos = this.findBoard(i, blh.opponent);
                if (pos == null) continue;
                NWBasicMethods.dropBlock(this.f_58857_, pos, block);
            }
        }
        this.removeFirstAction();
    }

    private void doSoundAction(BattleLogHelper blh) {
        BlockPos pos;
        if (blh.sound != null && (pos = this.findBoard(blh.id, blh.opponent)) != null) {
            this.f_58857_.m_5594_(null, pos, blh.sound, SoundSource.MASTER, blh.volume, blh.pitch);
        }
        this.removeFirstAction();
    }

    private void doSoundsAction(BattleLogHelper blh) {
        if (blh.sound != null && blh.positions != null) {
            for (int i : blh.positions) {
                BlockPos pos = this.findBoard(i, blh.opponent);
                if (pos == null) continue;
                this.f_58857_.m_5594_(null, pos, blh.sound, SoundSource.MASTER, blh.volume, blh.pitch);
            }
        }
        this.removeFirstAction();
    }

    public void tick() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.hasActions() && this.playing) {
            if (this.shouldDoAction()) {
                this.tryAction();
                this.timer = this.hasActions() ? 0 : -GameControllerTE.CLEAR_BOARD_TIME;
            } else {
                ++this.timer;
            }
            this.m_6596_();
        }
        if (this.timer < -1) {
            ++this.timer;
        } else if (this.timer == -1) {
            this.reset();
        }
    }
}

