/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.tileentity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWTileEntityTypes;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.ControllerState;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.ShipState;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.helpers.NBTHelper;
import slimeattack07.naval_warfare.util.helpers.ShipInfoHelper;
import slimeattack07.naval_warfare.util.helpers.ShipSaveHelper;

public class BoardTE
extends BlockEntity {
    public BlockPos controller = null;
    public int board_id = -1;

    public BoardTE(BlockPos pos, BlockState state) {
        super((BlockEntityType)NWTileEntityTypes.BOARD.get(), pos, state);
    }

    public boolean hasController() {
        return this.controller != null;
    }

    public BlockPos getController() {
        return this.controller;
    }

    public int getId() {
        return this.board_id;
    }

    public boolean hasId() {
        return this.board_id >= 0;
    }

    public boolean isShipRegistered(String ship) {
        Board board = (Board)this.m_58900_().m_60734_();
        GameControllerTE te = board.getController(this.f_58857_, this.f_58858_);
        if (te == null) {
            return false;
        }
        return te.isRegistered(ship);
    }

    public boolean canReceiveShip(String ship) {
        Board board = (Board)this.m_58900_().m_60734_();
        GameControllerTE te = board.getController(this.f_58857_, this.f_58858_);
        if (te == null) {
            return false;
        }
        GameController controller = (GameController)te.m_58900_().m_60734_();
        return controller.getState(te.m_58900_()).equals((Object)ControllerState.EDIT_CONFIG);
    }

    private int propagateControllerAndId(Level level, BlockPos pos, BlockPos con, int free_id, Direction[] order) {
        BlockEntity tile;
        BlockState state = level.m_8055_(pos);
        if (state.m_155947_() && (tile = level.m_7702_(pos)) instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            return te.setControllerAndId(con, free_id, order);
        }
        return free_id;
    }

    public int setControllerAndId(BlockPos con, int free_id, Direction[] order) {
        if (order.length != 2) {
            return -1;
        }
        this.controller = con;
        this.board_id = free_id;
        int new_free_id = free_id + 1;
        new_free_id = this.propagateControllerAndId(this.f_58857_, this.f_58858_.m_142300_(order[0]), con, new_free_id, order);
        if (!(this.f_58857_.m_7702_(this.f_58858_.m_142300_(order[0].m_122424_())) instanceof BoardTE)) {
            new_free_id = this.propagateControllerAndId(this.f_58857_, this.f_58858_.m_142300_(order[1]), con, new_free_id, order);
        }
        return new_free_id;
    }

    public int setControllerAndId(BlockPos con, int free_id, Direction facing) {
        return this.setControllerAndId(con, free_id, this.getPropagationOrder(facing));
    }

    public ArrayList<ShipSaveHelper> collectShips(Level level, BlockPos pos, Direction dir, Player player) {
        return this.collectShips(level, pos, this.getPropagationOrder(dir), new ArrayList<ShipSaveHelper>(), player);
    }

    public ArrayList<ShipSaveHelper> collectShips(Level level, BlockPos pos, Direction[] order, ArrayList<ShipSaveHelper> ships, Player player) {
        ShipBlock ship;
        if (ships == null || order.length != 2) {
            return null;
        }
        if (!(level.m_7702_(pos) instanceof BoardTE)) {
            return ships;
        }
        BlockState state = level.m_8055_(pos.m_7494_());
        if (state.m_60734_() instanceof ShipBlock && (ship = (ShipBlock)state.m_60734_()).isBase(state)) {
            if (!ship.isRegistered(level, pos)) {
                ships = null;
                NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.contains_unregistered");
                return null;
            }
            int board_pos = ((BoardTE)level.m_7702_(pos)).getId();
            ShipSaveHelper ssh = new ShipSaveHelper(ship.getRegistryName(), board_pos, ShipBlock.getFacing(state), ship.getMaxHP());
            if (ships.contains(ssh)) {
                NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.contains_double");
                ships = null;
                return null;
            }
            ships.add(ssh);
        }
        if (this.collectShips(level, pos.m_142300_(order[0]), order, ships, player) == null) {
            return null;
        }
        if (!(level.m_7702_(pos.m_142300_(order[0].m_122424_())) instanceof BoardTE) && this.collectShips(level, pos.m_142300_(order[1]), order, ships, player) == null) {
            return null;
        }
        return ships;
    }

    public ArrayList<ShipInfoHelper> collectShipsInfo(Level level, BlockPos pos, Direction dir) {
        return this.collectShipsInfo(level, pos, this.getPropagationOrder(dir), new ArrayList<ShipInfoHelper>());
    }

    public ArrayList<ShipInfoHelper> collectShipsInfo(Level level, BlockPos pos, Direction[] order, ArrayList<ShipInfoHelper> ships) {
        ShipBlock ship;
        if (order.length != 2) {
            return null;
        }
        if (!(level.m_7702_(pos) instanceof BoardTE)) {
            return ships;
        }
        BlockState state = level.m_8055_(pos.m_7494_());
        if (state.m_60734_() instanceof ShipBlock && (ship = (ShipBlock)state.m_60734_()).isBase(state)) {
            String active = ship.hasActiveAbility() ? NWBasicMethods.getTranslation(ship.ACTIVE_ABILITY.getTranslation()) : NWBasicMethods.getTranslation("abilities.naval_warfare.none");
            String passive = ship.hasPassiveAbility() ? NWBasicMethods.getTranslation(ship.PASSIVE_ABILITY.getTranslation()) : NWBasicMethods.getTranslation("abilities.naval_warfare.none");
            String ship_state = ShipBlock.getState(state).isAlive() ? "misc.naval_warfare.alive" : "misc.naval_warfare.destroyed";
            ShipInfoHelper sih = new ShipInfoHelper(NWBasicMethods.getTranslation(ship), active, passive, ship.getShape(), ship_state);
            if (!ships.contains(sih)) {
                ships.add(sih);
            }
        }
        this.collectShipsInfo(level, pos.m_142300_(order[0]), order, ships);
        if (!(level.m_7702_(pos.m_142300_(order[0].m_122424_())) instanceof BoardTE)) {
            this.collectShipsInfo(level, pos.m_142300_(order[1]), order, ships);
        }
        return ships;
    }

    public void activateStartPassives(Level level, Player player, BlockPos pos, Direction[] order) {
        Board board;
        BlockState boardstate;
        Ability ability;
        ShipBlock ship;
        if (!(level.m_7702_(pos) instanceof BoardTE) || order.length != 2) {
            return;
        }
        BlockState state = level.m_8055_(pos.m_7494_());
        if (state.m_60734_() instanceof ShipBlock && (ship = (ShipBlock)state.m_60734_()).isMiddle(state) && ship.hasPassiveAbility() && (ability = ship.PASSIVE_ABILITY).getPassiveType().equals((Object)PassiveType.START_GAME) && (boardstate = level.m_8055_(pos)).m_60734_() instanceof Board && (board = (Board)boardstate.m_60734_()).validateBoard(level, pos)) {
            BoardTE te = (BoardTE)level.m_7702_(pos);
            ability.activate(level, player, te);
            NWBasicMethods.messagePlayerAbilityUsed(board.getController(level, pos), player, "ability.naval_warfare.passive_deployed", null, ability.hoverableInfo());
        }
        this.activateStartPassives(level, player, pos.m_142300_(order[0]), order);
        if (!(level.m_7702_(pos.m_142300_(order[0].m_122424_())) instanceof BoardTE)) {
            this.activateStartPassives(level, player, pos.m_142300_(order[1]), order);
        }
    }

    public BlockPos locateId(BlockPos pos, int target, Direction[] order) {
        if (!(this.f_58857_.m_7702_(pos) instanceof BoardTE)) {
            return null;
        }
        if (this.checkCorrectId(this.f_58857_, pos, target)) {
            return pos;
        }
        BlockPos id = this.locateId(pos.m_142300_(order[0]), target, order);
        if (id != null) {
            return id;
        }
        if (!(this.f_58857_.m_7702_(pos.m_142300_(order[0].m_122424_())) instanceof BoardTE)) {
            return this.locateId(pos.m_142300_(order[1]), target, order);
        }
        return null;
    }

    private BlockPos locateZero(Level level, BlockPos pos, boolean opponent) {
        GameController controller;
        BoardTE te;
        Block block_c;
        Board board;
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof Board && (board = (Board)block).validateBoard(level, pos) && (block_c = level.m_8055_((te = (BoardTE)level.m_7702_(pos)).getController()).m_60734_()) instanceof GameController && (controller = (GameController)block_c).validateController(level, te.getController())) {
            GameControllerTE gc_te = (GameControllerTE)level.m_7702_(te.getController());
            return opponent ? gc_te.getOpponentZero() : gc_te.getZero();
        }
        return pos;
    }

    public BlockPos locateId(BlockPos pos, int target, Direction dir, boolean opponent) {
        return this.locateId(this.locateZero(this.f_58857_, pos, opponent), target, this.getPropagationOrder(dir));
    }

    public BlockPos locateId(BlockPos pos, int target, Direction dir) {
        return this.locateId(pos, target, dir, false);
    }

    private boolean checkCorrectId(Level level, BlockPos pos, int id) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            return te.board_id == id;
        }
        return false;
    }

    public void activateStartPassives(Level level, Player player, BlockPos pos, Direction dir) {
        this.activateStartPassives(level, player, pos, this.getPropagationOrder(dir));
    }

    private Direction[] getPropagationOrder(Direction facing) {
        switch (facing) {
            case NORTH: {
                return new Direction[]{Direction.NORTH, Direction.WEST};
            }
            case EAST: {
                return new Direction[]{Direction.EAST, Direction.NORTH};
            }
            case SOUTH: {
                return new Direction[]{Direction.SOUTH, Direction.EAST};
            }
            case WEST: {
                return new Direction[]{Direction.WEST, Direction.SOUTH};
            }
        }
        return new Direction[]{Direction.NORTH, Direction.WEST};
    }

    public ArrayList<BoardTE> collectTiles(int amount, Direction dir) {
        ArrayList<BoardTE> tiles = new ArrayList<BoardTE>();
        int seen = 0;
        while (seen < amount) {
            BlockPos newpos = this.f_58858_.m_5484_(dir, seen);
            Block block = this.m_58904_().m_8055_(newpos).m_60734_();
            if (!(block instanceof Board)) break;
            Board board = (Board)block;
            if (!board.validateBoard(this.f_58857_, newpos)) continue;
            tiles.add((BoardTE)this.f_58857_.m_7702_(newpos));
            ++seen;
        }
        return tiles;
    }

    public ArrayList<BoardTE> collectUnknownTiles(boolean opponent) {
        BlockPos zero = this.locateZero(this.f_58857_, this.f_58858_, opponent);
        BlockEntity tile = this.f_58857_.m_7702_(zero);
        ArrayList<Object> tiles = new ArrayList();
        ArrayList<BoardTE> empty = new ArrayList<BoardTE>();
        if (tile instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            Board board = (Board)te.m_58900_().m_60734_();
            tiles = te.collectTileArea(1000, 1000, 1000, 1000, board.getControllerFacing(this.f_58857_, te.f_58858_));
            for (BoardTE boardTE : tiles) {
                Board b = (Board)boardTE.m_58900_().m_60734_();
                if (b.getBoardState(boardTE.m_58900_()).isKnown()) continue;
                empty.add(boardTE);
            }
        }
        return empty;
    }

    public ArrayList<BoardTE> collectUndamagedShips(boolean opponent, boolean unique, boolean origin, int length, int width) {
        BoardTE tile = this;
        if (origin) {
            BlockPos zero = this.locateZero(this.f_58857_, this.f_58858_, opponent);
            tile = this.f_58857_.m_7702_(zero);
        }
        ArrayList<BoardTE> undamaged = new ArrayList<BoardTE>();
        if (tile instanceof BoardTE) {
            BoardTE te = tile;
            Board board = (Board)te.m_58900_().m_60734_();
            GameControllerTE controller = board.getController(this.f_58857_, te.m_58899_());
            if (controller == null) {
                return new ArrayList<BoardTE>();
            }
            double l = (length + 1) / 2;
            double w = (width + 1) / 2;
            ArrayList<BoardTE> tiles = te.collectTileArea((int)Math.ceil(l), (int)Math.floor(l), (int)Math.ceil(w), (int)Math.floor(w), board.getControllerFacing(this.f_58857_, te.f_58858_));
            GameController control = (GameController)controller.m_58900_().m_60734_();
            ArrayList<String> known = new ArrayList<String>();
            for (BoardTE bte : tiles) {
                BoardTE matching = control.getOpponentBoardTile(this.f_58857_, controller, bte.getId(), false);
                BlockState state = opponent ? this.f_58857_.m_8055_(matching.m_58899_().m_7494_()) : this.f_58857_.m_8055_(bte.m_58899_().m_7494_());
                if (!(state.m_60734_() instanceof ShipBlock) || !ShipBlock.getState(state).equals((Object)ShipState.UNDAMAGED)) continue;
                known.add(state.m_60734_().getRegistryName().toString());
                undamaged.add(bte);
            }
            if (unique) {
                undamaged = this.filterUnique(undamaged, known);
            }
        }
        return undamaged;
    }

    public ArrayList<BoardTE> filterUnique(ArrayList<BoardTE> tiles, ArrayList<String> names) {
        ArrayList<BoardTE> filtered = new ArrayList<BoardTE>();
        ArrayList<String> unique = new ArrayList<String>();
        ArrayList<BoardTE> buffer = new ArrayList<BoardTE>();
        if (tiles.size() != names.size()) {
            return filtered;
        }
        for (int i = 0; i < tiles.size(); ++i) {
            String name = names.get(i);
            if (unique.contains(name)) continue;
            buffer.clear();
            unique.add(name);
            for (int k = 0; k < tiles.size(); ++k) {
                if (!names.get(k).equals(name)) continue;
                buffer.add(tiles.get(k));
            }
            filtered.addAll(this.selectRandom(1, buffer));
        }
        return filtered;
    }

    public ArrayList<BoardTE> collectUnknownEmptyTiles(boolean opponent) {
        BlockPos zero = this.locateZero(this.f_58857_, this.f_58858_, opponent);
        BlockEntity tile = this.f_58857_.m_7702_(zero);
        ArrayList<Object> tiles = new ArrayList();
        ArrayList<BoardTE> undamaged = new ArrayList<BoardTE>();
        if (tile instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            Board board = (Board)te.m_58900_().m_60734_();
            GameControllerTE controller = board.getController(this.f_58857_, te.m_58899_());
            if (controller == null) {
                return new ArrayList<BoardTE>();
            }
            GameController control = (GameController)controller.m_58900_().m_60734_();
            tiles = te.collectTileArea(1000, 1000, 1000, 1000, board.getControllerFacing(this.f_58857_, te.f_58858_));
            for (BoardTE boardTE : tiles) {
                BoardTE matching = control.getOpponentBoardTile(this.f_58857_, controller, boardTE.getId(), false);
                Board b = (Board)matching.m_58900_().m_60734_();
                BlockState state = this.f_58857_.m_8055_(matching.m_58899_().m_7494_());
                if (state.m_60734_() instanceof ShipBlock || b.getBoardState(matching.m_58900_()).isKnown()) continue;
                undamaged.add(boardTE);
            }
        }
        return undamaged;
    }

    public ArrayList<BoardTE> selectRandomTiles(int amount, boolean opponent, boolean empty) {
        if (amount <= 0) {
            return new ArrayList<BoardTE>();
        }
        return empty ? this.selectRandom(amount, this.collectUnknownEmptyTiles(opponent)) : this.selectRandom(amount, this.collectUnknownTiles(opponent));
    }

    public ArrayList<BoardTE> selectRandomShip(int amount, boolean opponent, boolean unique, boolean origin, int length, int width) {
        return this.selectRandom(amount, this.collectUndamagedShips(opponent, unique, origin, length, width));
    }

    public ArrayList<BoardTE> selectRandom(int amount, ArrayList<BoardTE> tiles) {
        if (amount >= tiles.size()) {
            return tiles;
        }
        Collections.shuffle(tiles);
        return (ArrayList)tiles.stream().limit(amount).collect(Collectors.toList());
    }

    public ArrayList<BoardTE> collectTileArea(int up, int down, int left, int right, Direction dir) {
        HashSet<BoardTE> tiles = new HashSet<BoardTE>();
        tiles.addAll(this.collectTiles(left, dir.m_122428_()));
        tiles.addAll(this.collectTiles(right, dir.m_122427_()));
        HashSet<BoardTE> tiles_up = new HashSet<BoardTE>();
        HashSet<BoardTE> tiles_down = new HashSet<BoardTE>();
        for (BoardTE tile : tiles) {
            tiles_up.addAll(tile.collectTiles(up, dir));
            tiles_down.addAll(tile.collectTiles(down, dir.m_122424_()));
        }
        tiles_up.addAll(tiles_down);
        return new ArrayList<BoardTE>(tiles_up);
    }

    public BoardTE getOpponentBoardZero() {
        BlockPos bpos = this.locateZero(this.f_58857_, this.f_58858_, true);
        BlockEntity tile = this.f_58857_.m_7702_(bpos);
        if (tile instanceof BoardTE) {
            return (BoardTE)tile;
        }
        return null;
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("naval_warfare", (Tag)NBTHelper.toNBT((Object)this));
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        CompoundTag initvalues = compound.m_128469_("naval_warfare");
        if (initvalues != null) {
            CompoundTag control = initvalues.m_128469_("controller");
            this.controller = control.m_128441_("no_pos") ? null : new BlockPos(control.m_128451_("x"), control.m_128451_("y"), control.m_128451_("z"));
            this.board_id = initvalues.m_128451_("board_id");
        }
    }

    public int hashCode() {
        return Objects.hash(this.board_id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BoardTE other = (BoardTE)((Object)obj);
        return this.board_id == other.board_id;
    }
}

