/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.tileentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.tileentity.PassiveAbilityTE;
import slimeattack07.naval_warfare.util.helpers.NBTHelper;

public class EnergyShieldTE
extends PassiveAbilityTE {
    private int hp = -1;
    private int last_action = -1;

    public EnergyShieldTE(BlockPos pos, BlockState state) {
        super(pos, state, true);
    }

    public int getHP() {
        return this.hp;
    }

    public void initHP(int health) {
        if (health > this.hp) {
            this.hp = health;
        }
    }

    public void setHP(int health) {
        this.hp = health;
    }

    public void decreaseHP(int amount) {
        this.hp -= amount;
    }

    public boolean alive() {
        return this.hp > 0;
    }

    public int getLastAction() {
        return this.last_action;
    }

    public void setLastAction(int action) {
        this.last_action = action;
    }

    public boolean mayDamage(int action) {
        return action > this.last_action;
    }

    public void propagateHP(Level level, String owner) {
        ++this.hp;
        this.propagateHPHelper(level, this.hp - 1, this.last_action, owner, new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
    }

    public void propagateHPHelper(Level level, int health, int action, String owner, Direction[] dirs) {
        if (this.hp == health || !this.owners.contains(owner)) {
            return;
        }
        this.hp = health;
        this.last_action = action;
        for (Direction dir : dirs) {
            BlockEntity tile = level.m_7702_(this.f_58858_.m_142300_(dir));
            if (!(tile instanceof EnergyShieldTE)) continue;
            EnergyShieldTE te = (EnergyShieldTE)tile;
            te.propagateHPHelper(level, health, action, owner, dirs);
        }
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("naval_warfare", (Tag)NBTHelper.toNBT((Object)this));
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        CompoundTag initvalues = compound.m_128469_("naval_warfare");
        if (initvalues != null) {
            this.hp = initvalues.m_128451_("hp");
            this.last_action = initvalues.m_128451_("last_action");
        }
    }
}

