/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.tileentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import slimeattack07.naval_warfare.NavalWarfare;
import slimeattack07.naval_warfare.config.NavalWarfareConfig;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.init.NWSounds;
import slimeattack07.naval_warfare.init.NWStats;
import slimeattack07.naval_warfare.init.NWTileEntityTypes;
import slimeattack07.naval_warfare.init.NWTriggers;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.DirectionalDisBlock;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.objects.blocks.ShipMarkerBlock;
import slimeattack07.naval_warfare.objects.items.ShipConfiguration;
import slimeattack07.naval_warfare.objects.items.SpellWand;
import slimeattack07.naval_warfare.tileentity.BattleRecorderTE;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.DisappearingTE;
import slimeattack07.naval_warfare.util.BattleLogAction;
import slimeattack07.naval_warfare.util.BoardState;
import slimeattack07.naval_warfare.util.ControllerAction;
import slimeattack07.naval_warfare.util.ControllerState;
import slimeattack07.naval_warfare.util.HitResult;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.ShipState;
import slimeattack07.naval_warfare.util.TargetType;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.Napalm;
import slimeattack07.naval_warfare.util.abilities.Seaworthy;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;
import slimeattack07.naval_warfare.util.helpers.NBTHelper;
import slimeattack07.naval_warfare.util.helpers.ShipSaveHelper;
import slimeattack07.naval_warfare.util.helpers.TargetResultHelper;

public class GameControllerTE
extends BlockEntity {
    public static int ENERGY_GAIN_RATE = (Integer)NavalWarfareConfig.energy_gain_rate.get();
    public static int BASE_ENERGY = (Integer)NavalWarfareConfig.base_energy.get();
    public static int MAX_ENERGY = (Integer)NavalWarfareConfig.max_energy.get();
    public static final int MAX_TURN_TIME = (Integer)NavalWarfareConfig.max_turn_time.get();
    public static final int CLEAR_BOARD_TIME = (Integer)NavalWarfareConfig.clear_board_time.get();
    public String owner = null;
    public BlockPos zero = null;
    public boolean playing_game = false;
    public boolean clear_board = false;
    public BlockPos opponent = null;
    public BlockPos opponent_zero = null;
    public boolean has_turn = false;
    public int turn_time = 0;
    public int board_size = 0;
    public int hp = 0;
    public String config_name = null;
    public int action_time = 0;
    public ArrayList<ControllerActionHelper> actions = new ArrayList();
    public ArrayList<ControllerActionHelper> turn_actions = new ArrayList();
    public int action_number = 0;
    public ArrayList<TargetResultHelper> results = new ArrayList();
    public ArrayList<String> registered = new ArrayList();
    public ArrayList<String> register_buffer = new ArrayList();
    public int energy = -1;
    public boolean do_turn_actions = false;
    public int turn_action_amount = 0;
    public boolean has_spell = true;
    public int timeout_times = 0;
    public int cons_timeout_times = 0;
    public int reg_buffer_time = 0;
    public boolean hit_once = false;
    public int streak = 0;

    public GameControllerTE(BlockPos pos, BlockState state) {
        super((BlockEntityType)NWTileEntityTypes.GAME_CONTROLLER.get(), pos, state);
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public String getOwner() {
        if (this.hasOwner()) {
            return this.owner;
        }
        return "";
    }

    public BlockPos getZero() {
        return this.zero;
    }

    public void setZero(BlockPos new_zero) {
        this.zero = new_zero;
    }

    public BlockPos getOpponentZero() {
        return this.opponent_zero;
    }

    public void setOpponentZero(BlockPos new_zero) {
        this.opponent_zero = new_zero;
    }

    public void setOwner(UUID uuid) {
        this.owner = uuid.toString();
    }

    public void setOwner(String uuid) {
        this.owner = uuid;
    }

    public void setGame(boolean game) {
        this.playing_game = game;
        this.has_spell = game;
    }

    public void setSpell(boolean spell) {
        this.has_spell = spell;
    }

    public void setOpponent(BlockPos opp) {
        this.opponent = opp;
    }

    public void setHP(int health) {
        this.hp = health;
    }

    public void setBoardSize(int size) {
        this.board_size = size;
    }

    public void setClearBoard(boolean remove) {
        this.clear_board = remove;
    }

    public void resetBoardValues() {
        this.clearRegistered();
        this.setBoardSize(0);
        this.setHP(0);
        this.setName(NWBasicMethods.getTranslation("item.naval_warfare.ship_configuration"));
    }

    public void resetActions() {
        this.actions.clear();
        this.turn_actions.clear();
    }

    public void resetTurnTime() {
        this.turn_time = 0;
    }

    public void setEnergy(int amount) {
        this.energy = amount;
    }

    public void setActionNumber(int number) {
        this.action_number = number;
    }

    public void increaseStreak(int amount) {
        this.streak += amount;
    }

    public void consumeEnergy(int amount) {
        this.energy = Math.max(0, this.energy - amount);
        String message = ChatFormatting.YELLOW + NWBasicMethods.getTranslation("ability.naval_warfare.energy") + ": " + this.energy + " (-" + amount + ")";
        NWBasicMethods.messagePlayerCustomRecord(this, this.getPlayer(), message, false);
    }

    public void gainEnergy(int amount) {
        this.energy = Math.min(MAX_ENERGY, this.energy + amount);
        String message = ChatFormatting.YELLOW + NWBasicMethods.getTranslation("ability.naval_warfare.energy") + ": " + this.energy + " (+" + amount + ")";
        NWBasicMethods.messagePlayerCustomRecord(this, this.getPlayer(), message, false);
    }

    public int getHP() {
        return this.hp;
    }

    public int getBoardSize() {
        return this.board_size;
    }

    public BlockPos getOpponent() {
        return this.opponent;
    }

    public void setTurn(boolean turn, boolean gain_energy) {
        this.has_turn = turn;
        this.do_turn_actions = turn;
        this.turn_time = 0;
        if (!turn) {
            this.updatePlayerStreakStat();
            this.streak = 0;
        }
        if (gain_energy) {
            int old = this.energy;
            this.energy = Math.min(this.energy + ENERGY_GAIN_RATE, MAX_ENERGY);
            String message = ChatFormatting.YELLOW + NWBasicMethods.getTranslation("ability.naval_warfare.energy") + ": " + this.energy + " (+" + (this.energy - old) + ")";
            NWBasicMethods.messagePlayerCustomRecord(this, this.getPlayer(), message, false);
        }
    }

    private void updatePlayerStreakStat() {
        Player player = this.getPlayer();
        if (player != null && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            try {
                Stat stat = Stats.f_12988_.m_12899_((Object)new ResourceLocation("naval_warfare", "streak"), StatFormatter.f_12873_);
                int old_streak = sp.m_8951_().m_13015_(stat);
                if (this.streak > old_streak) {
                    sp.m_8951_().m_6085_((Player)sp, stat, this.streak);
                    old_streak = this.streak;
                }
                if (old_streak >= 4) {
                    NWTriggers.STREAK_4.trigger(sp);
                }
                if (old_streak >= 8) {
                    NWTriggers.STREAK_8.trigger(sp);
                }
                if (old_streak >= 12) {
                    NWTriggers.STREAK_12.trigger(sp);
                }
            }
            catch (NullPointerException e) {
                NavalWarfare.LOGGER.error("Naval Warfare: Failed to fetch the streak statistic.");
            }
        }
    }

    public boolean hasSpell() {
        return this.has_spell;
    }

    public boolean hasTurn() {
        return this.has_turn && this.playing_game;
    }

    public void reduceHP() {
        --this.hp;
    }

    public void addHP(int amount) {
        this.hp += amount;
    }

    public boolean isAlive() {
        return this.hp > 0;
    }

    public boolean hasGame() {
        return this.playing_game;
    }

    public String getName() {
        return this.config_name;
    }

    public void setName(String name) {
        this.config_name = name;
    }

    public int getEnergy() {
        return this.energy;
    }

    public ArrayList<ControllerActionHelper> getActions() {
        return this.actions;
    }

    public ArrayList<ControllerActionHelper> getTurnActions() {
        return this.turn_actions;
    }

    public ArrayList<TargetResultHelper> getResults() {
        return this.results;
    }

    public ArrayList<String> getRegistered() {
        return this.registered;
    }

    public ArrayList<String> getRegisterBuffer() {
        return this.register_buffer;
    }

    public void addTurnAction(ControllerActionHelper action) {
        this.turn_actions.add(action);
        this.m_6596_();
    }

    public void addAction(ControllerActionHelper action) {
        this.actions.add(action);
        this.m_6596_();
    }

    public void addResult(TargetResultHelper result) {
        this.results.add(result);
        this.m_6596_();
    }

    public boolean register(String ship, Player player, ShipBlock block) {
        if (this.registered.contains(ship)) {
            return false;
        }
        if (block != null) {
            if (this.hp + block.getMaxHP() > ShipConfiguration.MAX_HEALTH_ALLOWED) {
                return false;
            }
            if (block.hasPassiveAbility() && block.PASSIVE_ABILITY instanceof Seaworthy) {
                this.board_size += block.PASSIVE_ABILITY.getAmount();
                GameController controller = (GameController)this.m_58900_().m_60734_();
                controller.removeBoardAndShips(this.f_58857_, this, false);
                controller.spawnBoard(this.f_58857_, player, this, this.f_58858_, this.board_size, false);
            }
            this.registered.add(ship);
            this.hp += block.getMaxHP();
            this.m_6596_();
        }
        return true;
    }

    public void register(String ship) {
        if (!this.registered.contains(ship)) {
            this.registered.add(ship);
            this.m_6596_();
        }
    }

    public boolean deregister(String ship, Player player, ShipBlock block) {
        if (!this.registered.contains(ship)) {
            return false;
        }
        if (block != null) {
            if (block.hasPassiveAbility() && block.PASSIVE_ABILITY instanceof Seaworthy) {
                GameController controller = (GameController)this.m_58900_().m_60734_();
                controller.removeBoardAndShips(this.f_58857_, this);
                this.board_size = GameController.DEFAULT_BOARD_SIZE;
                controller.spawnBoard(this.f_58857_, player, this, this.f_58858_, this.board_size, false);
                this.clearRegistered();
                this.hp = 0;
                NWBasicMethods.messagePlayer(player, "message.naval_warfare.deregistered_seaworthy");
            } else {
                this.registered.remove(ship);
                this.hp -= block.getMaxHP();
            }
        }
        this.m_6596_();
        return true;
    }

    public void deregister(Player player, String ship, int ship_hp, boolean seaworthy) {
        if (seaworthy) {
            GameController controller = (GameController)this.m_58900_().m_60734_();
            controller.removeBoardAndShips(this.f_58857_, this);
            this.board_size = GameController.DEFAULT_BOARD_SIZE;
            controller.spawnBoard(this.f_58857_, player, this, this.f_58858_, this.board_size, false);
            this.clearRegistered();
            this.hp = 0;
            NWBasicMethods.messagePlayer(player, "message.naval_warfare.deregistered_seaworthy");
        } else {
            if (this.registered.contains(ship)) {
                this.registered.remove(ship);
                this.m_6596_();
            }
            this.hp -= ship_hp;
        }
    }

    public boolean isRegistered(String ship) {
        return this.registered.contains(ship);
    }

    public void clearRegistered() {
        this.registered.clear();
        this.m_6596_();
    }

    public void clearRegisterBuffer() {
        this.register_buffer.clear();
        this.m_6596_();
    }

    public void addRegisterToBuffer(String ship) {
        if (!this.register_buffer.contains(ship)) {
            this.register_buffer.add(ship);
            this.m_6596_();
        }
    }

    public boolean hasRegInBuffer() {
        return !this.register_buffer.isEmpty();
    }

    public boolean hasBoard() {
        return this.board_size > 0;
    }

    private boolean hasTurnWork() {
        return (this.do_turn_actions || this.turn_action_amount > 0) && !this.turn_actions.isEmpty();
    }

    private boolean shouldDoTurnWork() {
        return this.turn_actions.get((int)0).delay <= this.action_time;
    }

    private boolean hasWork() {
        return !this.actions.isEmpty();
    }

    private boolean shouldDoWork() {
        return this.actions.get((int)0).delay <= this.action_time;
    }

    private void removeFirstAction() {
        if (!this.actions.isEmpty()) {
            this.actions.remove(0);
        }
    }

    private void removeFirstTurnAction() {
        if (!this.turn_actions.isEmpty()) {
            this.turn_actions.remove(0);
        }
    }

    private void setAnimationTime(BlockPos pos, int time) {
        BlockEntity tile = this.f_58857_.m_7702_(pos);
        if (tile instanceof DisappearingTE) {
            DisappearingTE te = (DisappearingTE)tile;
            te.setTime(time);
        }
    }

    private void doActionTarget(ControllerActionHelper cah) {
        BlockEntity tile = this.f_58857_.m_7702_(cah.board_te);
        if (tile instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            Board board = (Board)te.m_58900_().m_60734_();
            Player player = null;
            if (!cah.player.equals("dummy")) {
                player = this.f_58857_.m_46003_(UUID.fromString(cah.player));
            }
            if (cah.animation != null) {
                BattleLogHelper blh_drop = BattleLogHelper.createDropBlock(te.getId(), !cah.multi_ability, cah.animation.getRegistryName());
                this.recordOnRecorders(blh_drop);
            }
            this.recordOnRecorders(BattleLogHelper.createDelay(cah.delay));
            HitResult result = board.targetTileAction(this.f_58857_, player, te.m_58900_(), te.m_58899_(), te, cah.matching, cah.damage, cah.target_type, cah.multi_ability, this.action_number, null, cah.triggers_passives, false);
            if (result.equals((Object)HitResult.MISS)) {
                this.recordOnRecorders(BattleLogHelper.createBoardState(te.getId(), !cah.multi_ability, BoardState.EMPTY));
            }
        }
        this.removeFirstAction();
    }

    private void doActionAbility(ControllerActionHelper cah, boolean active) {
        BlockEntity tile = this.f_58857_.m_7702_(cah.board_te);
        Block block = this.f_58857_.m_8055_(cah.pos).m_60734_();
        if (tile instanceof BoardTE && block instanceof ShipBlock) {
            BoardTE te = (BoardTE)tile;
            ShipBlock ship = (ShipBlock)block;
            Player player = null;
            if (!cah.player.equals("dummy")) {
                player = this.f_58857_.m_46003_(UUID.fromString(cah.player));
            }
            if (active) {
                ship.ACTIVE_ABILITY.activate(this.f_58857_, player, te);
            } else {
                ship.PASSIVE_ABILITY.activate(this.f_58857_, player, te);
            }
            ++this.action_number;
        }
        this.removeFirstAction();
    }

    private void doActionSpell(ControllerActionHelper cah) {
        BlockEntity tile = this.f_58857_.m_7702_(cah.board_te);
        if (tile instanceof BoardTE) {
            Ability ability;
            BoardTE te = (BoardTE)tile;
            Player player = null;
            if (!cah.player.equals("dummy")) {
                player = this.f_58857_.m_46003_(UUID.fromString(cah.player));
            }
            if (cah.spell != null && (ability = SpellWand.spellToAbility(cah.spell)) != null) {
                ability.activate(this.f_58857_, player, te);
                this.setSpell(false);
            }
            ++this.action_number;
        }
        this.removeFirstAction();
    }

    private void doActionAnnounce(ControllerActionHelper cah, boolean turn) {
        MutableComponent component = Component.Serializer.m_130701_((String)cah.hover);
        if (component == null) {
            component = new TextComponent("");
        }
        if (cah.player != null && !cah.player.equals("dummy")) {
            Player player = this.f_58857_.m_46003_(UUID.fromString(cah.player));
            NWBasicMethods.messagePlayerAbilityUsed(this, player, "ability.naval_warfare.triggered", player.m_7755_().getString(), component);
            NWBasicMethods.messagePlayerTitle(player, this.f_58857_, "ability.naval_warfare.triggered", "dark_green", cah.translation, "green");
            NWBasicMethods.animateItemUse(player, cah.item);
        }
        if (cah.opponent != null && !cah.opponent.equals("dummy")) {
            Player opponent = this.f_58857_.m_46003_(UUID.fromString(cah.opponent));
            NWBasicMethods.messagePlayerAbilityUsed(null, opponent, "ability.naval_warfare.triggered", opponent.m_7755_().getString(), component);
            NWBasicMethods.messagePlayerTitle(opponent, this.f_58857_, "ability.naval_warfare.triggered", "dark_green", cah.translation, "green");
            NWBasicMethods.animateItemUse(opponent, cah.item);
        }
        if (turn) {
            this.removeFirstTurnAction();
        } else {
            this.removeFirstAction();
        }
        ++this.action_number;
        this.recordOnRecorders(BattleLogHelper.createDelay(cah.delay));
    }

    private void cancelActions(ControllerAction action) {
        ArrayList<ControllerActionHelper> keep = new ArrayList<ControllerActionHelper>();
        boolean end = false;
        for (ControllerActionHelper cah : this.actions) {
            Board board;
            if (end) {
                keep.add(cah);
                continue;
            }
            if (!cah.action.equals((Object)action)) {
                keep.add(cah);
                end = true;
                continue;
            }
            BlockState state = this.f_58857_.m_8055_(cah.pos);
            if (state.m_60734_() instanceof Board) {
                board = (Board)state.m_60734_();
                this.f_58857_.m_46597_(cah.pos, (BlockState)state.m_61124_((Property)Board.STATE, (Comparable)((Object)board.getBoardState(state).deselect())));
            }
            if (!((state = this.f_58857_.m_8055_(cah.matching)).m_60734_() instanceof Board)) continue;
            board = (Board)state.m_60734_();
            this.f_58857_.m_46597_(cah.matching, (BlockState)state.m_61124_((Property)Board.STATE, (Comparable)((Object)board.getBoardState(state).deselect())));
        }
        this.actions = keep;
    }

    private void messageOpponent(Component message) {
        BlockEntity tile = this.f_58857_.m_7702_(this.opponent);
        if (tile instanceof GameControllerTE) {
            GameControllerTE opponent = (GameControllerTE)tile;
            String owner = opponent.getOwner();
            if (owner.equals("dummy")) {
                return;
            }
            Player player = this.f_58857_.m_46003_(UUID.fromString(owner));
            if (player != null) {
                player.m_6352_(message, Util.f_137441_);
            }
        }
    }

    private void informOpponentOfTimer(Level level, String translation, SoundEvent sound) {
        Player player = this.getOpponentPlayer();
        if (player != null) {
            player.m_6330_(sound, SoundSource.MASTER, 1.0f, 0.75f);
            NWBasicMethods.messagePlayerActionbar(player, translation);
        }
    }

    private void informSelfOfTimer(Level level, String translation, SoundEvent sound) {
        Player player = this.getPlayer();
        if (player != null) {
            player.m_6330_(sound, SoundSource.MASTER, 1.0f, 0.75f);
            NWBasicMethods.messagePlayerActionbar(player, translation);
        }
    }

    private void consumeResults(Player player, boolean targeted) {
        this.consumeResults(player, targeted, false, true, false);
    }

    private void consumeResults(Player player, boolean targeted, boolean hint, boolean must_hit, boolean passive) {
        TextComponent text = null;
        boolean cont = !must_hit;
        for (TargetResultHelper trh : this.results) {
            String color = "white";
            String hover = "error";
            switch (trh.result) {
                case BLOCKED: {
                    color = "green";
                    hover = NWBasicMethods.getTranslation("misc.naval_warfare.blocked");
                    break;
                }
                case NULLIFIED: {
                    color = "dark_green";
                    hover = NWBasicMethods.getTranslation("misc.naval_warfare.nullified");
                    break;
                }
                case HIT: {
                    color = "dark_red";
                    String string = hover = targeted ? NWBasicMethods.getTranslation("misc.naval_warfare.hit") : NWBasicMethods.getTranslation("misc.naval_warfare.ship_here");
                    if (hint) {
                        hover = NWBasicMethods.getTranslation("misc.naval_warfare.ship_close");
                    }
                    cont = true;
                    break;
                }
                case KNOWN: {
                    color = "aqua";
                    hover = hint ? NWBasicMethods.getTranslation("misc.naval_warfare.unknown") : NWBasicMethods.getTranslation("misc.naval_warfare.known");
                    break;
                }
                case MISS: {
                    color = "blue";
                    String string = hover = targeted ? NWBasicMethods.getTranslation("misc.naval_warfare.miss") : NWBasicMethods.getTranslation("misc.naval_warfare.empty");
                    if (!hint) break;
                    hover = NWBasicMethods.getTranslation("misc.naval_warfare.unknown");
                    break;
                }
                case UNKOWN: {
                    color = "blue";
                    hover = NWBasicMethods.getTranslation("misc.naval_warfare.unknown");
                }
            }
            if (text == null) {
                text = new TextComponent(NWBasicMethods.getTranslation("message.naval_warfare.ability_results") + ": [");
                text.m_7220_((Component)NWBasicMethods.hoverableText("" + trh.id, color, hover));
                continue;
            }
            text.m_7220_((Component)new TextComponent(", "));
            text.m_7220_((Component)NWBasicMethods.hoverableText("" + trh.id, color, hover));
        }
        if (text != null) {
            text.m_7220_((Component)new TextComponent("]"));
            if (player != null) {
                player.m_6352_(text, Util.f_137441_);
            }
            if (passive) {
                player = this.getPlayer();
                if (player != null) {
                    player.m_6352_(text, Util.f_137441_);
                }
            } else {
                this.messageOpponent((Component)text);
            }
            this.notifyResult(cont, false, cont);
            this.recordOnRecorders(BattleLogHelper.createMessage(Component.Serializer.m_130703_((Component)text)));
            this.results.clear();
        }
    }

    private void doActionTorpedo(ControllerActionHelper cah) {
        BlockEntity tile = this.f_58857_.m_7702_(cah.board_te);
        boolean removed = false;
        if (tile instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            Board board = (Board)te.m_58900_().m_60734_();
            Player player = null;
            if (!cah.player.equals("dummy")) {
                player = this.f_58857_.m_46003_(UUID.fromString(cah.player));
            }
            if (cah.health == -1) {
                board.deselectTile(this.f_58857_, te.m_58899_(), cah.matching);
                this.removeFirstAction();
                return;
            }
            HitResult result = board.targetTileAction(this.f_58857_, player, te.m_58900_(), te.m_58899_(), te, cah.matching, cah.damage, cah.target_type, true, this.action_number, null, true, false);
            this.addResult(new TargetResultHelper(te.getId(), result));
            block0 : switch (result) {
                case NULLIFIED: {
                    this.cancelActions(ControllerAction.TORPEDO);
                    this.consumeResults(player, true);
                    removed = true;
                    break;
                }
                case HIT: {
                    this.f_58857_.m_5594_(null, te.m_58899_(), (SoundEvent)NWSounds.TORPEDO.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    this.f_58857_.m_5594_(null, cah.matching, (SoundEvent)NWSounds.TORPEDO.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    this.recordOnRecorders(BattleLogHelper.createSound(te.getId(), true, (SoundEvent)NWSounds.TORPEDO.get(), 1.0f, 1.0f));
                    if (cah.health == 1) {
                        this.cancelActions(ControllerAction.TORPEDO);
                        this.consumeResults(player, true);
                        ++this.action_number;
                        removed = true;
                        break;
                    }
                    for (ControllerActionHelper helper : this.actions) {
                        if (!helper.action.equals((Object)ControllerAction.TORPEDO)) break block0;
                        --helper.health;
                    }
                    break;
                }
                default: {
                    if (cah.animation == null || board.getBoardState(te.m_58900_()).isHit()) break;
                    BlockState own_state = cah.animation.m_49966_();
                    BlockState opp_state = cah.animation.m_49966_();
                    if (cah.animation instanceof DirectionalDisBlock) {
                        Direction own_dir = board.getControllerFacing(this.f_58857_, te.m_58899_());
                        Direction opp_dir = board.getControllerFacing(this.f_58857_, cah.matching);
                        own_state = (BlockState)own_state.m_61124_((Property)DirectionalDisBlock.FACING, (Comparable)own_dir);
                        opp_state = (BlockState)opp_state.m_61124_((Property)DirectionalDisBlock.FACING, (Comparable)opp_dir);
                        this.recordOnRecorder(BattleLogHelper.createSetDisBlock(te.getId(), cah.animation.getRegistryName(), 1, true, own_dir, cah.delay));
                        this.recordOnOppRecorder(BattleLogHelper.createSetDisBlock(te.getId(), cah.animation.getRegistryName(), 1, true, opp_dir, cah.delay));
                    }
                    this.f_58857_.m_46597_(te.m_58899_().m_7494_(), own_state);
                    this.f_58857_.m_46597_(cah.matching.m_7494_(), opp_state);
                    this.setAnimationTime(te.m_58899_().m_7494_(), cah.delay);
                    this.setAnimationTime(cah.matching.m_7494_(), cah.delay);
                }
            }
            if (this.actions.size() == 1 || this.actions.size() > 1 && !this.actions.get((int)1).action.equals((Object)ControllerAction.TORPEDO)) {
                this.consumeResults(player, true);
            }
        }
        this.recordOnRecorders(BattleLogHelper.createDelay(cah.delay));
        if (!removed) {
            this.removeFirstAction();
        }
    }

    private void doActionFragbomb(ControllerActionHelper cah) {
        BlockEntity tile = this.f_58857_.m_7702_(cah.board_te);
        if (tile instanceof BoardTE) {
            Block animation;
            BoardTE te = (BoardTE)tile;
            Board board = (Board)te.m_58900_().m_60734_();
            Player player = null;
            Block block = animation = cah.target_type.equals((Object)TargetType.NORMAL) ? null : cah.animation;
            if (!cah.player.equals("dummy")) {
                player = this.f_58857_.m_46003_(UUID.fromString(cah.player));
            }
            HitResult result = board.targetTileAction(this.f_58857_, player, te.m_58900_(), te.m_58899_(), te, cah.matching, cah.damage, cah.target_type, true, this.action_number, animation, true, false);
            this.addResult(new TargetResultHelper(te.getId(), result));
            switch (result) {
                case HIT: {
                    ++this.streak;
                    break;
                }
                default: {
                    if (!cah.target_type.equals((Object)TargetType.NORMAL)) break;
                    this.cancelActions(ControllerAction.FRAGBOMB);
                    this.consumeResults(player, true);
                }
            }
            if (this.actions.size() == 1 || this.actions.size() > 1 && !this.actions.get((int)1).action.equals((Object)ControllerAction.FRAGBOMB)) {
                this.consumeResults(player, true);
            }
            if (result.equals((Object)HitResult.MISS)) {
                this.recordOnRecorders(BattleLogHelper.createBoardState(te.getId(), true, BoardState.EMPTY));
            }
        }
        this.removeFirstAction();
    }

    private void doActionNapalm(ControllerActionHelper cah) {
        BlockEntity tile = this.f_58857_.m_7702_(cah.board_te);
        if (tile instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            Board board = (Board)te.m_58900_().m_60734_();
            Player player = null;
            if (!cah.player.equals("dummy")) {
                player = this.f_58857_.m_46003_(UUID.fromString(cah.player));
            }
            HitResult result = board.targetTileAction(this.f_58857_, player, te.m_58900_(), te.m_58899_(), te, cah.matching, cah.damage, cah.target_type, false, this.action_number, null, true, false);
            switch (result) {
                case HIT: {
                    ++this.streak;
                    if (ShipBlock.getState(this.f_58857_.m_8055_(te.m_58899_().m_7494_())).equals((Object)ShipState.DESTROYED)) break;
                    this.addTurnAction(ControllerActionHelper.createAnnounce(cah.player, this.getOpponentName(cah.pos), (Item)NWItems.FIRE_DAMAGE.get(), "ability.naval_warfare.fire_damage", Napalm.fireDamageText()));
                    this.addTurnAction(ControllerActionHelper.createForcedTarget(cah.pos, cah.player, cah.board_te, cah.matching));
                    this.addTurnAction(ControllerActionHelper.createValidate());
                    this.f_58857_.m_5594_(null, te.m_58899_(), (SoundEvent)NWSounds.NAPALM.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    this.f_58857_.m_5594_(null, cah.matching, (SoundEvent)NWSounds.NAPALM.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    break;
                }
            }
        }
        this.removeFirstAction();
    }

    private void doTurnDamage(ControllerActionHelper cah) {
        BlockEntity tile = this.f_58857_.m_7702_(cah.board_te);
        if (tile instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            Board board = (Board)te.m_58900_().m_60734_();
            Player player = null;
            if (!cah.player.equals("dummy")) {
                player = this.f_58857_.m_46003_(UUID.fromString(cah.player));
            }
            HitResult result = board.targetTileAction(this.f_58857_, player, te.m_58900_(), te.m_58899_(), te, cah.matching, cah.damage, cah.target_type, true, this.action_number, null, cah.triggers_passives, true);
            switch (result) {
                case HIT: {
                    ++this.streak;
                    BlockState state = this.f_58857_.m_8055_(te.m_58899_().m_7494_());
                    if (!(state.m_60734_() instanceof ShipBlock)) break;
                    if (ShipBlock.getState(state).isAlive()) {
                        this.addTurnAction(ControllerActionHelper.createAnnounce(cah.player, this.getOpponentName(cah.pos), (Item)NWItems.FIRE_DAMAGE.get(), "ability.naval_warfare.fire_damage", ""));
                        this.addTurnAction(ControllerActionHelper.createForcedTarget(cah.pos, cah.player, cah.board_te, cah.matching));
                    }
                    this.addTurnAction(ControllerActionHelper.createValidate());
                    break;
                }
            }
        }
        this.removeFirstTurnAction();
    }

    private void doMultiTarget(ControllerActionHelper cah) {
        BlockEntity tile = this.f_58857_.m_7702_(cah.board_te);
        if (tile instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            Board board = (Board)te.m_58900_().m_60734_();
            Player player = null;
            if (!cah.player.equals("dummy")) {
                player = this.f_58857_.m_46003_(UUID.fromString(cah.player));
            }
            HitResult result = board.targetTileAction(this.f_58857_, player, te.m_58900_(), te.m_58899_(), te, cah.matching, cah.damage, cah.target_type, true, this.action_number, null, cah.triggers_passives, false);
            this.addResult(new TargetResultHelper(te.getId(), result));
            if (this.actions.size() == 1 || this.actions.size() > 1 && !this.actions.get((int)1).action.equals((Object)ControllerAction.MULTI_TARGET)) {
                this.consumeResults(player, true, false, !cah.multi_ability, cah.multi_ability);
                ++this.action_number;
            }
            if (result.equals((Object)HitResult.MISS)) {
                this.recordOnRecorders(BattleLogHelper.createBoardState(te.getId(), !cah.multi_ability, BoardState.EMPTY));
            }
        }
        this.removeFirstAction();
    }

    private void doActionBomber(ControllerActionHelper cah) {
        BlockEntity tile = this.f_58857_.m_7702_(cah.board_te);
        boolean removed = false;
        if (tile instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            Board board = (Board)te.m_58900_().m_60734_();
            Player player = null;
            if (!cah.player.equals("dummy")) {
                player = this.f_58857_.m_46003_(UUID.fromString(cah.player));
            }
            this.f_58857_.m_5594_(null, te.m_58899_(), (SoundEvent)NWSounds.BOMBER.get(), SoundSource.MASTER, 1.0f, 1.0f);
            this.f_58857_.m_5594_(null, cah.matching, (SoundEvent)NWSounds.BOMBER.get(), SoundSource.MASTER, 1.0f, 1.0f);
            this.recordOnRecorders(BattleLogHelper.createSound(te.getId(), true, (SoundEvent)NWSounds.BOMBER.get(), 1.0f, 1.0f));
            HitResult result = board.targetTileAction(this.f_58857_, player, te.m_58900_(), te.m_58899_(), te, cah.matching, cah.damage, cah.target_type, true, this.action_number, (Block)NWBlocks.BOMB.get(), true, false);
            if (cah.animation != null) {
                BlockState own_state = cah.animation.m_49966_();
                BlockState opp_state = cah.animation.m_49966_();
                if (cah.animation instanceof DirectionalDisBlock) {
                    Direction own_dir = board.getControllerFacing(this.f_58857_, te.m_58899_());
                    Direction opp_dir = board.getControllerFacing(this.f_58857_, cah.matching);
                    own_state = (BlockState)own_state.m_61124_((Property)DirectionalDisBlock.FACING, (Comparable)own_dir);
                    opp_state = (BlockState)opp_state.m_61124_((Property)DirectionalDisBlock.FACING, (Comparable)opp_dir);
                    this.recordOnRecorder(BattleLogHelper.createSetDisBlock(te.getId(), cah.animation.getRegistryName(), 6, true, own_dir, cah.delay));
                    this.recordOnOppRecorder(BattleLogHelper.createSetDisBlock(te.getId(), cah.animation.getRegistryName(), 6, true, opp_dir, cah.delay));
                }
                this.f_58857_.m_46597_(te.m_58899_().m_6630_(6), own_state);
                this.f_58857_.m_46597_(cah.matching.m_6630_(6), opp_state);
                this.setAnimationTime(te.m_58899_().m_6630_(6), cah.delay);
                this.setAnimationTime(cah.matching.m_6630_(6), cah.delay);
            }
            this.addResult(new TargetResultHelper(te.getId(), result));
            switch (result) {
                case NULLIFIED: {
                    this.cancelActions(ControllerAction.BOMBER);
                    this.consumeResults(player, true);
                    removed = true;
                    break;
                }
            }
            if (this.actions.size() == 1 || this.actions.size() > 1 && !this.actions.get((int)1).action.equals((Object)ControllerAction.BOMBER)) {
                this.consumeResults(player, true);
            }
        }
        this.recordOnRecorders(BattleLogHelper.createDelay(cah.delay));
        if (!removed) {
            this.removeFirstAction();
        }
    }

    private void computeFlareTile(Player player, BoardTE te, boolean passive) {
        ArrayList<TargetResultHelper> hits = new ArrayList<TargetResultHelper>();
        for (TargetResultHelper trh : this.results) {
            if (!trh.result.equals((Object)HitResult.HIT)) continue;
            hits.add(trh);
        }
        if (hits.size() > 0) {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            int ship = rand.nextInt(hits.size());
            TargetResultHelper trh = (TargetResultHelper)hits.get(ship);
            GameController controller = (GameController)this.m_58900_().m_60734_();
            Board board = (Board)te.m_58900_().m_60734_();
            Direction dir_opp = board.getControllerFacing(this.f_58857_, te.m_58899_());
            Direction dir_own = controller.getFacing(this.m_58900_());
            BlockPos pos = te.locateId(te.m_58899_(), trh.id, dir_opp, false);
            if (pos == null) {
                return;
            }
            BlockEntity tile = this.f_58857_.m_7702_(pos);
            if (tile instanceof BoardTE) {
                BoardTE bte = (BoardTE)tile;
                ArrayList<BoardTE> locations = bte.collectTileArea(2, 2, 2, 2, dir_opp);
                ArrayList<BoardTE> useable = new ArrayList<BoardTE>();
                for (BoardTE t : locations) {
                    BlockState state = this.f_58857_.m_8055_(t.m_58899_());
                    if (!(state.m_60734_() instanceof Board) || (board = (Board)state.m_60734_()).getBoardState(state).isKnown()) continue;
                    useable.add(t);
                }
                if (useable.size() > 0) {
                    int hint = rand.nextInt(useable.size());
                    BoardTE hint_te = (BoardTE)((Object)useable.get(hint));
                    BlockEntity own_board = this.f_58857_.m_7702_(this.opponent_zero);
                    if (own_board instanceof BoardTE) {
                        BlockPos matching;
                        BoardTE own_boardte = (BoardTE)own_board;
                        if (passive) {
                            BoardTE passive_bte = controller.getOpponentBoardTile(this.f_58857_, this, hint_te.getId(), true);
                            if (passive_bte == null) {
                                return;
                            }
                            matching = passive_bte.m_58899_();
                        } else {
                            matching = own_boardte.locateId(own_boardte.m_58899_(), hint_te.getId(), dir_own, true);
                        }
                        this.f_58857_.m_46597_(matching.m_6630_(2), (BlockState)((Block)NWBlocks.SHIP_CLOSE.get()).m_49966_().m_61124_((Property)ShipMarkerBlock.FACING, (Comparable)dir_own.m_122424_()));
                        this.f_58857_.m_46597_(hint_te.m_58899_().m_6630_(2), (BlockState)((Block)NWBlocks.SHIP_CLOSE.get()).m_49966_().m_61124_((Property)ShipMarkerBlock.FACING, (Comparable)dir_opp.m_122424_()));
                        this.results = new ArrayList();
                        this.results.add(trh);
                        this.recordOnRecorders(BattleLogHelper.createSetBlock(hint_te.getId(), ((Block)NWBlocks.SHIP_CLOSE.get()).getRegistryName(), 2, !passive));
                    }
                } else {
                    this.results = new ArrayList();
                    this.results.add(new TargetResultHelper(-1, HitResult.UNKOWN));
                }
            } else {
                this.results = new ArrayList();
                this.results.add(new TargetResultHelper(-1, HitResult.UNKOWN));
            }
        } else {
            this.results = new ArrayList();
            this.results.add(new TargetResultHelper(-1, HitResult.UNKOWN));
        }
        this.consumeResults(player, false, true, false, passive);
    }

    private void doActionSpyglass(ControllerActionHelper cah) {
        BlockEntity tile = this.f_58857_.m_7702_(cah.board_te);
        if (tile instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            Board board = (Board)te.m_58900_().m_60734_();
            Player player = null;
            if (!cah.player.equals("dummy")) {
                player = this.f_58857_.m_46003_(UUID.fromString(cah.player));
            }
            HitResult result = board.revealTileAction(this.f_58857_, player, te.m_58900_(), te.m_58899_(), te, cah.matching, cah.target_type, this.action_number);
            this.addResult(new TargetResultHelper(te.getId(), result));
            if (result.equals((Object)HitResult.HIT)) {
                Direction dir = board.getControllerFacing(this.f_58857_, te.m_58899_());
                this.f_58857_.m_46597_(te.m_58899_().m_6630_(2), (BlockState)((Block)NWBlocks.SHIP_HERE.get()).m_49966_().m_61124_((Property)ShipMarkerBlock.FACING, (Comparable)dir.m_122424_()));
                BlockEntity opp = this.f_58857_.m_7702_(cah.matching);
                this.recordOnRecorders(BattleLogHelper.createSetBlock(te.getId(), ((Block)NWBlocks.SHIP_HERE.get()).getRegistryName(), 2, !cah.multi_ability));
                if (opp instanceof BoardTE) {
                    BoardTE oppte = (BoardTE)opp;
                    dir = board.getControllerFacing(this.f_58857_, te.m_58899_());
                    this.f_58857_.m_46597_(oppte.m_58899_().m_6630_(2), (BlockState)((Block)NWBlocks.SHIP_HERE.get()).m_49966_().m_61124_((Property)ShipMarkerBlock.FACING, (Comparable)dir.m_122424_()));
                }
            }
            if (this.actions.size() == 1 || this.actions.size() > 1 && !this.actions.get((int)1).action.equals((Object)ControllerAction.SPYGLASS)) {
                this.consumeResults(player, false, false, false, cah.multi_ability);
                ++this.action_number;
            }
        }
        this.removeFirstAction();
    }

    private void doActionFlare(ControllerActionHelper cah) {
        BlockEntity tile = this.f_58857_.m_7702_(cah.board_te);
        if (tile instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            Board board = (Board)te.m_58900_().m_60734_();
            Player player = null;
            if (!cah.player.equals("dummy")) {
                player = this.f_58857_.m_46003_(UUID.fromString(cah.player));
            }
            HitResult result = board.revealTileAction(this.f_58857_, player, te.m_58900_(), te.m_58899_(), te, cah.matching, cah.target_type, this.action_number);
            this.addResult(new TargetResultHelper(te.getId(), result));
            if (this.actions.size() == 1 || this.actions.size() > 1 && !this.actions.get((int)1).action.equals((Object)ControllerAction.FLARE)) {
                this.computeFlareTile(player, te, cah.multi_ability);
                ++this.action_number;
            }
        }
        this.removeFirstAction();
    }

    private void doActionEnergy(ControllerActionHelper cah) {
        if (cah.multi_ability) {
            this.gainEnergy(cah.health);
        } else {
            GameController control = (GameController)this.m_58900_().m_60734_();
            if (control.validateController(this.f_58857_, this.opponent)) {
                GameControllerTE te = (GameControllerTE)this.f_58857_.m_7702_(this.opponent);
                te.gainEnergy(cah.health);
            }
        }
        this.removeFirstAction();
    }

    private String getOpponentName(BlockPos pos) {
        BoardTE te;
        Board board;
        GameControllerTE gte;
        BlockEntity tile = this.f_58857_.m_7702_(pos);
        if (tile instanceof BoardTE && (gte = (board = (Board)(te = (BoardTE)tile).m_58900_().m_60734_()).getController(this.f_58857_, te.m_58899_())) != null) {
            return gte.getOwner();
        }
        return "dummy";
    }

    public void streakSounds() {
        if (this.streak > 2) {
            String message = ChatFormatting.GOLD + NWBasicMethods.getTranslation("message.naval_warfare.streak").replace("MARKER1", "" + this.streak);
            Player player = this.getPlayer();
            SoundEvent sound = (SoundEvent)NWSounds.STREAK1.get();
            if (this.streak > 8) {
                sound = (SoundEvent)NWSounds.STREAK3.get();
            } else if (this.streak > 5) {
                sound = (SoundEvent)NWSounds.STREAK2.get();
            }
            if (player != null) {
                NWBasicMethods.messagePlayerCustomRecord(this, player, message, false);
                player.m_6330_(sound, SoundSource.MASTER, 1.0f, 1.0f);
                this.recordOnRecorders(BattleLogHelper.createSound((int)Math.ceil(this.board_size) / 2, true, sound, 1.0f, 1.0f));
            }
            if ((player = this.getOpponentPlayer()) != null) {
                player.m_6330_(sound, SoundSource.MASTER, 1.0f, 1.0f);
                NWBasicMethods.messagePlayerCustomRecord(this, player, message, true);
            }
        }
    }

    private void doTurnWork() {
        if (this.turn_actions.size() < 1) {
            return;
        }
        ControllerActionHelper cah = this.turn_actions.get(0);
        if (cah.action == null) {
            NavalWarfare.LOGGER.warn("GameController BlockEntity at " + this.f_58858_.m_123344_() + " got corrupt turn action. Skipping action: " + cah);
            this.removeFirstTurnAction();
            return;
        }
        switch (cah.action) {
            case TURN_DAMAGE: {
                this.doTurnDamage(cah);
                break;
            }
            case ANNOUNCE: {
                this.doActionAnnounce(cah, true);
                break;
            }
            case VALIDATE: {
                this.notifyResult(true, false, false);
                this.removeFirstTurnAction();
                break;
            }
            case RAFT: {
                if (cah.health > 0) {
                    --cah.health;
                    this.addTurnAction(cah);
                } else {
                    this.addTurnAction(ControllerActionHelper.createForcedTarget(cah.pos, cah.player, cah.board_te, cah.matching));
                    this.addTurnAction(ControllerActionHelper.createValidate());
                }
                this.removeFirstTurnAction();
                break;
            }
            default: {
                NavalWarfare.LOGGER.warn("I don't know how to execute this turn action! Please report this to the mod author! Turn action is: " + cah);
                this.removeFirstTurnAction();
            }
        }
    }

    private void doWork() {
        if (this.actions.size() < 1) {
            return;
        }
        ControllerActionHelper cah = this.actions.get(0);
        if (cah.action == null) {
            NavalWarfare.LOGGER.warn("GameController BlockEntity at " + this.f_58858_.m_123344_() + " got corrupt action. Skipping action: " + cah);
            this.removeFirstAction();
            return;
        }
        switch (cah.action) {
            case ACTIVE_ABILITY: {
                this.doActionAbility(cah, true);
                break;
            }
            case PASSIVE_ABILITY: {
                this.doActionAbility(cah, false);
                break;
            }
            case SPELL: {
                this.doActionSpell(cah);
                break;
            }
            case TARGET: {
                this.doActionTarget(cah);
                break;
            }
            case TORPEDO: {
                this.doActionTorpedo(cah);
                break;
            }
            case MULTI_TARGET: {
                this.doMultiTarget(cah);
                break;
            }
            case SPYGLASS: {
                this.doActionSpyglass(cah);
                break;
            }
            case FLARE: {
                this.doActionFlare(cah);
                break;
            }
            case ANNOUNCE: {
                this.doActionAnnounce(cah, false);
                break;
            }
            case VALIDATE: {
                this.notifyResult(true, false, false);
                this.removeFirstAction();
                break;
            }
            case END_TURN: {
                this.notifyResult(false, false, false);
                this.removeFirstAction();
                break;
            }
            case GAIN_ENERGY: {
                this.doActionEnergy(cah);
                break;
            }
            case FRAGBOMB: {
                this.doActionFragbomb(cah);
                break;
            }
            case BOMBER: {
                this.doActionBomber(cah);
                break;
            }
            case NAPALM: {
                this.doActionNapalm(cah);
                break;
            }
            default: {
                NavalWarfare.LOGGER.warn("I don't know how to execute this action! Please report this to the mod author! Action is: " + cah);
                this.removeFirstAction();
            }
        }
    }

    public void recordOnOppRecorder(BattleLogHelper blh) {
        if (this.opponent == null) {
            return;
        }
        BlockEntity tile = this.f_58857_.m_7702_(this.opponent);
        if (tile instanceof GameControllerTE) {
            GameControllerTE te = (GameControllerTE)tile;
            BattleLogHelper new_blh = blh.copy();
            new_blh.opponent = !new_blh.opponent;
            te.recordOnRecorder(new_blh);
        }
    }

    public void recordOnRecorder(BattleLogHelper blh) {
        BattleRecorderTE te = this.getRecorder();
        if (te != null) {
            te.addAction(blh);
        }
    }

    public void recordOnRecorders(BattleLogHelper blh) {
        if (blh.action.equals((Object)BattleLogAction.DELAY) && blh.delay <= 0) {
            return;
        }
        this.recordOnRecorder(blh);
        this.recordOnOppRecorder(blh);
    }

    public void recordOnRecorder(ArrayList<ShipSaveHelper> own_ships, ArrayList<ShipSaveHelper> opp_ships, int own_size, int opp_size, Direction own_dir, Direction opp_dir) {
        BattleRecorderTE te = this.getRecorder();
        if (te != null) {
            te.setOwnShips(new ArrayList<ShipSaveHelper>(own_ships));
            te.setOppShips(new ArrayList<ShipSaveHelper>(opp_ships));
            te.setOwnSize(own_size);
            te.setOppSize(opp_size);
            te.setOwnDir(own_dir);
            te.setOppDir(opp_dir);
        }
    }

    private void saveRecorder() {
        BattleRecorderTE te = this.getRecorder();
        if (te != null) {
            Player oplayer = this.getOpponentPlayer();
            String opstring = oplayer == null ? "dummy" : oplayer.m_7755_().getString();
            Player player = this.getPlayer();
            String pstring = player == null ? "dummy" : player.m_7755_().getString();
            te.generateLog(this.getPlayer(), pstring, opstring);
            te.reset();
        }
    }

    private BattleRecorderTE getRecorder() {
        GameController controller = (GameController)this.m_58900_().m_60734_();
        BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_141952_(controller.getFacing(this.m_58900_()).m_122424_().m_122436_()));
        if (tile instanceof BattleRecorderTE) {
            return (BattleRecorderTE)tile;
        }
        return null;
    }

    public void notifyResult(boolean cont, boolean timeout, boolean set_hit) {
        Player oppp;
        BlockState state = this.f_58857_.m_8055_(this.opponent);
        if (!(state.m_60734_() instanceof GameController) || !state.m_155947_()) {
            return;
        }
        BlockEntity otile = this.f_58857_.m_7702_(this.opponent);
        if (!(otile instanceof GameControllerTE)) {
            return;
        }
        GameControllerTE ote = (GameControllerTE)otile;
        Player ownp = this.owner.equals("dummy") ? null : this.f_58857_.m_46003_(UUID.fromString(this.owner));
        Player player = oppp = ote.getOwner().equals("dummy") ? null : this.f_58857_.m_46003_(UUID.fromString(ote.getOwner()));
        if (!cont) {
            if (timeout && !this.hit_once) {
                ++this.timeout_times;
                ++this.cons_timeout_times;
            }
            if (ownp != null) {
                if (timeout) {
                    if (this.hit_once) {
                        this.cons_timeout_times = 0;
                    }
                    NWBasicMethods.messagePlayerCustomRecord(this, ownp, NWBasicMethods.createRedText("message.naval_warfare.time_up_own").getString(), false);
                } else {
                    this.cons_timeout_times = 0;
                }
                NWBasicMethods.messagePlayerCustomRecord(this, ownp, NWBasicMethods.createRedText("message.naval_warfare.opponent_turn").getString(), false);
                ownp.m_6330_((SoundEvent)NWSounds.OPPONENT_TURN.get(), SoundSource.MASTER, 1.0f, 1.5f);
            }
            if (oppp != null) {
                if (timeout) {
                    NWBasicMethods.messagePlayerCustomRecord(this, oppp, NWBasicMethods.createGreenText("message.naval_warfare.time_up_opponent").getString(), true);
                }
                NWBasicMethods.messagePlayerCustomRecord(this, oppp, NWBasicMethods.createGreenText("message.naval_warfare.your_turn").getString(), true);
                oppp.m_6330_((SoundEvent)NWSounds.YOUR_TURN.get(), SoundSource.MASTER, 1.0f, 0.5f);
            }
            if (this.cons_timeout_times >= (Integer)NavalWarfareConfig.max_cons_timeouts.get() || this.timeout_times >= (Integer)NavalWarfareConfig.max_timeouts.get()) {
                this.endGame(this.f_58857_, this, false, ownp, false);
                this.endGame(this.f_58857_, ote, true, oppp, true);
                NWBasicMethods.messagePlayerCustomRecord(this, ownp, NWBasicMethods.createRedText("message.naval_warfare.timed_out_own").getString(), false);
                NWBasicMethods.messagePlayerCustomRecord(this, oppp, NWBasicMethods.createGreenText("message.naval_warfare.timed_out_opponent").getString(), true);
            } else {
                this.hit_once = false;
                this.resetTurnTime();
                this.setTurn(false, false);
                ote.setActionNumber(this.action_number + 2);
                ote.setTurn(true, true);
            }
        } else if (!ote.isAlive()) {
            this.endGame(this.f_58857_, this, true, ownp, true);
            this.endGame(this.f_58857_, ote, false, oppp, true);
        } else if (!this.isAlive()) {
            this.endGame(this.f_58857_, this, false, ownp, true);
            this.endGame(this.f_58857_, ote, true, oppp, true);
        } else if (set_hit) {
            this.hit_once = true;
        }
    }

    public void endGame(Level level, GameControllerTE te, boolean won, @Nullable Player player, boolean loot) {
        this.endGame(level, te, won, player, loot, true);
    }

    public void endGame(Level level, GameControllerTE te, boolean won, @Nullable Player player, boolean loot, boolean reset) {
        ServerPlayer sp;
        if (reset) {
            te.setGame(false);
            te.setTurn(false, false);
            te.setBoardSize(0);
            te.setHP(0);
            te.action_number = 0;
            te.resetTurnTime();
            te.setClearBoard(true);
            te.resetActions();
            te.timeout_times = 0;
            te.cons_timeout_times = 0;
            this.hit_once = false;
            this.streak = 0;
            level.m_46597_(te.m_58899_(), (BlockState)te.m_58900_().m_61124_((Property)GameController.STATE, (Comparable)((Object)ControllerState.INACTIVE)));
        }
        if (player == null) {
            return;
        }
        if (loot) {
            this.genFromLootTable(won, false, player);
        }
        if (won) {
            NWBasicMethods.sendGameStatusToPlayer(level, te.getOwner(), "message.naval_warfare.game_won_main", "dark_green", "message.naval_warfare.game_won_sub", "green");
            player.m_6330_((SoundEvent)NWSounds.VICTORY.get(), SoundSource.MASTER, 1.0f, 0.8f);
            NWBasicMethods.messagePlayerCustomRecord(te, player, NWBasicMethods.createGreenText("message.naval_warfare.game_won_main").getString(), false);
            if (player instanceof ServerPlayer) {
                try {
                    sp = (ServerPlayer)player;
                    sp.m_36220_(NWStats.WINS);
                    NWTriggers.WIN.trigger(sp);
                    Stat stat = Stats.f_12988_.m_12899_((Object)new ResourceLocation("naval_warfare", "wins"), StatFormatter.f_12873_);
                    int val = sp.m_8951_().m_13015_(stat);
                    if (val >= 10) {
                        NWTriggers.WIN_10.trigger(sp);
                    }
                    if (val >= 50) {
                        NWTriggers.WIN_50.trigger(sp);
                    }
                }
                catch (NullPointerException e) {
                    NavalWarfare.LOGGER.error("Naval Warfare: Failed to fetch the wins statistic.");
                }
            }
        } else {
            NWBasicMethods.sendGameStatusToPlayer(level, te.getOwner(), "message.naval_warfare.game_lost_main", "dark_red", "message.naval_warfare.game_lost_sub", "red");
            NWBasicMethods.messagePlayerCustomRecord(te, player, NWBasicMethods.createRedText("message.naval_warfare.game_lost_main").getString(), false);
            player.m_6330_((SoundEvent)NWSounds.DEFEAT.get(), SoundSource.MASTER, 1.0f, 0.75f);
        }
        if (player instanceof ServerPlayer) {
            try {
                sp = (ServerPlayer)player;
                sp.m_36220_(NWStats.GAMES_PLAYED);
            }
            catch (NullPointerException e) {
                NavalWarfare.LOGGER.error("Naval Warfare: Failed to fetch the games played statistic.");
            }
        }
    }

    public boolean checkTurn() {
        if (this.turn_time >= MAX_TURN_TIME - 300) {
            if (this.turn_time == MAX_TURN_TIME - 300) {
                this.informSelfOfTimer(this.f_58857_, "message.naval_warfare.time_fifteen", SoundEvents.f_12169_);
                this.informOpponentOfTimer(this.f_58857_, "message.naval_warfare.time_fifteen", SoundEvents.f_12169_);
            } else if (this.turn_time == MAX_TURN_TIME - 100) {
                this.informSelfOfTimer(this.f_58857_, "message.naval_warfare.time_five", SoundEvents.f_12169_);
                this.informOpponentOfTimer(this.f_58857_, "message.naval_warfare.time_five", SoundEvents.f_12169_);
            } else if (this.turn_time == MAX_TURN_TIME - 80) {
                this.informSelfOfTimer(this.f_58857_, "message.naval_warfare.time_four", SoundEvents.f_12169_);
                this.informOpponentOfTimer(this.f_58857_, "message.naval_warfare.time_four", SoundEvents.f_12169_);
            } else if (this.turn_time == MAX_TURN_TIME - 60) {
                this.informSelfOfTimer(this.f_58857_, "message.naval_warfare.time_three", SoundEvents.f_12169_);
                this.informOpponentOfTimer(this.f_58857_, "message.naval_warfare.time_three", SoundEvents.f_12169_);
            } else if (this.turn_time == MAX_TURN_TIME - 40) {
                this.informSelfOfTimer(this.f_58857_, "message.naval_warfare.time_two", SoundEvents.f_12169_);
                this.informOpponentOfTimer(this.f_58857_, "message.naval_warfare.time_two", SoundEvents.f_12169_);
            } else if (this.turn_time == MAX_TURN_TIME - 20) {
                this.informSelfOfTimer(this.f_58857_, "message.naval_warfare.time_one", SoundEvents.f_12169_);
                this.informOpponentOfTimer(this.f_58857_, "message.naval_warfare.time_one", SoundEvents.f_12169_);
            }
        }
        if (this.turn_time >= MAX_TURN_TIME) {
            this.informSelfOfTimer(this.f_58857_, "message.naval_warfare.time_up_own", (SoundEvent)NWSounds.SELF_TIMEOUT.get());
            this.informOpponentOfTimer(this.f_58857_, "message.naval_warfare.time_up_opponent", (SoundEvent)NWSounds.OPPONENT_TIMEOUT.get());
            this.notifyResult(false, true, false);
            return false;
        }
        return true;
    }

    private Player getPlayer() {
        if (this.hasOwner() && !this.owner.equals("dummy")) {
            return this.f_58857_.m_46003_(UUID.fromString(this.owner));
        }
        return null;
    }

    private Player getOpponentPlayer() {
        GameControllerTE te;
        BlockEntity tile;
        if (this.opponent != null && (tile = this.f_58857_.m_7702_(this.opponent)) instanceof GameControllerTE && (te = (GameControllerTE)tile).hasOwner() && !te.getOwner().equals("dummy")) {
            return this.f_58857_.m_46003_(UUID.fromString(te.getOwner()));
        }
        return null;
    }

    public void deployStartingPassiveAbilities(Level level, Player player) {
        Board board;
        BlockState state = level.m_8055_(this.zero);
        if (state.m_60734_() instanceof Board && (board = (Board)state.m_60734_()).validateBoard(level, this.zero)) {
            BoardTE bte = (BoardTE)level.m_7702_(this.zero);
            bte.activateStartPassives(level, player, this.zero, board.getControllerFacing(level, this.zero));
        }
    }

    public void genFromLootTable(boolean won, boolean ai, Player player) {
        Object loot_table;
        if (player.m_7500_()) {
            return;
        }
        Object object = loot_table = won ? "naval_warfare:game_end/game_won" : "naval_warfare:game_end/game_lost";
        if (ai) {
            loot_table = (String)loot_table + "_ai";
        }
        LootTable table = this.f_58857_.m_142572_().m_129898_().m_79217_(new ResourceLocation((String)loot_table));
        LootContext.Builder lootcontext$builder = new LootContext.Builder(this.f_58857_.m_142572_().m_129783_());
        LootContextParamSet.Builder lps$builder = new LootContextParamSet.Builder();
        LootContext context = lootcontext$builder.m_78975_(lps$builder.m_81405_());
        List loot = table.m_79129_(context);
        for (ItemStack stack : loot) {
            NWBasicMethods.addOrSpawn(player, stack, this.f_58857_, player.m_142538_());
        }
    }

    private boolean placeShipRandomly(ShipBlock ship, Direction facing) {
        BlockEntity tile = this.f_58857_.m_7702_(this.zero);
        if (!(tile instanceof BoardTE)) {
            return false;
        }
        BoardTE te = (BoardTE)tile;
        ArrayList<Direction> dirs = new ArrayList<Direction>(Arrays.asList(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST));
        ArrayList<Integer> tiles = new ArrayList<Integer>();
        BlockState state = ship.m_49966_();
        for (int i = 0; i < this.board_size; ++i) {
            tiles.add(i);
        }
        Collections.shuffle(tiles);
        Iterator iterator = tiles.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Collections.shuffle(dirs);
            for (Direction dir : dirs) {
                BlockPos pos = te.locateId(te.m_58899_(), i, facing);
                if (pos == null || !ship.summonShip(this.f_58857_, pos.m_7494_(), (BlockState)state.m_61124_((Property)ShipBlock.FACING, (Comparable)dir), true, false)) continue;
                return true;
            }
        }
        return false;
    }

    public void resetBoard(Player player) {
        GameController controller = (GameController)this.m_58900_().m_60734_();
        controller.removeBoardAndShips(this.f_58857_, this, false);
        controller.spawnBoard(this.f_58857_, player, this, this.f_58858_, this.board_size, false);
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("naval_warfare", (Tag)NBTHelper.toNBT((Object)this));
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        CompoundTag initvalues = compound.m_128469_("naval_warfare");
        if (!initvalues.m_128456_()) {
            ControllerActionHelper cah;
            CompoundTag cnbt;
            ListTag list;
            this.owner = initvalues.m_128461_("owner");
            CompoundTag zero_board = initvalues.m_128469_("zero");
            this.zero = zero_board.m_128441_("no_pos") ? null : NBTHelper.readBlockPos(zero_board);
            CompoundTag opponent_pos = initvalues.m_128469_("opponent");
            this.opponent = opponent_pos.m_128441_("no_pos") ? null : NBTHelper.readBlockPos(opponent_pos);
            CompoundTag opponent_zero_pos = initvalues.m_128469_("opponent_zero");
            this.opponent_zero = opponent_zero_pos.m_128441_("no_pos") ? null : NBTHelper.readBlockPos(opponent_zero_pos);
            this.actions = new ArrayList();
            if (initvalues.m_128441_("actions")) {
                list = initvalues.m_128437_("actions", 10);
                for (Tag nbt : list) {
                    cnbt = (CompoundTag)nbt;
                    cah = NBTHelper.readCAH(cnbt);
                    this.addAction(cah);
                }
            }
            this.turn_actions = new ArrayList();
            if (initvalues.m_128441_("turn_actions")) {
                list = initvalues.m_128437_("actions", 10);
                for (Tag nbt : list) {
                    cnbt = (CompoundTag)nbt;
                    cah = NBTHelper.readCAH(cnbt);
                    this.addTurnAction(cah);
                }
            }
            this.results = new ArrayList();
            if (initvalues.m_128441_("results")) {
                list = initvalues.m_128437_("results", 10);
                for (Tag nbt : list) {
                    cnbt = (CompoundTag)nbt;
                    TargetResultHelper trh = NBTHelper.readTRH(cnbt);
                    this.addResult(trh);
                }
            }
            this.registered = new ArrayList();
            if (initvalues.m_128441_("registered")) {
                list = initvalues.m_128437_("registered", 10);
                for (Tag nbt : list) {
                    cnbt = (CompoundTag)nbt;
                    this.register(cnbt.m_128461_("ship"));
                }
            }
            this.register_buffer = new ArrayList();
            if (initvalues.m_128441_("register_buffer")) {
                list = initvalues.m_128437_("register_buffer", 10);
                for (Tag nbt : list) {
                    cnbt = (CompoundTag)nbt;
                    this.addRegisterToBuffer(cnbt.m_128461_("ship"));
                }
            }
            this.playing_game = initvalues.m_128471_("playing_game");
            this.clear_board = initvalues.m_128471_("clear_board");
            this.has_turn = initvalues.m_128471_("has_turn");
            this.turn_time = initvalues.m_128451_("turn_time");
            this.board_size = initvalues.m_128451_("board_size");
            this.hp = initvalues.m_128451_("hp");
            this.config_name = initvalues.m_128461_("name");
            this.action_time = initvalues.m_128451_("action_time");
            this.action_number = initvalues.m_128451_("action_number");
            this.energy = initvalues.m_128451_("energy");
            this.do_turn_actions = initvalues.m_128471_("do_turn_actions");
            this.turn_action_amount = initvalues.m_128451_("turn_action_amount");
            this.has_spell = initvalues.m_128471_("has_spell");
            this.cons_timeout_times = initvalues.m_128451_("cons_timeout_times");
            this.timeout_times = initvalues.m_128451_("timeout_times");
            this.reg_buffer_time = initvalues.m_128451_("reg_buffer_time");
            this.hit_once = initvalues.m_128471_("hit_once");
            this.streak = initvalues.m_128451_("streak");
            this.m_6596_();
        }
    }

    public void tick() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.playing_game) {
            if (this.clear_board) {
                if (this.turn_time < CLEAR_BOARD_TIME) {
                    ++this.turn_time;
                } else {
                    this.saveRecorder();
                    this.clear_board = false;
                    this.turn_time = -1;
                    GameController controller = (GameController)this.m_58900_().m_60734_();
                    controller.removeBoardAndShips(this.f_58857_, this);
                }
                this.m_6596_();
            } else if (this.hasRegInBuffer()) {
                if (this.reg_buffer_time >= 5) {
                    GameController controller;
                    boolean placed;
                    this.reg_buffer_time = 0;
                    ShipBlock ship = NWBasicMethods.getShipFromRegname(this.register_buffer.get(0));
                    if (ship != null && (placed = this.placeShipRandomly(ship, (controller = (GameController)this.m_58900_().m_60734_()).getFacing(this.m_58900_())))) {
                        this.register(this.register_buffer.get(0));
                        this.addHP(ship.getMaxHP());
                    }
                    this.register_buffer.remove(0);
                } else {
                    ++this.reg_buffer_time;
                }
            }
        } else if (this.has_turn && this.checkTurn()) {
            if (this.do_turn_actions) {
                if (this.hasTurnWork()) {
                    this.turn_action_amount = this.turn_actions.size();
                }
                this.do_turn_actions = false;
            }
            if (this.hasTurnWork()) {
                if (this.shouldDoTurnWork()) {
                    this.doTurnWork();
                    --this.turn_action_amount;
                    this.action_time = 0;
                } else {
                    ++this.action_time;
                }
            } else if (this.hasWork()) {
                if (this.shouldDoWork()) {
                    this.doWork();
                    this.action_time = 0;
                } else {
                    ++this.action_time;
                }
            } else {
                ++this.turn_time;
            }
            this.m_6596_();
        }
    }
}

