/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.tileentity;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWTileEntityTypes;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.NBTHelper;

public class PassiveAbilityTE
extends BlockEntity {
    protected ArrayList<String> owners = new ArrayList();
    private BlockPos matching = null;

    public PassiveAbilityTE(BlockPos pos, BlockState state) {
        super((BlockEntityType)NWTileEntityTypes.PASSIVE_BLOCK.get(), pos, state);
    }

    public PassiveAbilityTE(BlockPos pos, BlockState state, boolean shield) {
        super((BlockEntityType)NWTileEntityTypes.ENERGY_SHIELD.get(), pos, state);
    }

    public BlockPos getMatching() {
        return this.matching;
    }

    public void setMatching(BlockPos match) {
        this.matching = match;
    }

    public boolean hasMatching() {
        return this.matching != null;
    }

    public String getOwner() {
        return this.owners.isEmpty() ? "null" : this.owners.get(0);
    }

    public ArrayList<String> ownersToString() {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.getOwners()) {
            result.add(NWBasicMethods.getTranslation("block.naval_warfare." + s));
        }
        return result;
    }

    public ArrayList<String> getOwners() {
        return this.owners;
    }

    public void addOwner(String owner) {
        if (!this.owners.contains(owner)) {
            this.owners.add(owner);
        }
    }

    public void removeOwner(String owner) {
        this.owners.remove(owner);
    }

    public int ownerAmount() {
        return this.owners.size();
    }

    public boolean hasOwner() {
        return !this.owners.isEmpty();
    }

    public void destroy(Level level, BlockPos pos, String owned, GameControllerTE controller, int offset) {
        if (this.owners.contains(owned)) {
            ArrayList<BlockPos> positions = this.destroyPropagate(level, pos, owned, new ArrayList<BlockPos>(), controller);
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (BlockPos p : positions) {
                if (!level.m_8055_(p).m_60734_().equals(Blocks.f_50016_) || !(level.m_7702_(p.m_6625_(offset)) instanceof BoardTE)) continue;
                BoardTE te = (BoardTE)level.m_7702_(p.m_6625_(offset));
                ids.add(te.getId());
            }
            if (!ids.isEmpty() && controller != null) {
                controller.recordOnRecorders(BattleLogHelper.createSetBlocks(ids, Blocks.f_50016_.getRegistryName(), offset, false));
            }
        }
    }

    public ArrayList<BlockPos> destroyPropagate(Level level, BlockPos pos, String owned, ArrayList<BlockPos> known, GameControllerTE controller) {
        if (known.contains(pos)) {
            return known;
        }
        known.add(pos);
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof PassiveAbilityTE) {
            PassiveAbilityTE te = (PassiveAbilityTE)tile;
            te.removeOwner(owned);
            if (!te.hasOwner()) {
                if (te.hasMatching()) {
                    level.m_46597_(te.getMatching(), Blocks.f_50016_.m_49966_());
                }
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        } else {
            return known;
        }
        ArrayList<BlockPos> new_known = this.destroyPropagate(level, pos.m_142127_(), owned, known, controller);
        new_known = this.destroyPropagate(level, pos.m_142126_(), owned, new_known, controller);
        new_known = this.destroyPropagate(level, pos.m_142128_(), owned, new_known, controller);
        new_known = this.destroyPropagate(level, pos.m_142125_(), owned, new_known, controller);
        return new_known;
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("naval_warfare", (Tag)NBTHelper.toNBT((Object)this));
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        CompoundTag initvalues = compound.m_128469_("naval_warfare");
        if (initvalues != null) {
            ListTag ListTag2 = initvalues.m_128437_("owners", 10);
            ArrayList<String> new_owners = new ArrayList<String>();
            for (Tag nbt : ListTag2) {
                CompoundTag cnbt = (CompoundTag)nbt;
                new_owners.add(cnbt.m_128461_("owner"));
            }
            this.owners = new_owners;
            if (initvalues.m_128441_("matching")) {
                CompoundTag matchnbt = initvalues.m_128469_("matching");
                this.matching = new BlockPos(matchnbt.m_128451_("x"), matchnbt.m_128451_("y"), matchnbt.m_128451_("z"));
            } else {
                this.matching = null;
            }
        }
    }
}

