/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.tileentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import slimeattack07.naval_warfare.config.NavalWarfareConfig;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWTileEntityTypes;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.helpers.NBTHelper;

public class RandomShipTE
extends BlockEntity {
    public boolean can_spawn = true;

    public RandomShipTE(BlockPos pos, BlockState state) {
        super((BlockEntityType)NWTileEntityTypes.RANDOM_SHIP.get(), pos, state);
    }

    private ArrayList<BlockPos> spawnDisplays(Level level, BlockPos pos) {
        ArrayList<BlockPos> locations = new ArrayList<BlockPos>();
        for (int i = -2; i < 3; ++i) {
            for (int k = -2; k < 3; ++k) {
                BlockPos loc = pos.m_142082_(i, -2, k);
                locations.add(loc.m_7494_());
                level.m_46597_(loc, ((Block)NWBlocks.SHIP_DISPLAY.get()).m_49966_());
            }
        }
        Collections.shuffle(locations);
        return locations;
    }

    @Nullable
    private ShipBlock generateRandomShip() {
        int total_weight;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int result = rand.nextInt(total_weight = (Integer)NavalWarfareConfig.cc_ship_t1_weight.get() + (Integer)NavalWarfareConfig.cc_ship_t2_weight.get() + (Integer)NavalWarfareConfig.cc_ship_t3_weight.get() + (Integer)NavalWarfareConfig.cc_ship_t4_weight.get() + (Integer)NavalWarfareConfig.cc_ship_t5_weight.get());
        if (result <= (Integer)NavalWarfareConfig.cc_ship_t1_weight.get()) {
            return this.tagToShip("ships_t1", rand);
        }
        if ((result -= ((Integer)NavalWarfareConfig.cc_ship_t1_weight.get()).intValue()) <= (Integer)NavalWarfareConfig.cc_ship_t2_weight.get()) {
            return this.tagToShip("ships_t2", rand);
        }
        if ((result -= ((Integer)NavalWarfareConfig.cc_ship_t2_weight.get()).intValue()) <= (Integer)NavalWarfareConfig.cc_ship_t3_weight.get()) {
            return this.tagToShip("ships_t3", rand);
        }
        if ((result -= ((Integer)NavalWarfareConfig.cc_ship_t3_weight.get()).intValue()) <= (Integer)NavalWarfareConfig.cc_ship_t4_weight.get()) {
            return this.tagToShip("ships_t4", rand);
        }
        return this.tagToShip("ships_t5", rand);
    }

    @Nullable
    private ShipBlock tagToShip(String tag, Random rand) {
        Block block = NWBasicMethods.getRandomTaggedBlock(tag, rand, NWBlocks.NW_SHIPS);
        if (block != null && block instanceof ShipBlock) {
            return (ShipBlock)block;
        }
        return null;
    }

    private ArrayList<Direction> randomDirections() {
        ArrayList<Direction> dirs = new ArrayList<Direction>(Arrays.asList(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST));
        Collections.shuffle(dirs);
        return dirs;
    }

    private boolean spawnShip(ShipBlock ship, Level level, BlockPos pos, BlockState state) {
        return ship.summonShip(level, pos, state, true, true);
    }

    private void summonShipRandomly(ShipBlock ship, Level level, ArrayList<BlockPos> locations) {
        for (BlockPos pos : locations) {
            ArrayList<Direction> dirs = this.randomDirections();
            for (Direction dir : dirs) {
                BlockState state = (BlockState)ship.m_49966_().m_61124_((Property)ShipBlock.FACING, (Comparable)dir);
                if (!this.spawnShip(ship, level, pos, state)) continue;
                ship.propagateAbilityAmount(level, pos, 0);
                return;
            }
        }
    }

    public void tick() {
        if (this.f_58857_.m_5776_() || !this.can_spawn) {
            return;
        }
        this.can_spawn = false;
        ArrayList<BlockPos> locations = this.spawnDisplays(this.f_58857_, this.f_58858_);
        ShipBlock ship = this.generateRandomShip();
        if (ship == null) {
            return;
        }
        this.summonShipRandomly(ship, this.f_58857_, locations);
        this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        CompoundTag initvalues = compound.m_128469_("naval_warfare");
        if (initvalues != null) {
            this.can_spawn = initvalues.m_128471_("can_spawn");
        }
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("naval_warfare", (Tag)NBTHelper.toNBT((Object)this));
    }
}

