/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util;

import net.minecraft.util.StringRepresentable;

public enum BoardState implements StringRepresentable
{
    NEUTRAL("neutral"),
    HIGHLIGHTED("highlighted"),
    EMPTY("empty"),
    HIT("hit"),
    HIGHEMPTY("highempty"),
    HIGHHIT("highhit");

    private final String name;

    public String m_7912_() {
        return this.name;
    }

    private BoardState(String name) {
        this.name = name;
    }

    public boolean isHit() {
        return this.equals((Object)HIT) || this.equals((Object)HIGHHIT);
    }

    public boolean isKnown() {
        return !this.equals((Object)NEUTRAL) && !this.equals((Object)HIGHLIGHTED);
    }

    public boolean isEmpty() {
        return this.equals((Object)EMPTY) || this.equals((Object)HIGHEMPTY);
    }

    public boolean isHighlighted() {
        return this.equals((Object)HIGHEMPTY) || this.equals((Object)HIGHHIT) || this.equals((Object)HIGHLIGHTED);
    }

    public BoardState select() {
        switch (this) {
            case EMPTY: {
                return HIGHEMPTY;
            }
            case HIT: {
                return HIGHHIT;
            }
            case NEUTRAL: {
                return HIGHLIGHTED;
            }
        }
        return this;
    }

    public BoardState deselect() {
        switch (this) {
            case HIGHEMPTY: {
                return EMPTY;
            }
            case HIGHHIT: {
                return HIT;
            }
            case HIGHLIGHTED: {
                return NEUTRAL;
            }
        }
        return this;
    }
}

