/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import slimeattack07.naval_warfare.network.NavalNetwork;
import slimeattack07.naval_warfare.network.message.ItemAnimationMessage;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;

public class NWBasicMethods {
    public static void reduceStack(ItemStack item, int amount) {
        item.m_41764_(item.m_41613_() - amount);
    }

    public static void destroyStack(ItemStack item) {
        item.m_41764_(0);
    }

    public static void spawn(ItemStack item_in, Level level, BlockPos pos, double xoff, double yoff, double zoff) {
        ItemEntity ent = new ItemEntity(level, (double)pos.m_123341_() + xoff, (double)pos.m_123342_() + yoff, (double)pos.m_123343_() + zoff, item_in.m_41777_());
        level.m_7967_((Entity)ent);
    }

    public static boolean tryAdding(Player player, ItemStack item_in) {
        return player == null ? false : player.m_150109_().m_36054_(item_in.m_41777_());
    }

    public static void addOrSpawn(Player player, ItemStack item_in, Level level, BlockPos pos) {
        if (!NWBasicMethods.tryAdding(player, item_in)) {
            ItemEntity ent = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, item_in.m_41777_());
            level.m_7967_((Entity)ent);
        }
    }

    public static void messagePlayerBack(Player player, String translation, String back) {
        player.m_6352_((Component)new TextComponent(new TranslatableComponent(translation).getString() + back), Util.f_137441_);
    }

    public static void messagePlayerFront(Player player, String front, String translation) {
        player.m_6352_((Component)new TextComponent(front + new TranslatableComponent(translation).getString()), Util.f_137441_);
    }

    public static void messagePlayer(Player player, String translation) {
        if (player != null) {
            player.m_6352_((Component)new TextComponent(new TranslatableComponent(translation).getString()), Util.f_137441_);
        }
    }

    public static void messagePlayerCustom(Player player, String message) {
        if (player != null) {
            player.m_6352_((Component)new TextComponent(message), Util.f_137441_);
        }
    }

    public static void messagePlayerCustomRecord(@Nullable GameControllerTE controller, Player player, String message, boolean opponent) {
        TextComponent component = new TextComponent(message);
        if (player != null) {
            player.m_6352_((Component)component, Util.f_137441_);
        }
        if (controller != null) {
            if (opponent) {
                controller.recordOnOppRecorder(BattleLogHelper.createMessage(Component.Serializer.m_130703_((Component)component)));
            } else {
                controller.recordOnRecorder(BattleLogHelper.createMessage(Component.Serializer.m_130703_((Component)component)));
            }
        }
    }

    public static void messagePlayerActionbarCustom(Player player, String message) {
        if (player != null) {
            player.m_5661_((Component)new TextComponent(message), true);
        }
    }

    public static void messagePlayerActionbar(Player player, String translation) {
        if (player != null) {
            player.m_5661_((Component)new TextComponent(new TranslatableComponent(translation).getString()), true);
        }
    }

    public static void messagePlayerActionbarBack(Player player, String translation, String back) {
        if (player != null) {
            player.m_5661_((Component)new TextComponent(new TranslatableComponent(translation).getString() + back), true);
        }
    }

    public static String getTranslation(String translation) {
        return new TranslatableComponent(translation).getString();
    }

    public static String getTranslation(Block block) {
        return new TranslatableComponent("block." + block.getRegistryName().toString().replace(":", ".")).getString();
    }

    public static TextComponent createColoredText(String translation, ChatFormatting color, boolean newline) {
        Object text = new TranslatableComponent(translation).getString();
        if (newline) {
            text = (String)text + System.lineSeparator();
        }
        return new TextComponent(color + (String)text);
    }

    public static TextComponent createColoredText(String translation, ChatFormatting color) {
        return NWBasicMethods.createColoredText(translation, color, false);
    }

    public static TextComponent createBlueText(String translation) {
        return NWBasicMethods.createColoredText(translation, ChatFormatting.BLUE);
    }

    public static TextComponent createGrayText(String translation) {
        return NWBasicMethods.createColoredText(translation, ChatFormatting.GRAY);
    }

    public static TextComponent createGrayText(String translation, String back) {
        String text = NWBasicMethods.getTranslation(translation);
        return NWBasicMethods.createColoredText(text + back, ChatFormatting.GRAY);
    }

    public static TextComponent createGreenText(String translation) {
        return NWBasicMethods.createColoredText(translation, ChatFormatting.GREEN);
    }

    public static TextComponent createDGreenText(String translation) {
        return NWBasicMethods.createColoredText(translation, ChatFormatting.DARK_GREEN);
    }

    public static TextComponent createRedText(String translation) {
        return NWBasicMethods.createColoredText(translation, ChatFormatting.RED);
    }

    public static String getOwnShipHitMessage(String ship, int id) {
        String message = NWBasicMethods.getTranslation("message.naval_warfare.own_ship_hit");
        String temp = NWBasicMethods.coloredReplace(message, "MARKER1", ship, ChatFormatting.GOLD);
        return NWBasicMethods.coloredReplace(temp, "MARKER2", "" + id, ChatFormatting.BLUE);
    }

    public static String getOwnShipDestroyedMessage(String ship) {
        String message = NWBasicMethods.getTranslation("message.naval_warfare.own_ship_destroyed");
        return NWBasicMethods.coloredReplace(message, "MARKER1", ship, ChatFormatting.DARK_RED);
    }

    public static String getOwnShipMissedMessage(int id) {
        String message = NWBasicMethods.getTranslation("message.naval_warfare.own_ship_missed");
        return NWBasicMethods.coloredReplace(message, "MARKER1", "" + id, ChatFormatting.BLUE);
    }

    public static String getOpponentShipHitMessage(int id) {
        String message = NWBasicMethods.getTranslation("message.naval_warfare.opponent_ship_hit");
        return NWBasicMethods.coloredReplace(message, "MARKER2", "" + id, ChatFormatting.BLUE);
    }

    public static String getOpponentShipDestroyedMessage(String ship) {
        String message = NWBasicMethods.getTranslation("message.naval_warfare.opponent_ship_destroyed");
        return NWBasicMethods.coloredReplace(message, "MARKER1", ship, ChatFormatting.DARK_RED);
    }

    public static String getOpponentShipMissedMessage(int id) {
        String message = NWBasicMethods.getTranslation("message.naval_warfare.opponent_ship_missed");
        return NWBasicMethods.coloredReplace(message, "MARKER1", "" + id, ChatFormatting.BLUE);
    }

    private static String coloredReplace(String message, String target, String replacement, ChatFormatting color) {
        String[] parts = message.split(target);
        if (parts.length != 2) {
            return message;
        }
        String colored = new TextComponent(color + replacement).m_131292_();
        String end = new TextComponent(ChatFormatting.WHITE + parts[1]).m_131292_();
        return parts[0] + colored + end;
    }

    public static void messagePlayerTitle(Player player, Level level, String title, String title_color, String subtitle, String subtitle_color) {
        if (player == null) {
            return;
        }
        CommandSourceStack source = player.m_20203_().m_81325_(4).m_81324_();
        String title_text = "title @s title {\"text\":\"" + NWBasicMethods.getTranslation(title) + "\",\"color\":\"" + title_color + "\"}";
        String subtitle_text = "title @s subtitle {\"text\":\"" + NWBasicMethods.getTranslation(subtitle) + "\",\"color\":\"" + subtitle_color + "\"}";
        level.m_142572_().m_129892_().m_82117_(source, "title @s times 10 20 10");
        if (!subtitle.isEmpty()) {
            level.m_142572_().m_129892_().m_82117_(source, subtitle_text);
        }
        level.m_142572_().m_129892_().m_82117_(source, title_text);
    }

    public static void sendGameStatusToPlayer(Level level, String owner, String title, String title_color, String subtitle, String subtitle_color) {
        if (owner.equals("dummy")) {
            return;
        }
        Player player = level.m_46003_(UUID.fromString(owner));
        if (player != null) {
            NWBasicMethods.messagePlayerTitle(player, level, title, title_color, subtitle, subtitle_color);
        }
    }

    public static void sendGameStatusToPlayer(Level level, String owner, String title, String title_color) {
        NWBasicMethods.sendGameStatusToPlayer(level, owner, title, title_color, "", "");
    }

    public static Direction rotateToMatch(Direction dir1, Direction dir2, Direction dir3) {
        if (dir1.equals((Object)dir2)) {
            return dir3;
        }
        if (dir1.equals((Object)dir2.m_122424_())) {
            return dir3.m_122424_();
        }
        if (dir1.equals((Object)dir2.m_122427_())) {
            return dir3.m_122428_();
        }
        return dir3.m_122427_();
    }

    public static void animateItemUse(Player player, Item item) {
        if (player instanceof ServerPlayer && item != null) {
            NavalNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ItemAnimationMessage(new ItemStack((ItemLike)item)));
        }
    }

    public static MutableComponent hoverableText(String text, String color, String hover) {
        String json = "{\"text\":\"" + text + "\",\"color\":\"" + color + "\",\"hoverEvent\":{\"action\":\"show_text\",\"contents\":[{\"text\":\"" + hover + "\",\"color\":\"" + color + "\"}]}}";
        return Component.Serializer.m_130701_((String)json);
    }

    public static void messagePlayerAbilityUsed(@Nullable GameControllerTE controller, Player player, String front, String user, MutableComponent hover) {
        if (player == null) {
            return;
        }
        Object part_a = NWBasicMethods.getTranslation(front);
        if (user != null) {
            part_a = "(" + user + ") " + (String)part_a;
        }
        TextComponent component = new TextComponent((String)part_a + ": ");
        component.m_7220_((Component)hover);
        player.m_6352_((Component)component, Util.f_137441_);
        if (controller != null) {
            controller.recordOnRecorders(BattleLogHelper.createMessage(Component.Serializer.m_130703_((Component)component)));
        }
    }

    public static void dropBlock(Level level, BlockPos pos, Block block) {
        NWBasicMethods.dropBlock(level, pos, 6.5, 30, block);
    }

    public static void dropBlock(Level level, BlockPos pos, double offset, int time, Block block) {
        FallingBlockEntity falling = new FallingBlockEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + offset, (double)pos.m_123343_() + 0.5, block.m_49966_());
        falling.f_31942_ = 1;
        falling.f_19797_ = 600 - time;
        level.m_7967_((Entity)falling);
    }

    public static ItemStack getRandomTaggedItem(String tag, Random rand, DeferredRegister<Item> register) {
        List items = register.getEntries().stream().filter(item -> ((Item)item.get()).getTags().contains(new ResourceLocation("naval_warfare", tag))).collect(Collectors.toList());
        if (items == null || items.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)((RegistryObject)items.get(rand.nextInt(items.size()))).get());
    }

    @Nullable
    public static Block getRandomTaggedBlock(String tag, Random rand, DeferredRegister<Block> register) {
        List blocks = register.getEntries().stream().filter(item -> ((Block)item.get()).getTags().contains(new ResourceLocation("naval_warfare", tag))).collect(Collectors.toList());
        if (blocks == null || blocks.isEmpty()) {
            return null;
        }
        return (Block)((RegistryObject)blocks.get(rand.nextInt(blocks.size()))).get();
    }

    @Nullable
    public static ShipBlock getShipFromRegname(String name) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        if (block == null || !(block instanceof ShipBlock)) {
            return null;
        }
        return (ShipBlock)block;
    }
}

