/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.tileentity.PassiveAbilityTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;

public class AntiAir
implements Ability {
    private final String NAME;
    private final String OWNER;
    private final int UP;
    private final int DOWN;
    private final int LEFT;
    private final int RIGHT;
    private final PassiveType TYPE;

    public AntiAir(String name, String owner, int up, int down, int left, int right, boolean deployable) {
        this.NAME = name;
        this.OWNER = owner;
        this.UP = up;
        this.DOWN = down;
        this.LEFT = left;
        this.RIGHT = right;
        this.TYPE = deployable ? PassiveType.DEPLOYED : PassiveType.START_GAME;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        Board b;
        GameControllerTE controller;
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (BoardTE te : tiles) {
            BlockPos pos = te.m_58899_().m_6630_(5);
            level.m_46597_(pos, ((Block)NWBlocks.ANTI_AIR.get()).m_49966_());
            BlockEntity ptile = level.m_7702_(pos);
            if (ptile instanceof PassiveAbilityTE) {
                PassiveAbilityTE pte = (PassiveAbilityTE)ptile;
                pte.addOwner(this.OWNER);
            }
            ids.add(te.getId());
        }
        if (!ids.isEmpty() && (controller = (b = (Board)board.m_58900_().m_60734_()).getController(level, board.m_58899_())) != null) {
            controller.recordOnRecorders(BattleLogHelper.createSetBlocks(ids, ((Block)NWBlocks.ANTI_AIR.get()).getRegistryName(), 5, false));
        }
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        if (te == null) {
            return new ArrayList<BoardTE>();
        }
        BlockPos up = te.m_58899_().m_7494_();
        BlockState state = level.m_8055_(up);
        Direction dir = ShipBlock.getFacing(state);
        return te.collectTileArea(this.UP, this.DOWN, this.LEFT, this.RIGHT, dir);
    }

    @Override
    public PassiveType getPassiveType() {
        return this.TYPE;
    }

    @Override
    public void detachPassive(Level level, BoardTE board) {
        BlockPos pos;
        BlockEntity tile;
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        if (!tiles.isEmpty() && (tile = level.m_7702_(pos = tiles.get(0).m_58899_().m_6630_(5))) instanceof PassiveAbilityTE) {
            PassiveAbilityTE pte = (PassiveAbilityTE)tile;
            Board b = (Board)board.m_58900_().m_60734_();
            pte.destroy(level, pos, this.OWNER, b.getController(level, board.m_58899_()), 5);
        }
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("misc.naval_warfare.length") + ": " + (this.LEFT + this.RIGHT - 1) + ", ";
        hover = hover + NWBasicMethods.getTranslation("misc.naval_warfare.width") + ": " + (this.UP + this.DOWN - 1);
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }
}

