/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.RegistryObject;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.BoardState;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;

public class Deployable
implements Ability {
    private final int AMOUNT;
    private final int COST;
    private final String NAME;
    private final RegistryObject<Item> ITEM;
    protected final ShipBlock SHIP;

    public Deployable(int amount, int cost, String name, RegistryObject<Item> item, ShipBlock ship) {
        this.NAME = name;
        this.AMOUNT = amount;
        this.COST = cost;
        this.ITEM = item;
        this.SHIP = ship;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        if (tiles.isEmpty()) {
            return;
        }
        BoardTE te = tiles.get(0);
        BlockPos pos = te.m_58899_().m_7494_();
        ArrayList dirs = Lists.newArrayList((Object[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
        Collections.shuffle(dirs);
        boolean success = false;
        for (Direction dir : dirs) {
            Board b;
            GameControllerTE controller;
            success = this.SHIP.summonShip(level, pos, (BlockState)this.SHIP.m_49966_().m_61124_((Property)ShipBlock.FACING, (Comparable)dir), true, false);
            if (!success) continue;
            if (this.SHIP.hasPassiveAbility() && this.SHIP.PASSIVE_ABILITY.getPassiveType().equals((Object)PassiveType.DEPLOYED)) {
                this.SHIP.PASSIVE_ABILITY.activate(level, player, board);
            }
            if ((controller = (b = (Board)board.m_58900_().m_60734_()).getController(level, board.m_58899_())) == null) break;
            controller.recordOnRecorders(BattleLogHelper.createDeployable(board.getId(), this.SHIP.getRegistryName(), dir));
            break;
        }
        if (!success) {
            NWBasicMethods.messagePlayer(player, "message.naval_warfare.failed_deploy");
        }
        Board b = (Board)te.m_58900_().m_60734_();
        BoardState bstate = b.getBoardState(te.m_58900_());
        level.m_46597_(te.m_58899_(), (BlockState)te.m_58900_().m_61124_((Property)Board.STATE, (Comparable)((Object)bstate.deselect())));
    }

    @Override
    public int getAmount() {
        return this.AMOUNT;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        if (te == null) {
            return new ArrayList<BoardTE>();
        }
        ArrayList<BoardTE> tiles = new ArrayList<BoardTE>();
        tiles.add(te);
        return tiles;
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("misc.naval_warfare.cost") + ": " + this.COST + ", ";
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }

    @Override
    public boolean targetDefensive() {
        return true;
    }

    @Override
    public Item getAnimationItem() {
        return (Item)this.ITEM.get();
    }

    @Override
    public int energyCost() {
        return this.COST;
    }
}

