/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import slimeattack07.naval_warfare.config.NavalWarfareConfig;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class EndTurn
implements Ability {
    private final String NAME;

    public EndTurn(String name) {
        this.NAME = name;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        BlockPos opp;
        Board b = (Board)board.m_58900_().m_60734_();
        GameControllerTE controller = b.getController(level, board.m_58899_());
        if (controller == null) {
            return;
        }
        GameController control = (GameController)controller.m_58900_().m_60734_();
        if (!control.validateController(level, opp = controller.getOpponent())) {
            return;
        }
        controller = (GameControllerTE)level.m_7702_(opp);
        control = (GameController)controller.m_58900_().m_60734_();
        controller.addAction(ControllerActionHelper.createEndTurn());
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public String getPassiveCategory() {
        return "abilities.naval_warfare.turn_end";
    }

    @Override
    public PassiveType getPassiveType() {
        return PassiveType.HIT;
    }

    @Override
    public MutableComponent hoverableInfo() {
        String translation = (Boolean)NavalWarfareConfig.reveal_on_hit_passives.get() != false ? this.getTranslation() : this.getPassiveCategory();
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(translation) + ChatFormatting.WHITE;
        return NWBasicMethods.hoverableText(name, "gray", "");
    }

    @Override
    public Item getAnimationItem() {
        return (Item)NWItems.END_TURN.get();
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        return new ArrayList<BoardTE>();
    }
}

