/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class EnergyIncrease
implements Ability {
    private final String NAME;
    private final int AMOUNT;
    private final int ENERGY;
    private final PassiveType TYPE;

    public EnergyIncrease(String name, int amount, int energy, PassiveType type) {
        this.NAME = name;
        this.AMOUNT = amount;
        this.ENERGY = energy;
        switch (type) {
            case START_GAME: 
            case DESTROYED: 
            case NOT: {
                this.TYPE = type;
                break;
            }
            default: {
                this.TYPE = PassiveType.NOT;
            }
        }
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        Board b = (Board)board.m_58900_().m_60734_();
        GameControllerTE controller = b.getController(level, board.m_58899_());
        if (controller == null) {
            return;
        }
        if (this.TYPE.equals((Object)PassiveType.DESTROYED)) {
            BlockPos opp;
            GameController control = (GameController)controller.m_58900_().m_60734_();
            if (!control.validateController(level, opp = controller.getOpponent())) {
                return;
            }
            controller = (GameControllerTE)level.m_7702_(opp);
            control = (GameController)controller.m_58900_().m_60734_();
        }
        controller.addAction(ControllerActionHelper.createEnergyGain(this.ENERGY, !this.TYPE.equals((Object)PassiveType.DESTROYED)));
    }

    @Override
    public int getAmount() {
        return this.AMOUNT;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public PassiveType getPassiveType() {
        return this.TYPE;
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        Object hover = this.TYPE.equals((Object)PassiveType.NOT) ? NWBasicMethods.getTranslation("misc.naval_warfare.energy_cost") + ": " + this.ENERGY + ", " : "";
        hover = NWBasicMethods.getTranslation("misc.naval_warfare.amount") + ": " + this.ENERGY;
        return NWBasicMethods.hoverableText(name, "gray", (String)hover);
    }

    @Override
    public Item getAnimationItem() {
        switch (this.TYPE) {
            case DESTROYED: {
                return (Item)NWItems.ENERGY_GRANT.get();
            }
            case START_GAME: {
                return (Item)NWItems.ENERGY_START.get();
            }
        }
        return (Item)NWItems.ENERGY_GAIN.get();
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        return new ArrayList<BoardTE>();
    }

    @Override
    public boolean needsTarget() {
        return false;
    }
}

