/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.TargetType;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class EnergyOverloader
implements Ability {
    private final int AMOUNT;
    private final int COST;
    private final String NAME;
    private final Block ANIMATION;

    public EnergyOverloader(int amount, int cost, String name, Block animation) {
        this.AMOUNT = amount;
        this.COST = cost;
        this.NAME = name;
        this.ANIMATION = animation;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        GameController control = null;
        GameControllerTE controller = null;
        String playername = "dummy";
        if (!tiles.isEmpty()) {
            Board b = (Board)tiles.get(0).m_58900_().m_60734_();
            b.selectTiles(level, tiles);
        }
        for (BoardTE te : tiles) {
            BoardTE matching;
            BlockPos pos = te.getController();
            BlockState state = level.m_8055_(pos);
            if (control == null) {
                control = (GameController)state.m_60734_();
                if (state.m_60734_() instanceof GameController) {
                    if (control.validateController(level, pos)) {
                        controller = (GameControllerTE)level.m_7702_(pos);
                        playername = controller.getOwner();
                    }
                } else {
                    return;
                }
            }
            if ((matching = control.getOpponentBoardTile(level, controller, te.getId(), false)) == null) continue;
            ControllerActionHelper cah = ControllerActionHelper.createTargetAction(20, matching.m_58899_(), playername, matching.m_58899_(), te.m_58899_(), 1, TargetType.OVERLOADER, false, true, this.ANIMATION);
            controller.addAction(cah);
            NWBasicMethods.dropBlock(level, te.m_58899_(), this.ANIMATION);
            NWBasicMethods.dropBlock(level, matching.m_58899_(), this.ANIMATION);
            controller.recordOnRecorders(BattleLogHelper.createDropBlock(te.getId(), true, this.ANIMATION.getRegistryName()));
        }
    }

    @Override
    public int getAmount() {
        return this.AMOUNT;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        ArrayList<BoardTE> tiles = new ArrayList<BoardTE>();
        tiles.add(te);
        return tiles;
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("ability.naval_warfare.energy_cost") + ": " + this.COST;
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }

    @Override
    public Item getAnimationItem() {
        return (Item)NWItems.ENERGY_OVERLOADER.get();
    }

    @Override
    public int energyCost() {
        return this.COST;
    }
}

