/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.EnergyShieldTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.tileentity.PassiveAbilityTE;
import slimeattack07.naval_warfare.util.BoardState;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;

public class EnergyShield
implements Ability {
    private final int AMOUNT;
    private final int COST;
    private final String NAME;
    private final String OWNER;
    private final int HP;
    private final int UP;
    private final int DOWN;
    private final int LEFT;
    private final int RIGHT;
    private final boolean ACTIVE;

    public EnergyShield(int amount, int cost, String name, String owner, int hp, int up, int down, int left, int right) {
        this.NAME = name;
        this.OWNER = owner;
        this.HP = hp;
        this.UP = up;
        this.DOWN = down;
        this.LEFT = left;
        this.RIGHT = right;
        this.AMOUNT = amount;
        this.COST = cost;
        this.ACTIVE = true;
    }

    public EnergyShield(String name, String owner, int hp, int up, int down, int left, int right) {
        this.NAME = name;
        this.OWNER = owner;
        this.HP = hp;
        this.UP = up;
        this.DOWN = down;
        this.LEFT = left;
        this.RIGHT = right;
        this.AMOUNT = 1;
        this.COST = 0;
        this.ACTIVE = false;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        Board b;
        GameControllerTE controller;
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (BoardTE te : tiles) {
            BlockEntity etile;
            BlockPos pos = te.m_58899_().m_6630_(4);
            if (!level.m_8055_(pos).m_60734_().equals(NWBlocks.ENERGY_SHIELD.get())) {
                level.m_46597_(pos, ((Block)NWBlocks.ENERGY_SHIELD.get()).m_49966_());
            }
            if ((etile = level.m_7702_(pos)) instanceof EnergyShieldTE) {
                EnergyShieldTE ete = (EnergyShieldTE)etile;
                ete.addOwner(this.OWNER);
                ete.initHP(this.HP);
            }
            if (this.ACTIVE) {
                Board b2 = (Board)te.m_58900_().m_60734_();
                BoardState bstate = b2.getBoardState(te.m_58900_());
                level.m_46597_(te.m_58899_(), (BlockState)te.m_58900_().m_61124_((Property)Board.STATE, (Comparable)((Object)bstate.deselect())));
            }
            ids.add(te.getId());
        }
        if (!ids.isEmpty() && (controller = (b = (Board)board.m_58900_().m_60734_()).getController(level, board.m_58899_())) != null) {
            controller.recordOnRecorders(BattleLogHelper.createSetBlocks(ids, ((Block)NWBlocks.ENERGY_SHIELD.get()).getRegistryName(), 4, false));
        }
    }

    @Override
    public int getAmount() {
        return this.AMOUNT;
    }

    @Override
    public int energyCost() {
        return this.COST;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        if (te == null) {
            return new ArrayList<BoardTE>();
        }
        BlockPos up = te.m_58899_().m_7494_();
        BlockState state = level.m_8055_(up);
        Direction dir = ShipBlock.getFacing(state);
        return te.collectTileArea(this.UP, this.DOWN, this.LEFT, this.RIGHT, dir);
    }

    @Override
    public PassiveType getPassiveType() {
        return this.ACTIVE ? PassiveType.NOT : PassiveType.START_GAME;
    }

    @Override
    public void detachPassive(Level level, BoardTE board) {
        BlockPos pos;
        BlockEntity tile;
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        if (!tiles.isEmpty() && (tile = level.m_7702_(pos = tiles.get(0).m_58899_().m_6630_(4))) instanceof PassiveAbilityTE) {
            PassiveAbilityTE pte = (PassiveAbilityTE)tile;
            Board b = (Board)board.m_58900_().m_60734_();
            pte.destroy(level, pos, this.OWNER, b.getController(level, board.m_58899_()), 4);
        }
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        Object hover = this.ACTIVE ? NWBasicMethods.getTranslation("ability.naval_warfare.energy_cost") + ": " + this.COST + ", " : "";
        hover = (String)hover + NWBasicMethods.getTranslation("misc.naval_warfare.length") + ": " + (this.LEFT + this.RIGHT - 1) + ", ";
        hover = (String)hover + NWBasicMethods.getTranslation("misc.naval_warfare.width") + ": " + (this.UP + this.DOWN - 1) + ", ";
        hover = (String)hover + NWBasicMethods.getTranslation("misc.naval_warfare.health") + ": " + this.HP;
        return NWBasicMethods.hoverableText(name, "gray", (String)hover);
    }

    @Override
    public boolean canBeDisabled() {
        return !this.ACTIVE;
    }

    @Override
    public boolean targetDefensive() {
        return true;
    }

    @Override
    public Item getAnimationItem() {
        return this.ACTIVE ? (Item)NWItems.SHIELD_PLACER.get() : ((Block)NWBlocks.ENERGY_SHIELD.get()).m_5456_();
    }
}

