/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class Flare
implements Ability {
    private final int AMOUNT;
    private final int COST;
    private final int LEFT;
    private final int RIGHT;
    private final int UP;
    private final int DOWN;
    private final String NAME;

    public Flare(int amount, int cost, int left, int right, int up, int down, String name) {
        this.AMOUNT = amount;
        this.COST = cost;
        this.LEFT = left;
        this.RIGHT = right;
        this.UP = up;
        this.DOWN = down;
        this.NAME = name;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        Board b = (Board)board.m_58900_().m_60734_();
        b.selectTiles(level, tiles);
        this.fire(level, player, tiles);
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public int getAmount() {
        return this.AMOUNT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean fire(Level level, Player player, ArrayList<BoardTE> positions) {
        GameControllerTE controller = null;
        GameController control = null;
        boolean hit = false;
        int delay = 20;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (BoardTE te : positions) {
            BoardTE matching;
            if (controller == null) {
                BlockPos pos = te.getController();
                BlockState state = level.m_8055_(pos);
                if (!(state.m_60734_() instanceof GameController)) return false;
                control = (GameController)state.m_60734_();
                if (!control.validateController(level, pos)) return false;
                controller = (GameControllerTE)level.m_7702_(pos);
            }
            if ((matching = control.getOpponentBoardTile(level, controller, te.getId(), false)) == null) continue;
            String p = "dummy";
            if (player != null) {
                p = player.m_20149_();
            }
            ControllerActionHelper cah = ControllerActionHelper.createFlareTarget(matching.m_58899_(), p, matching.m_58899_(), te.m_58899_(), delay, false);
            delay = 0;
            controller.addAction(cah);
            ids.add(te.getId());
            NWBasicMethods.dropBlock(level, te.m_58899_(), (Block)NWBlocks.FLARE.get());
            NWBasicMethods.dropBlock(level, matching.m_58899_(), (Block)NWBlocks.FLARE.get());
        }
        if (ids.isEmpty()) return hit;
        controller.recordOnRecorders(BattleLogHelper.createDropBlocks(ids, true, ((Block)NWBlocks.FLARE.get()).getRegistryName()));
        return hit;
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        BoardTE real_board = te;
        Board board = (Board)real_board.m_58900_().m_60734_();
        Direction dir = board.getControllerFacing(level, real_board.m_58899_());
        return te.collectTileArea(this.UP, this.DOWN, this.LEFT, this.RIGHT, dir);
    }

    @Override
    public Item getAnimationItem() {
        return (Item)NWItems.FLARE.get();
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("ability.naval_warfare.energy_cost") + ": " + this.COST + ", ";
        hover = hover + NWBasicMethods.getTranslation("misc.naval_warfare.length") + ": " + (this.LEFT + this.RIGHT - 1) + ", ";
        hover = hover + NWBasicMethods.getTranslation("misc.naval_warfare.width") + ": " + (this.UP + this.DOWN - 1);
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }

    @Override
    public int energyCost() {
        return this.COST;
    }
}

