/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.init.NWSounds;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.TargetType;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class FragBomb
implements Ability {
    private final int AMOUNT;
    private final int COST;
    private final int FRAG;
    private final String NAME;
    private final Block ANIMATION;
    private final Block FRAG_ANIMATION;

    public FragBomb(int amount, int cost, int frag, String name, Block animation, Block frag_animation) {
        this.AMOUNT = amount;
        this.COST = cost;
        this.FRAG = Math.min(frag, 8);
        this.NAME = name;
        this.ANIMATION = animation;
        this.FRAG_ANIMATION = frag_animation;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        if (tiles.isEmpty()) {
            return;
        }
        BoardTE bte = tiles.get(0);
        Board b = (Board)bte.m_58900_().m_60734_();
        tiles = bte.collectTileArea(2, 2, 2, 2, b.getControllerFacing(level, bte.m_58899_()));
        tiles.remove((Object)bte);
        tiles = bte.selectRandom(this.FRAG, tiles);
        tiles.add(0, bte);
        if (!tiles.isEmpty()) {
            b.selectTiles(level, tiles);
        }
        GameController control = null;
        GameControllerTE controller = null;
        String playername = "dummy";
        TargetType type = TargetType.NORMAL;
        int delay = 20;
        boolean multi_ability = false;
        Block animation = this.ANIMATION;
        for (BoardTE te : tiles) {
            BoardTE matching;
            BlockPos pos = te.getController();
            BlockState state = level.m_8055_(pos);
            if (control == null) {
                control = (GameController)state.m_60734_();
                if (state.m_60734_() instanceof GameController) {
                    if (control.validateController(level, pos)) {
                        controller = (GameControllerTE)level.m_7702_(pos);
                        playername = controller.getOwner();
                    }
                } else {
                    return;
                }
            }
            if ((matching = control.getOpponentBoardTile(level, controller, te.getId(), false)) == null) continue;
            ControllerActionHelper cah = ControllerActionHelper.createFragbombTarget(delay, matching.m_58899_(), playername, matching.m_58899_(), te.m_58899_(), type, animation, multi_ability);
            controller.addAction(cah);
            if (type.equals((Object)TargetType.NORMAL)) {
                level.m_5594_(null, te.m_58899_(), (SoundEvent)NWSounds.SHOT.get(), SoundSource.MASTER, 1.0f, 1.0f);
                level.m_5594_(null, matching.m_58899_(), (SoundEvent)NWSounds.SHOT.get(), SoundSource.MASTER, 1.0f, 1.0f);
                NWBasicMethods.dropBlock(level, te.m_58899_(), animation);
                NWBasicMethods.dropBlock(level, matching.m_58899_(), animation);
                controller.recordOnRecorders(BattleLogHelper.createDropBlock(te.getId(), true, animation.getRegistryName()));
            }
            type = TargetType.UNBLOCKABLE;
            delay = Math.max(0, delay - 10);
            multi_ability = true;
            animation = this.FRAG_ANIMATION;
        }
    }

    @Override
    public int getAmount() {
        return this.AMOUNT;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        ArrayList<BoardTE> tiles = new ArrayList<BoardTE>();
        tiles.add(te);
        return tiles;
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("ability.naval_warfare.energy_cost") + ": " + this.COST + ", ";
        hover = hover + NWBasicMethods.getTranslation("ability.naval_warfare.extra_tiles") + ": " + this.FRAG;
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }

    @Override
    public Item getAnimationItem() {
        return (Item)NWItems.FRAG_BOMB.get();
    }

    @Override
    public int energyCost() {
        return this.COST;
    }
}

