/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.EnergyShieldTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;

public class Guardian
implements Ability {
    private final String NAME;
    private final String OWNER;
    private final int AMOUNT;
    private final int HP;

    public Guardian(String name, String owner, int amount, int hp) {
        this.NAME = name;
        this.OWNER = owner;
        this.HP = hp;
        this.AMOUNT = amount;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        Board b;
        GameControllerTE controller;
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (BoardTE te : tiles) {
            BlockEntity etile;
            ids.add(te.getId());
            BlockPos pos = te.m_58899_().m_6630_(4);
            if (!level.m_8055_(pos).m_60734_().equals(NWBlocks.ENERGY_SHIELD.get())) {
                level.m_46597_(pos, ((Block)NWBlocks.ENERGY_SHIELD.get()).m_49966_());
            }
            if (!((etile = level.m_7702_(pos)) instanceof EnergyShieldTE)) continue;
            EnergyShieldTE ete = (EnergyShieldTE)etile;
            ete.addOwner(this.OWNER);
            ete.initHP(this.HP);
        }
        if (!ids.isEmpty() && (controller = (b = (Board)board.m_58900_().m_60734_()).getController(level, board.m_58899_())) != null) {
            controller.recordOnRecorders(BattleLogHelper.createSetBlocks(ids, ((Block)NWBlocks.ENERGY_SHIELD.get()).getRegistryName(), 4, true));
        }
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        if (te == null) {
            return new ArrayList<BoardTE>();
        }
        ArrayList<BoardTE> tiles = te.selectRandomShip(this.AMOUNT, false, true, true, 2000, 2000);
        ArrayList<BoardTE> shield = new ArrayList<BoardTE>();
        Board board = (Board)te.m_58900_().m_60734_();
        for (BoardTE bte : tiles) {
            Block block = level.m_8055_(bte.m_58899_().m_7494_()).m_60734_();
            if (!(block instanceof ShipBlock)) continue;
            ShipBlock ship = (ShipBlock)block;
            ArrayList<BlockPos> undamaged = ship.collectUndamagedParts(level, bte.m_58899_().m_7494_());
            for (BlockPos bp : undamaged) {
                if (!board.validateBoard(level, bp.m_7495_())) continue;
                shield.add((BoardTE)level.m_7702_(bp.m_7495_()));
            }
        }
        return shield;
    }

    @Override
    public Item getAnimationItem() {
        return (Item)NWItems.GUARDIAN.get();
    }

    @Override
    public PassiveType getPassiveType() {
        return PassiveType.DESTROYED;
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("misc.naval_warfare.amount") + ": " + this.AMOUNT;
        hover = hover + NWBasicMethods.getTranslation("misc.naval_warfare.health") + ": " + this.HP;
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }
}

