/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.config.NavalWarfareConfig;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.init.NWSounds;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.TargetType;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class Heatseaker
implements Ability {
    private TargetType type = (Boolean)NavalWarfareConfig.heatseaker_unblockable.get() != false ? TargetType.UNBLOCKABLE : TargetType.NORMAL;

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        ArrayList<BoardTE> tiles = board.selectRandomShip(1, true, true, false, (Integer)NavalWarfareConfig.heatseaker_length.get(), (Integer)NavalWarfareConfig.heatseaker_length.get());
        if (tiles.isEmpty()) {
            tiles.add(board);
        }
        GameController control = null;
        GameControllerTE controller = null;
        String playername = "dummy";
        for (BoardTE te : tiles) {
            BoardTE matching;
            BlockPos pos = te.getController();
            BlockState state = level.m_8055_(pos);
            if (control == null) {
                control = (GameController)state.m_60734_();
                if (state.m_60734_() instanceof GameController) {
                    if (control.validateController(level, pos)) {
                        controller = (GameControllerTE)level.m_7702_(pos);
                        playername = controller.getOwner();
                    }
                } else {
                    return;
                }
            }
            if ((matching = control.getOpponentBoardTile(level, controller, te.getId(), false)) == null) continue;
            ControllerActionHelper cah = ControllerActionHelper.createTargetAction(20, matching.m_58899_(), playername, matching.m_58899_(), te.m_58899_(), (Integer)NavalWarfareConfig.heatseaker_damage.get(), this.type, false, true, (Block)NWBlocks.HEATSEAKER.get());
            controller.addAction(cah);
            level.m_5594_(null, te.m_58899_(), (SoundEvent)NWSounds.MISSILE.get(), SoundSource.MASTER, 1.0f, 1.0f);
            level.m_5594_(null, matching.m_58899_(), (SoundEvent)NWSounds.MISSILE.get(), SoundSource.MASTER, 1.0f, 1.0f);
            NWBasicMethods.dropBlock(level, te.m_58899_(), (Block)NWBlocks.HEATSEAKER.get());
            NWBasicMethods.dropBlock(level, matching.m_58899_(), (Block)NWBlocks.HEATSEAKER.get());
            controller.recordOnRecorders(BattleLogHelper.createDropBlock(te.getId(), true, ((Block)NWBlocks.HEATSEAKER.get()).getRegistryName()));
        }
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare.heatseaker";
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        Board board = (Board)te.m_58900_().m_60734_();
        double width = (double)((Integer)NavalWarfareConfig.heatseaker_width.get() + 1) / 2.0;
        double length = (double)((Integer)NavalWarfareConfig.heatseaker_length.get() + 1) / 2.0;
        return te.collectTileArea((int)Math.ceil(length), (int)Math.floor(length), (int)Math.ceil(width), (int)Math.floor(width), board.getControllerFacing(level, te.m_58899_()));
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("misc.naval_warfare.length") + ": " + NavalWarfareConfig.heatseaker_length.get() + ", ";
        hover = hover + NWBasicMethods.getTranslation("misc.naval_warfare.width") + ": " + NavalWarfareConfig.heatseaker_width.get() + ", ";
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }

    @Override
    public Item getAnimationItem() {
        return (Item)NWItems.HEATSEAKER.get();
    }
}

