/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class Insight
implements Ability {
    private final String NAME;
    private final Block ANIMATION;
    private final boolean HINT;

    public Insight(String name, Block animation, boolean hint) {
        this.NAME = name;
        this.ANIMATION = animation;
        this.HINT = hint;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        GameController control = null;
        GameControllerTE controller = null;
        String playername = "dummy";
        for (BoardTE te : tiles) {
            BoardTE matching;
            BlockPos pos = te.getController();
            BlockState state = level.m_8055_(pos);
            if (control == null) {
                control = (GameController)state.m_60734_();
                if (state.m_60734_() instanceof GameController) {
                    if (control.validateController(level, pos)) {
                        controller = (GameControllerTE)level.m_7702_(pos);
                        playername = controller.getOwner();
                        BlockPos opp = controller.getOpponent();
                        if (!control.validateController(level, opp)) {
                            return;
                        }
                        controller = (GameControllerTE)level.m_7702_(opp);
                        control = (GameController)controller.m_58900_().m_60734_();
                    }
                } else {
                    return;
                }
            }
            if ((matching = control.getBoardTile(level, controller, te.getId())) == null) continue;
            ControllerActionHelper cah = this.HINT ? ControllerActionHelper.createFlareTarget(matching.m_58899_(), playername, matching.m_58899_(), te.m_58899_(), 20, true) : ControllerActionHelper.createSpyglassTarget(matching.m_58899_(), playername, matching.m_58899_(), te.m_58899_(), 20, true);
            controller.addAction(cah);
            if (this.HINT) continue;
            NWBasicMethods.dropBlock(level, te.m_58899_(), this.ANIMATION);
            NWBasicMethods.dropBlock(level, matching.m_58899_(), this.ANIMATION);
            controller.recordOnRecorders(BattleLogHelper.createDropBlock(te.getId(), false, this.ANIMATION.getRegistryName()));
        }
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        BoardTE bte = te.getOpponentBoardZero();
        if (bte == null) {
            return new ArrayList<BoardTE>();
        }
        return bte.selectRandomShip(1, true, true, true, 2000, 2000);
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        return NWBasicMethods.hoverableText(name, "gray", "");
    }

    @Override
    public Item getAnimationItem() {
        return this.HINT ? (Item)NWItems.MINOR_INSIGHT.get() : (Item)NWItems.MAJOR_INSIGHT.get();
    }

    @Override
    public PassiveType getPassiveType() {
        return PassiveType.DESTROYED;
    }
}

