/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.init.NWSounds;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.TargetType;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class Missile
implements Ability {
    private final int AMOUNT;
    private final int COST;
    private final int DAMAGE;
    private final String NAME;
    private final Block ANIMATION;
    private final boolean PASSIVE;

    public Missile(int damage, String name, Block animation) {
        this.AMOUNT = 1;
        this.COST = 0;
        this.DAMAGE = damage;
        this.NAME = name;
        this.ANIMATION = animation;
        this.PASSIVE = true;
    }

    public Missile(int amount, int cost, int damage, String name, Block animation) {
        this.AMOUNT = amount;
        this.COST = cost;
        this.DAMAGE = damage;
        this.NAME = name;
        this.ANIMATION = animation;
        this.PASSIVE = false;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        GameController control = null;
        GameControllerTE controller = null;
        int delay = 20;
        String playername = "dummy";
        if (!tiles.isEmpty()) {
            Board b = (Board)tiles.get(0).m_58900_().m_60734_();
            b.selectTiles(level, tiles);
        }
        for (BoardTE te : tiles) {
            BoardTE matching;
            BlockPos pos = te.getController();
            BlockState state = level.m_8055_(pos);
            if (control == null) {
                control = (GameController)state.m_60734_();
                if (state.m_60734_() instanceof GameController) {
                    if (control.validateController(level, pos)) {
                        controller = (GameControllerTE)level.m_7702_(pos);
                        playername = controller.getOwner();
                        if (this.PASSIVE) {
                            BlockPos opp = controller.getOpponent();
                            if (!control.validateController(level, opp)) {
                                return;
                            }
                            controller = (GameControllerTE)level.m_7702_(opp);
                            control = (GameController)controller.m_58900_().m_60734_();
                        }
                    }
                } else {
                    return;
                }
            }
            if ((matching = this.PASSIVE ? control.getBoardTile(level, controller, te.getId()) : control.getOpponentBoardTile(level, controller, te.getId(), false)) == null) continue;
            ControllerActionHelper cah = ControllerActionHelper.createTargetAction(delay, matching.m_58899_(), playername, matching.m_58899_(), te.m_58899_(), this.DAMAGE, TargetType.NORMAL, this.PASSIVE, !this.PASSIVE, this.ANIMATION);
            controller.addAction(cah);
            delay = 0;
            level.m_5594_(null, te.m_58899_(), (SoundEvent)NWSounds.MISSILE.get(), SoundSource.MASTER, 1.0f, 1.0f);
            level.m_5594_(null, matching.m_58899_(), (SoundEvent)NWSounds.MISSILE.get(), SoundSource.MASTER, 1.0f, 1.0f);
            NWBasicMethods.dropBlock(level, te.m_58899_(), this.ANIMATION);
            NWBasicMethods.dropBlock(level, matching.m_58899_(), this.ANIMATION);
            controller.recordOnRecorders(BattleLogHelper.createDropBlock(te.getId(), !this.PASSIVE, this.ANIMATION.getRegistryName()));
        }
        if (this.PASSIVE && controller != null) {
            controller.addAction(ControllerActionHelper.createValidate());
        }
    }

    @Override
    public int getAmount() {
        return this.AMOUNT;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        if (this.PASSIVE) {
            BoardTE bte = te.getOpponentBoardZero();
            if (bte == null) {
                return new ArrayList<BoardTE>();
            }
            return bte.selectRandomShip(1, true, true, true, 2000, 2000);
        }
        ArrayList<BoardTE> tiles = new ArrayList<BoardTE>();
        tiles.add(te);
        return tiles;
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        Object hover = !this.PASSIVE ? NWBasicMethods.getTranslation("ability.naval_warfare.energy_cost") + ": " + this.COST + ", " : "";
        hover = (String)hover + NWBasicMethods.getTranslation("misc.naval_warfare.damage") + ": " + this.DAMAGE;
        return NWBasicMethods.hoverableText(name, "gray", (String)hover);
    }

    @Override
    public Item getAnimationItem() {
        return this.PASSIVE ? (Item)NWItems.RETALIATION.get() : (Item)NWItems.MISSILE.get();
    }

    @Override
    public int energyCost() {
        return this.COST;
    }

    @Override
    public PassiveType getPassiveType() {
        return this.PASSIVE ? PassiveType.DESTROYED : PassiveType.NOT;
    }
}

