/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.init.NWSounds;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.TargetType;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class MortarBomber
implements Ability {
    private final int AMOUNT;
    private final int COST;
    private final int DROP;
    private final int LEFT;
    private final int RIGHT;
    private final int UP;
    private final int DOWN;
    private final String NAME;
    private final Block ANIMATION;
    private boolean BOMBER;

    public MortarBomber(int amount, int cost, int drop, int left, int right, int up, int down, String name, Block animation, boolean bomber) {
        this.AMOUNT = amount;
        this.COST = cost;
        this.DROP = drop;
        this.NAME = name;
        this.LEFT = left;
        this.RIGHT = right;
        this.UP = up;
        this.DOWN = down;
        this.ANIMATION = animation;
        this.BOMBER = bomber;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        if (tiles.isEmpty()) {
            return;
        }
        String playername = "dummy";
        int delay = this.BOMBER ? 10 : 20;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        BlockPos pos = tiles.get(0).getController();
        BlockState state = level.m_8055_(pos);
        GameController control = (GameController)state.m_60734_();
        if (!control.validateController(level, pos)) {
            return;
        }
        GameControllerTE controller = (GameControllerTE)level.m_7702_(pos);
        playername = controller.getOwner();
        if (this.BOMBER) {
            BoardTE te = this.findAntiAir(level, controller, tiles);
            if (te != null) {
                tiles.remove((Object)te);
                bte = tiles.get(0);
                tiles = bte.selectRandom(this.DROP - 1, tiles);
                tiles.add(0, te);
            } else {
                bte = tiles.get(0);
                tiles = bte.selectRandom(this.DROP, tiles);
            }
        } else {
            BoardTE bte = tiles.get(0);
            tiles = bte.selectRandom(this.DROP, tiles);
        }
        if (!tiles.isEmpty()) {
            Board b = (Board)tiles.get(0).m_58900_().m_60734_();
            b.selectTiles(level, tiles);
        }
        for (BoardTE te : tiles) {
            BoardTE matching = control.getOpponentBoardTile(level, controller, te.getId(), false);
            if (matching == null) continue;
            ControllerActionHelper cah = this.BOMBER ? ControllerActionHelper.createBomberTarget(delay, matching.m_58899_(), playername, matching.m_58899_(), te.m_58899_(), this.ANIMATION) : ControllerActionHelper.createMultiTarget(delay, matching.m_58899_(), playername, matching.m_58899_(), te.m_58899_(), 1, TargetType.NORMAL, true, false);
            controller.addAction(cah);
            ids.add(te.getId());
            if (this.BOMBER) continue;
            level.m_5594_(null, te.m_58899_(), (SoundEvent)NWSounds.SHOT.get(), SoundSource.MASTER, 1.0f, 0.75f);
            level.m_5594_(null, matching.m_58899_(), (SoundEvent)NWSounds.SHOT.get(), SoundSource.MASTER, 1.0f, 0.75f);
            NWBasicMethods.dropBlock(level, te.m_58899_(), this.ANIMATION);
            NWBasicMethods.dropBlock(level, matching.m_58899_(), this.ANIMATION);
            delay = 0;
        }
        if (!this.BOMBER && !ids.isEmpty()) {
            controller.recordOnRecorders(BattleLogHelper.createSounds(ids, true, (SoundEvent)NWSounds.SHOT.get(), 1.0f, 0.75f));
            controller.recordOnRecorders(BattleLogHelper.createDropBlocks(ids, true, this.ANIMATION.getRegistryName()));
        }
    }

    @Override
    public int getAmount() {
        return this.AMOUNT;
    }

    @Nullable
    public BoardTE findAntiAir(Level level, GameControllerTE controller, ArrayList<BoardTE> tiles) {
        GameController control = (GameController)controller.m_58900_().m_60734_();
        for (int i = 0; i < tiles.size(); ++i) {
            BoardTE te = tiles.get(i);
            BoardTE matching = control.getOpponentBoardTile(level, controller, te.getId(), false);
            if (!level.m_8055_(matching.m_58899_().m_6630_(5)).m_60734_().equals(NWBlocks.ANTI_AIR.get())) continue;
            return te;
        }
        return null;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        Board board = (Board)te.m_58900_().m_60734_();
        return te.collectTileArea(this.UP, this.DOWN, this.LEFT, this.RIGHT, board.getControllerFacing(level, te.m_58899_()));
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("ability.naval_warfare.energy_cost") + ": " + this.COST + ", ";
        hover = hover + NWBasicMethods.getTranslation("misc.naval_warfare.length") + ": " + (this.LEFT + this.RIGHT - 1) + ", ";
        hover = hover + NWBasicMethods.getTranslation("misc.naval_warfare.width") + ": " + (this.UP + this.DOWN - 1) + ", ";
        hover = hover + NWBasicMethods.getTranslation("ability.naval_warfare.tiles_targeted") + ": " + this.DROP;
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }

    @Override
    public Item getAnimationItem() {
        return this.BOMBER ? (Item)NWItems.BOMBER.get() : (Item)NWItems.MORTAR.get();
    }

    @Override
    public int energyCost() {
        return this.COST;
    }
}

