/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import slimeattack07.naval_warfare.config.NavalWarfareConfig;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.BoardState;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Deployable;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class Raft
extends Deployable {
    public Raft(ShipBlock ship) {
        super(1, 0, "crude_raft", NWItems.RAFT, ship);
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        if (tiles.isEmpty()) {
            return;
        }
        BoardTE te = tiles.get(0);
        BlockPos pos = te.m_58899_().m_7494_();
        ArrayList dirs = Lists.newArrayList((Object[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST});
        Collections.shuffle(dirs);
        boolean success = false;
        for (Direction dir : dirs) {
            success = this.SHIP.summonShip(level, pos, (BlockState)this.SHIP.m_49966_().m_61124_((Property)ShipBlock.FACING, (Comparable)dir), true, false);
            if (!success) continue;
            Board b = (Board)te.m_58900_().m_60734_();
            GameControllerTE gc = b.getController(level, te.m_58899_());
            if (gc == null) break;
            String p = player == null ? "dummy" : player.m_20149_();
            GameController controller = (GameController)gc.m_58900_().m_60734_();
            BoardTE ote = controller.getOpponentBoardTile(level, gc, te.getId(), true);
            gc.recordOnRecorders(BattleLogHelper.createDeployable(board.getId(), this.SHIP.getRegistryName(), dir));
            if (ote != null) {
                gc.addHP(1);
                gc.addTurnAction(ControllerActionHelper.createRaft(te.m_58899_(), p, te.m_58899_(), ote.m_58899_(), (Integer)NavalWarfareConfig.raft_timeout.get() - 1));
                break;
            }
            NWBasicMethods.messagePlayer(player, "message.naval_warfare.failed_deploy_raft");
            break;
        }
        if (!success) {
            NWBasicMethods.messagePlayer(player, "message.naval_warfare.failed_deploy_spell");
        }
        Board b = (Board)te.m_58900_().m_60734_();
        BoardState bstate = b.getBoardState(te.m_58900_());
        level.m_46597_(te.m_58899_(), (BlockState)te.m_58900_().m_61124_((Property)Board.STATE, (Comparable)((Object)bstate.deselect())));
    }
}

