/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.init.NWSounds;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.TargetType;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class Salvo
implements Ability {
    private final int AMOUNT;
    private final int COST;
    private final int LEFT;
    private final int RIGHT;
    private final String NAME;
    private final boolean SHELLS;

    public Salvo(int amount, int cost, int left, int right, boolean shells, String name) {
        this.AMOUNT = amount;
        this.COST = cost;
        this.LEFT = left;
        this.RIGHT = right;
        this.SHELLS = shells;
        this.NAME = name;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        Board b = (Board)board.m_58900_().m_60734_();
        b.selectTiles(level, tiles);
        this.fire(level, player, tiles);
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public int getAmount() {
        return this.AMOUNT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fire(Level level, Player player, ArrayList<BoardTE> positions) {
        GameControllerTE controller = null;
        GameController control = null;
        int delay = 20;
        Block block = this.SHELLS ? (Block)NWBlocks.SHELL.get() : (Block)NWBlocks.CANNONBALL.get();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (BoardTE te : positions) {
            BoardTE matching;
            if (controller == null) {
                BlockPos pos = te.getController();
                BlockState state = level.m_8055_(pos);
                if (!(state.m_60734_() instanceof GameController)) return;
                control = (GameController)state.m_60734_();
                if (!control.validateController(level, pos)) return;
                controller = (GameControllerTE)level.m_7702_(pos);
            }
            if ((matching = control.getOpponentBoardTile(level, controller, te.getId(), false)) == null) continue;
            String p = "dummy";
            if (player != null) {
                p = player.m_20149_();
            }
            ControllerActionHelper cah = ControllerActionHelper.createMultiTarget(delay, matching.m_58899_(), p, matching.m_58899_(), te.m_58899_(), 1, TargetType.NORMAL, true, false);
            delay = 0;
            ids.add(te.getId());
            controller.addAction(cah);
            level.m_5594_(null, te.m_58899_(), (SoundEvent)NWSounds.SHOT.get(), SoundSource.MASTER, 1.0f, 1.25f);
            level.m_5594_(null, matching.m_58899_(), (SoundEvent)NWSounds.SHOT.get(), SoundSource.MASTER, 1.0f, 1.25f);
            NWBasicMethods.dropBlock(level, te.m_58899_(), block);
            NWBasicMethods.dropBlock(level, matching.m_58899_(), block);
        }
        if (ids.isEmpty()) return;
        controller.recordOnRecorders(BattleLogHelper.createSounds(ids, true, (SoundEvent)NWSounds.SHOT.get(), 1.0f, 1.25f));
        controller.recordOnRecorders(BattleLogHelper.createDropBlocks(ids, true, block.getRegistryName()));
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        Board board = (Board)te.m_58900_().m_60734_();
        Direction dir = board.getControllerFacing(level, te.m_58899_());
        return te.collectTileArea(1, 0, this.LEFT, this.RIGHT, dir);
    }

    @Override
    public Item getAnimationItem() {
        return (Item)NWItems.SALVO.get();
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("ability.naval_warfare.energy_cost") + ": " + this.COST + ", ";
        hover = hover + NWBasicMethods.getTranslation("misc.naval_warfare.length") + ": " + (this.LEFT + this.RIGHT - 1);
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }

    @Override
    public int energyCost() {
        return this.COST;
    }
}

