/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.config.NavalWarfareConfig;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.init.NWSounds;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class Sonar
implements Ability {
    @Override
    public void activate(Level level, Player player, BoardTE board) {
        ArrayList<BoardTE> tiles = this.findDeployables(level, board);
        GameController control = null;
        GameControllerTE controller = null;
        String playername = "dummy";
        int delay = 20;
        for (BoardTE te : tiles) {
            BoardTE matching;
            BlockPos pos = te.getController();
            BlockState state = level.m_8055_(pos);
            if (control == null) {
                control = (GameController)state.m_60734_();
                if (state.m_60734_() instanceof GameController) {
                    if (control.validateController(level, pos)) {
                        controller = (GameControllerTE)level.m_7702_(pos);
                        playername = controller.getOwner();
                    }
                } else {
                    return;
                }
            }
            if ((matching = control.getOpponentBoardTile(level, controller, te.getId(), false)) == null) continue;
            ControllerActionHelper cah = ControllerActionHelper.createSpyglassTarget(matching.m_58899_(), playername, matching.m_58899_(), te.m_58899_(), delay, false);
            level.m_5594_(null, te.m_58899_(), (SoundEvent)NWSounds.SONAR.get(), SoundSource.MASTER, 1.0f, 1.25f);
            level.m_5594_(null, matching.m_58899_(), (SoundEvent)NWSounds.SONAR.get(), SoundSource.MASTER, 1.0f, 1.25f);
            controller.recordOnRecorders(BattleLogHelper.createSound(te.getId(), true, (SoundEvent)NWSounds.SONAR.get(), 1.0f, 1.25f));
            controller.addAction(cah);
            delay = 0;
        }
    }

    private ArrayList<BoardTE> findDeployables(Level level, BoardTE te) {
        Board board = (Board)te.m_58900_().m_60734_();
        ArrayList<BoardTE> matching = new ArrayList<BoardTE>();
        for (BoardTE bte : board.matchTiles(level, this.getTiles(level, te), false)) {
            ShipBlock ship;
            BlockState state = level.m_8055_(bte.m_58899_().m_7494_());
            if (!(state.m_60734_() instanceof ShipBlock) || (ship = (ShipBlock)state.m_60734_()).losesHP()) continue;
            matching.add(bte);
        }
        ArrayList<BoardTE> targets = board.matchTiles(level, matching, true);
        if (targets.size() == matching.size()) {
            return targets;
        }
        return new ArrayList<BoardTE>();
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare.sonar";
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        Board board = (Board)te.m_58900_().m_60734_();
        double width = (double)((Integer)NavalWarfareConfig.sonar_width.get() + 1) / 2.0;
        double length = (double)((Integer)NavalWarfareConfig.sonar_length.get() + 1) / 2.0;
        return te.collectTileArea((int)Math.ceil(length), (int)Math.floor(length), (int)Math.ceil(width), (int)Math.floor(width), board.getControllerFacing(level, te.m_58899_()));
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("misc.naval_warfare.length") + ": " + NavalWarfareConfig.sonar_length.get() + ", ";
        hover = hover + NWBasicMethods.getTranslation("misc.naval_warfare.width") + ": " + NavalWarfareConfig.sonar_width.get() + ", ";
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }

    @Override
    public Item getAnimationItem() {
        return (Item)NWItems.SONAR.get();
    }
}

