/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class Torpedo
implements Ability {
    private final int AMOUNT;
    private final int COST;
    private final int RANGE;
    private final int DAMAGE;
    private final int HEALTH;
    private final String NAME;
    private final int MAX_SEARCH = 500;
    private final Block ANIMATION;

    public Torpedo(int amount, int cost, int range, int damage, int health, String name, Block animation) {
        this.AMOUNT = amount;
        this.COST = cost;
        this.RANGE = range;
        this.DAMAGE = damage;
        this.HEALTH = health;
        this.NAME = name;
        this.ANIMATION = animation;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        Board b = (Board)board.m_58900_().m_60734_();
        b.selectTiles(level, tiles);
        this.fire(level, player, tiles);
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public int getAmount() {
        return this.AMOUNT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fire(Level level, Player player, ArrayList<BoardTE> positions) {
        GameControllerTE controller = null;
        GameController control = null;
        for (BoardTE te : positions) {
            BoardTE matching;
            if (controller == null) {
                BlockPos pos = te.getController();
                BlockState state = level.m_8055_(pos);
                if (!(state.m_60734_() instanceof GameController)) return;
                control = (GameController)state.m_60734_();
                if (!control.validateController(level, pos)) return;
                controller = (GameControllerTE)level.m_7702_(pos);
            }
            if ((matching = control.getOpponentBoardTile(level, controller, te.getId(), false)) == null) continue;
            String p = "dummy";
            if (player != null) {
                p = player.m_20149_();
            }
            ControllerActionHelper cah = ControllerActionHelper.createTorpedoTarget(matching.m_58899_(), p, matching.m_58899_(), te.m_58899_(), this.DAMAGE, this.HEALTH, this.ANIMATION);
            controller.addAction(cah);
        }
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        BoardTE real_board = te;
        Board board = (Board)real_board.m_58900_().m_60734_();
        Direction dir = board.getControllerFacing(level, real_board.m_58899_());
        for (int search = 0; search < 500; ++search) {
            BlockPos pos = real_board.m_58899_().m_142300_(dir.m_122424_());
            Block block = level.m_8055_(pos).m_60734_();
            if (block instanceof Board && board.validateBoard(level, pos)) {
                real_board = (BoardTE)level.m_7702_(pos);
                board = (Board)real_board.m_58900_().m_60734_();
                continue;
            }
            return real_board.collectTiles(this.RANGE, dir);
        }
        return te.collectTiles(this.RANGE, dir);
    }

    @Override
    public Item getAnimationItem() {
        return (Item)NWItems.TORPEDO.get();
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("ability.naval_warfare.energy_cost") + ": " + this.COST + ", ";
        hover = hover + NWBasicMethods.getTranslation("misc.naval_warfare.range") + ": " + this.RANGE + ", ";
        hover = hover + NWBasicMethods.getTranslation("misc.naval_warfare.damage") + ": " + this.DAMAGE + ", ";
        hover = hover + NWBasicMethods.getTranslation("misc.naval_warfare.health") + ": " + this.HEALTH;
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }

    @Override
    public int energyCost() {
        return this.COST;
    }
}

