/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.tileentity.PassiveAbilityTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;

public class TorpedoNet
implements Ability {
    private final String NAME;
    private final String OWNER;
    private final int LENGTH;
    private final int MAX_SEARCH = 500;
    private final PassiveType TYPE;

    public TorpedoNet(String name, String owner, int length, boolean deployable) {
        this.NAME = name;
        this.OWNER = owner;
        this.LENGTH = length;
        this.TYPE = deployable ? PassiveType.DEPLOYED : PassiveType.START_GAME;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        Board b;
        GameControllerTE controller;
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (BoardTE te : tiles) {
            BlockPos pos = te.m_58899_().m_6630_(3);
            level.m_46597_(pos, ((Block)NWBlocks.TORPEDO_NET.get()).m_49966_());
            BlockEntity ptile = level.m_7702_(pos);
            if (ptile instanceof PassiveAbilityTE) {
                PassiveAbilityTE pte = (PassiveAbilityTE)ptile;
                pte.addOwner(this.OWNER);
            }
            ids.add(te.getId());
        }
        if (!ids.isEmpty() && (controller = (b = (Board)board.m_58900_().m_60734_()).getController(level, board.m_58899_())) != null) {
            controller.recordOnRecorders(BattleLogHelper.createSetBlocks(ids, ((Block)NWBlocks.TORPEDO_NET.get()).getRegistryName(), 3, false));
        }
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        if (te == null) {
            return new ArrayList<BoardTE>();
        }
        BoardTE real_board = te;
        Board board = (Board)real_board.m_58900_().m_60734_();
        Direction dir = board.getControllerFacing(level, real_board.m_58899_());
        if (this.TYPE.equals((Object)PassiveType.DEPLOYED)) {
            ArrayList<BoardTE> tiles_a = real_board.collectTiles(this.LENGTH, dir.m_122427_());
            ArrayList<BoardTE> tiles_b = real_board.collectTiles(this.LENGTH, dir.m_122428_());
            if (!tiles_b.isEmpty()) {
                tiles_b.remove(0);
            }
            tiles_a.addAll(tiles_b);
            return tiles_a;
        }
        for (int search = 0; search < 500; ++search) {
            BlockPos pos = real_board.m_58899_().m_142300_(dir.m_122424_());
            Block block = level.m_8055_(pos).m_60734_();
            if (block instanceof Board && board.validateBoard(level, pos)) {
                real_board = (BoardTE)level.m_7702_(pos);
                board = (Board)real_board.m_58900_().m_60734_();
                continue;
            }
            ArrayList<BoardTE> tiles_a = real_board.collectTiles(this.LENGTH, dir.m_122427_());
            ArrayList<BoardTE> tiles_b = real_board.collectTiles(this.LENGTH, dir.m_122428_());
            if (!tiles_b.isEmpty()) {
                tiles_b.remove(0);
            }
            tiles_a.addAll(tiles_b);
            return tiles_a;
        }
        return new ArrayList<BoardTE>();
    }

    @Override
    public PassiveType getPassiveType() {
        return this.TYPE;
    }

    @Override
    public void detachPassive(Level level, BoardTE board) {
        BlockPos pos;
        BlockEntity tile;
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        if (!tiles.isEmpty() && (tile = level.m_7702_(pos = tiles.get(0).m_58899_().m_6630_(3))) instanceof PassiveAbilityTE) {
            PassiveAbilityTE pte = (PassiveAbilityTE)tile;
            Board b = (Board)board.m_58900_().m_60734_();
            pte.destroy(level, pos, this.OWNER, b.getController(level, board.m_58899_()), 3);
        }
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("misc.naval_warfare.range") + ": " + (2 * this.LENGTH - 1);
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }
}

