/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.abilities;

import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.TargetType;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;

public class Whirlpool
implements Ability {
    private final String NAME;
    private final int AMOUNT;
    private final Block ANIMATION;

    public Whirlpool(String name, int amount, Block animation) {
        this.NAME = name;
        this.AMOUNT = amount;
        this.ANIMATION = animation;
    }

    @Override
    public void activate(Level level, Player player, BoardTE board) {
        GameControllerTE controller = null;
        GameController control = null;
        ArrayList<BoardTE> tiles = this.getTiles(level, board);
        int delay = 20;
        String playername = "dummy";
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (!tiles.isEmpty()) {
            Board b = (Board)tiles.get(0).m_58900_().m_60734_();
            b.selectTiles(level, tiles);
        }
        for (BoardTE te : tiles) {
            BoardTE matching;
            if (controller == null) {
                BlockPos opp;
                Board b = (Board)te.m_58900_().m_60734_();
                controller = b.getController(level, te.m_58899_());
                if (controller == null) {
                    return;
                }
                playername = controller.getOwner();
                control = (GameController)controller.m_58900_().m_60734_();
                if (!control.validateController(level, opp = controller.getOpponent())) {
                    return;
                }
                controller = (GameControllerTE)level.m_7702_(opp);
                control = (GameController)controller.m_58900_().m_60734_();
            }
            if ((matching = control.getBoardTile(level, controller, te.getId())) == null) continue;
            ControllerActionHelper cah = ControllerActionHelper.createMultiTarget(delay, matching.m_58899_(), playername, matching.m_58899_(), te.m_58899_(), 1, TargetType.REVEAL, false, true);
            controller.addAction(cah);
            delay = 0;
            ids.add(te.getId());
            NWBasicMethods.dropBlock(level, te.m_58899_(), this.ANIMATION);
            NWBasicMethods.dropBlock(level, matching.m_58899_(), this.ANIMATION);
        }
        if (!ids.isEmpty()) {
            controller.recordOnRecorders(BattleLogHelper.createDropBlocks(ids, false, this.ANIMATION.getRegistryName()));
        }
        controller.addAction(ControllerActionHelper.createValidate());
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public String getTranslation() {
        return "abilities.naval_warfare." + this.NAME;
    }

    @Override
    public ArrayList<BoardTE> getTiles(Level level, BoardTE te) {
        BoardTE bte = te.getOpponentBoardZero();
        if (bte == null) {
            return new ArrayList<BoardTE>();
        }
        return bte.selectRandomTiles(this.AMOUNT, true, true);
    }

    @Override
    public PassiveType getPassiveType() {
        return PassiveType.DESTROYED;
    }

    @Override
    public MutableComponent hoverableInfo() {
        String name = ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.getTranslation()) + ChatFormatting.WHITE;
        String hover = NWBasicMethods.getTranslation("misc.naval_warfare.amount") + ": " + this.AMOUNT;
        return NWBasicMethods.hoverableText(name, "gray", hover);
    }

    @Override
    public Item getAnimationItem() {
        return (Item)NWItems.WHIRLPOOL.get();
    }
}

