/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.util.helpers;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import slimeattack07.naval_warfare.NavalWarfare;
import slimeattack07.naval_warfare.tileentity.BattleRecorderTE;
import slimeattack07.naval_warfare.tileentity.BattleViewerTE;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.DisappearingTE;
import slimeattack07.naval_warfare.tileentity.EnergyShieldTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.tileentity.PassiveAbilityTE;
import slimeattack07.naval_warfare.tileentity.RandomShipTE;
import slimeattack07.naval_warfare.tileentity.ShipTE;
import slimeattack07.naval_warfare.util.BattleLogAction;
import slimeattack07.naval_warfare.util.BoardState;
import slimeattack07.naval_warfare.util.ControllerAction;
import slimeattack07.naval_warfare.util.HitResult;
import slimeattack07.naval_warfare.util.ShipState;
import slimeattack07.naval_warfare.util.Spell;
import slimeattack07.naval_warfare.util.TargetType;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;
import slimeattack07.naval_warfare.util.helpers.ShipSaveHelper;
import slimeattack07.naval_warfare.util.helpers.TargetResultHelper;

public class NBTHelper {
    public static CompoundTag toNBT(Object o) {
        if (o instanceof ItemStack) {
            return NBTHelper.writeItemStack((ItemStack)o);
        }
        if (o instanceof GameControllerTE) {
            return NBTHelper.writeGameController((GameControllerTE)((Object)o));
        }
        if (o instanceof BoardTE) {
            return NBTHelper.writeBoard((BoardTE)((Object)o));
        }
        if (o instanceof ShipTE) {
            return NBTHelper.writeShip((ShipTE)((Object)o));
        }
        if (o instanceof EnergyShieldTE) {
            return NBTHelper.writeShield((EnergyShieldTE)((Object)o));
        }
        if (o instanceof PassiveAbilityTE) {
            return NBTHelper.writePassive((PassiveAbilityTE)((Object)o));
        }
        if (o instanceof DisappearingTE) {
            return NBTHelper.writeDisappear((DisappearingTE)((Object)o));
        }
        if (o instanceof ControllerActionHelper) {
            return NBTHelper.writeCAH((ControllerActionHelper)o);
        }
        if (o instanceof RandomShipTE) {
            return NBTHelper.writeRandomShip((RandomShipTE)((Object)o));
        }
        if (o instanceof BattleRecorderTE) {
            return NBTHelper.writeBattleRecorder((BattleRecorderTE)((Object)o));
        }
        if (o instanceof BattleLogHelper) {
            return NBTHelper.writeBLH((BattleLogHelper)o);
        }
        if (o instanceof BattleViewerTE) {
            return NBTHelper.writeBattleViewer((BattleViewerTE)((Object)o));
        }
        return null;
    }

    private static CompoundTag writeGameController(GameControllerTE o) {
        ArrayList<String> arrayList;
        ArrayList<String> registered;
        ArrayList<TargetResultHelper> results;
        ListTag list;
        CompoundTag compound = new CompoundTag();
        compound = NBTHelper.safePutString("owner", o.owner, compound);
        compound.m_128365_("zero", (Tag)NBTHelper.writeBlockPos(o.zero));
        compound = NBTHelper.safePutBoolean("playing_game", o.playing_game, compound);
        compound = NBTHelper.safePutBoolean("clear_board", o.clear_board, compound);
        compound.m_128365_("opponent", (Tag)NBTHelper.writeBlockPos(o.opponent));
        compound.m_128365_("opponent_zero", (Tag)NBTHelper.writeBlockPos(o.opponent_zero));
        compound = NBTHelper.safePutBoolean("has_turn", o.has_turn, compound);
        compound = NBTHelper.safePutInt("turn_time", o.turn_time, compound);
        compound = NBTHelper.safePutInt("hp", o.hp, compound);
        compound = NBTHelper.safePutInt("board_size", o.board_size, compound);
        compound = NBTHelper.safePutString("name", o.config_name, compound);
        compound = NBTHelper.safePutInt("action_time", o.action_time, compound);
        compound = NBTHelper.safePutInt("action_number", o.action_number, compound);
        compound = NBTHelper.safePutInt("energy", o.energy, compound);
        compound = NBTHelper.safePutBoolean("do_turn_actions", o.do_turn_actions, compound);
        compound = NBTHelper.safePutInt("turn_action_amount", o.turn_action_amount, compound);
        compound = NBTHelper.safePutBoolean("has_spell", o.has_spell, compound);
        compound = NBTHelper.safePutInt("cons_timeout_times", o.cons_timeout_times, compound);
        compound = NBTHelper.safePutInt("timeout_times", o.timeout_times, compound);
        compound = NBTHelper.safePutInt("reg_buffer_time", o.reg_buffer_time, compound);
        compound = NBTHelper.safePutBoolean("hit_once", o.hit_once, compound);
        compound = NBTHelper.safePutInt("streak", o.streak, compound);
        ArrayList<ControllerActionHelper> actions = o.getActions();
        if (actions != null) {
            list = new ListTag();
            for (ControllerActionHelper controllerActionHelper : actions) {
                list.add((Object)NBTHelper.writeCAH(controllerActionHelper));
            }
            compound.m_128365_("actions", (Tag)list);
        }
        if ((actions = o.getTurnActions()) != null) {
            list = new ListTag();
            for (ControllerActionHelper controllerActionHelper : actions) {
                list.add((Object)NBTHelper.writeCAH(controllerActionHelper));
            }
            compound.m_128365_("turn_actions", (Tag)list);
        }
        if ((results = o.getResults()) != null) {
            ListTag list2 = new ListTag();
            for (TargetResultHelper targetResultHelper : results) {
                list2.add((Object)NBTHelper.writeTRH(targetResultHelper));
            }
            compound.m_128365_("results", (Tag)list2);
        }
        if ((registered = o.getRegistered()) != null) {
            ListTag listTag = new ListTag();
            for (String s : registered) {
                CompoundTag cnbt = new CompoundTag();
                cnbt = NBTHelper.safePutString("ship", s, cnbt);
                listTag.add((Object)cnbt);
            }
            compound.m_128365_("registered", (Tag)listTag);
        }
        if ((arrayList = o.getRegisterBuffer()) != null) {
            ListTag listTag = new ListTag();
            for (String s : arrayList) {
                CompoundTag cnbt = new CompoundTag();
                cnbt = NBTHelper.safePutString("ship", s, cnbt);
                listTag.add((Object)cnbt);
            }
            compound.m_128365_("register_buffer", (Tag)listTag);
        }
        return compound;
    }

    private static CompoundTag writeBoard(BoardTE o) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("controller", (Tag)NBTHelper.writeBlockPos(o.controller));
        compound = NBTHelper.safePutInt("board_id", o.board_id, compound);
        return compound;
    }

    private static CompoundTag writeShip(ShipTE o) {
        CompoundTag compound = new CompoundTag();
        compound = NBTHelper.safePutInt("active_amount", o.getActiveAmount(), compound);
        compound = NBTHelper.safePutInt("passive_amount", o.getPassiveAmount(), compound);
        compound = NBTHelper.safePutInt("action_number", o.getActionNumber(), compound);
        compound.m_128365_("next", (Tag)NBTHelper.writeBlockPos(o.getNext()));
        return compound;
    }

    private static CompoundTag writeShield(EnergyShieldTE o) {
        CompoundTag compound = NBTHelper.writePassive(o);
        compound = NBTHelper.safePutInt("hp", o.getHP(), compound);
        compound = NBTHelper.safePutInt("last_action", o.getLastAction(), compound);
        return compound;
    }

    private static CompoundTag writePassive(PassiveAbilityTE o) {
        CompoundTag compound = new CompoundTag();
        ListTag list = new ListTag();
        for (String owner : o.getOwners()) {
            CompoundTag nbt = new CompoundTag();
            nbt = NBTHelper.safePutString("owner", owner, nbt);
            list.add((Object)nbt);
        }
        compound.m_128365_("owners", (Tag)list);
        if (o.hasMatching()) {
            compound.m_128365_("matching", (Tag)NBTHelper.writeBlockPos(o.getMatching()));
        }
        return compound;
    }

    private static CompoundTag writeDisappear(DisappearingTE o) {
        CompoundTag compound = new CompoundTag();
        compound = NBTHelper.safePutInt("time", o.time, compound);
        return compound;
    }

    private static CompoundTag writeRandomShip(RandomShipTE o) {
        CompoundTag compound = new CompoundTag();
        compound = NBTHelper.safePutBoolean("can_spawn", o.can_spawn, compound);
        return compound;
    }

    private static CompoundTag writeItemStack(ItemStack stack) {
        CompoundTag compound = new CompoundTag();
        if (stack == ItemStack.f_41583_) {
            compound.m_128359_("iamempty", "");
            compound.m_128344_("type", (byte)0);
            return compound;
        }
        compound = NBTHelper.safePutInt("count", stack.m_41613_(), compound);
        compound = NBTHelper.safePutString("item", stack.m_41720_().getRegistryName().toString(), "minecraft:air", compound);
        compound.m_128344_("type", (byte)0);
        if (stack.m_41782_()) {
            compound.m_128365_("nbt", (Tag)stack.m_41783_());
        }
        return compound;
    }

    public static CompoundTag writeBlockPos(BlockPos pos) {
        CompoundTag compound = new CompoundTag();
        if (pos == null) {
            compound.m_128359_("no_pos", "");
            return compound;
        }
        compound = NBTHelper.safePutInt("x", pos.m_123341_(), compound);
        compound = NBTHelper.safePutInt("y", pos.m_123342_(), compound);
        compound = NBTHelper.safePutInt("z", pos.m_123343_(), compound);
        return compound;
    }

    private static CompoundTag writeTRH(TargetResultHelper helper) {
        CompoundTag compound = new CompoundTag();
        compound = NBTHelper.safePutInt("id", helper.id, compound);
        compound = NBTHelper.safePutString("result", helper.result.toString().toUpperCase(), compound);
        return compound;
    }

    private static CompoundTag writeCAH(ControllerActionHelper helper) {
        CompoundTag compound = new CompoundTag();
        if (helper == null || helper.action == null) {
            NavalWarfare.LOGGER.warn("Encountered corrupt CAH, skipping. CAH or CAH.action == null");
            return compound;
        }
        if (helper.board_te != null) {
            compound.m_128365_("board_te", (Tag)NBTHelper.writeBlockPos(helper.board_te));
        }
        if (helper.matching != null) {
            compound.m_128365_("matching", (Tag)NBTHelper.writeBlockPos(helper.matching));
        }
        if (helper.pos != null) {
            compound.m_128365_("pos", (Tag)NBTHelper.writeBlockPos(helper.pos));
        }
        compound = helper.delay > 0 ? NBTHelper.safePutInt("delay", helper.delay, compound) : compound;
        compound = NBTHelper.safePutString("action", helper.action.name().toUpperCase(), compound);
        compound = helper.damage > 0 ? NBTHelper.safePutInt("damage", helper.damage, compound) : compound;
        compound = helper.player == null ? compound : NBTHelper.safePutString("player", helper.player.toString(), compound);
        compound = helper.opponent == null ? compound : NBTHelper.safePutString("player", helper.opponent.toString(), compound);
        compound = helper.target_type == null ? compound : NBTHelper.safePutString("target_type", helper.target_type.toString(), compound);
        compound = helper.health > 0 || helper.health == -1 ? NBTHelper.safePutInt("health", helper.health, compound) : compound;
        compound = helper.animation == null ? compound : NBTHelper.safePutString("animation", helper.animation.getRegistryName().toString(), compound);
        compound = helper.multi_ability ? NBTHelper.safePutBoolean("multi_ability", true, compound) : compound;
        compound = helper.item == null ? compound : NBTHelper.safePutString("item", helper.item.getRegistryName().toString(), compound);
        compound = helper.hover == null ? compound : NBTHelper.safePutString("hover", helper.hover, compound);
        compound = helper.translation == null ? compound : NBTHelper.safePutString("translation", helper.translation, compound);
        compound = helper.triggers_passives ? NBTHelper.safePutBoolean("triggers_passives", true, compound) : compound;
        compound = helper.spell == null ? compound : NBTHelper.safePutString("spell", helper.spell.toString(), compound);
        return compound;
    }

    private static CompoundTag writeBattleRecorder(BattleRecorderTE o) {
        ListTag list;
        ArrayList<ShipSaveHelper> ships;
        CompoundTag compound = new CompoundTag();
        compound = NBTHelper.safePutInt("own_size", o.own_size, compound);
        compound = NBTHelper.safePutInt("opp_size", o.opp_size, compound);
        compound = NBTHelper.safePutString("own_dir", o.own_dir.name(), compound);
        compound = NBTHelper.safePutString("opp_dir", o.opp_dir.name(), compound);
        ArrayList<BattleLogHelper> actions = o.getActions();
        if (actions != null) {
            ListTag list2 = new ListTag();
            for (BattleLogHelper blh : actions) {
                list2.add((Object)NBTHelper.writeBLH(blh));
            }
            compound.m_128365_("actions", (Tag)list2);
        }
        if ((ships = o.getOwnShips()) != null) {
            list = new ListTag();
            for (ShipSaveHelper ssh : ships) {
                list.add((Object)NBTHelper.writeSSH(ssh));
            }
            compound.m_128365_("own_ships", (Tag)list);
        }
        if ((ships = o.getOppShips()) != null) {
            list = new ListTag();
            for (ShipSaveHelper ssh : ships) {
                list.add((Object)NBTHelper.writeSSH(ssh));
            }
            compound.m_128365_("opp_ships", (Tag)list);
        }
        return compound;
    }

    private static CompoundTag writeBattleViewer(BattleViewerTE o) {
        CompoundTag compound = new CompoundTag();
        compound = NBTHelper.safePutBoolean("playing", o.playing, compound);
        compound = NBTHelper.safePutInt("timer", o.timer, compound);
        compound.m_128365_("zero", (Tag)NBTHelper.writeBlockPos(o.zero));
        compound.m_128365_("opponent_zero", (Tag)NBTHelper.writeBlockPos(o.opponent_zero));
        compound = NBTHelper.safePutFloat("speed", o.speed, compound);
        compound = NBTHelper.safePutString("uuid", o.uuid.toString(), compound);
        ArrayList<BattleLogHelper> actions = o.getActions();
        if (actions != null) {
            ListTag list = new ListTag();
            for (BattleLogHelper blh : actions) {
                list.add((Object)NBTHelper.writeBLH(blh));
            }
            compound.m_128365_("actions", (Tag)list);
        }
        return compound;
    }

    private static CompoundTag writeBLH(BattleLogHelper helper) {
        CompoundTag compound = new CompoundTag();
        if (helper == null || helper.action == null) {
            NavalWarfare.LOGGER.warn("Encountered corrupt BLH, skipping. BLH = " + helper);
            return compound;
        }
        compound = NBTHelper.safePutString("action", helper.action.name(), compound);
        compound = helper.id > 0 ? NBTHelper.safePutInt("id", helper.id, compound) : compound;
        compound = NBTHelper.safePutBoolean("opponent", helper.opponent, compound);
        compound = helper.board_state == null ? compound : NBTHelper.safePutString("board_state", helper.board_state.name(), compound);
        compound = helper.resource == null ? compound : NBTHelper.safePutString("resource", helper.resource.toString(), compound);
        compound = helper.delay > 0 ? NBTHelper.safePutInt("delay", helper.delay, compound) : compound;
        compound = helper.ship_state == null ? compound : NBTHelper.safePutString("ship_state", helper.ship_state.name(), compound);
        compound = helper.sound == null ? compound : NBTHelper.safePutString("sound", helper.sound.getRegistryName().toString(), compound);
        compound = helper.volume > 0.0f ? NBTHelper.safePutFloat("volume", helper.volume, compound) : compound;
        compound = helper.pitch > 0.0f ? NBTHelper.safePutFloat("pitch", helper.pitch, compound) : compound;
        compound = helper.dir == null ? compound : NBTHelper.safePutString("dir", helper.dir.m_122433_(), compound);
        compound = helper.offset > 0 ? NBTHelper.safePutInt("offset", helper.offset, compound) : compound;
        CompoundTag compoundTag = compound = helper.message == null ? compound : NBTHelper.safePutString("message", helper.message, compound);
        if (helper.positions != null && !helper.positions.isEmpty()) {
            ListTag list = new ListTag();
            for (int i : helper.positions) {
                list.add((Object)IntTag.m_128679_((int)i));
            }
            compound.m_128365_("positions", (Tag)list);
        }
        return compound;
    }

    private static CompoundTag writeSSH(ShipSaveHelper helper) {
        CompoundTag compound = new CompoundTag();
        compound = NBTHelper.safePutString("name", helper.getShip().toString(), compound);
        compound = NBTHelper.safePutInt("pos", helper.getPos(), compound);
        compound = NBTHelper.safePutString("dir", helper.getDir().name(), compound);
        return compound;
    }

    @Nullable
    public static ShipSaveHelper readSSH(CompoundTag compound) {
        try {
            return new ShipSaveHelper(compound.m_128461_("name"), compound.m_128451_("pos"), compound.m_128461_("dir"), 0);
        }
        catch (NullPointerException e) {
            NavalWarfare.LOGGER.warn("Received a null compound when reading SSH, skipping");
            return null;
        }
    }

    @Nullable
    public static BlockPos readBlockPos(CompoundTag compound) {
        if (compound == null || compound.m_128441_("no_pos") || compound.m_128456_()) {
            return null;
        }
        return new BlockPos(compound.m_128451_("x"), compound.m_128451_("y"), compound.m_128451_("z"));
    }

    @Nullable
    public static ControllerActionHelper readCAH(CompoundTag compound) {
        if (!compound.m_128441_("action")) {
            NavalWarfare.LOGGER.warn("Tried reading corrupt action with no type!");
            return null;
        }
        try {
            ControllerActionHelper cah = new ControllerActionHelper();
            cah.action = ControllerAction.valueOf(compound.m_128461_("action"));
            cah.pos = NBTHelper.readBlockPos(compound.m_128469_("pos"));
            cah.board_te = NBTHelper.readBlockPos(compound.m_128469_("board_te"));
            cah.player = compound.m_128441_("player") ? compound.m_128461_("player") : null;
            cah.spell = compound.m_128441_("spell") ? Spell.valueOf(compound.m_128461_("spell")) : null;
            cah.matching = NBTHelper.readBlockPos(compound.m_128469_("matching"));
            cah.damage = compound.m_128451_("damage");
            cah.delay = compound.m_128451_("delay");
            cah.target_type = compound.m_128441_("target_type") ? TargetType.valueOf(compound.m_128461_("target_type")) : null;
            cah.multi_ability = compound.m_128471_("multi_ability");
            cah.triggers_passives = compound.m_128471_("triggers_passives");
            cah.health = compound.m_128451_("health");
            cah.animation = compound.m_128441_("animation") ? (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.m_128461_("animation"))) : null;
            cah.opponent = compound.m_128441_("opponent") ? compound.m_128461_("opponent") : null;
            cah.item = compound.m_128441_("item") ? (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.m_128461_("item"))) : null;
            cah.translation = compound.m_128441_("translation") ? compound.m_128461_("translation") : null;
            cah.hover = compound.m_128441_("hover") ? compound.m_128461_("hover") : null;
            return cah;
        }
        catch (Exception e) {
            NavalWarfare.LOGGER.warn("Tried reading corrupt action type: " + compound.m_128461_("action").toUpperCase());
            return new ControllerActionHelper();
        }
    }

    public static TargetResultHelper readTRH(CompoundTag compound) {
        int id = compound.m_128451_("id");
        HitResult result = HitResult.valueOf(compound.m_128461_("result"));
        return new TargetResultHelper(id, result);
    }

    public static BattleLogHelper readBLH(CompoundTag compound) {
        try {
            BattleLogHelper blh = new BattleLogHelper();
            blh.action = BattleLogAction.valueOf(compound.m_128461_("action"));
            blh.id = compound.m_128451_("id");
            blh.opponent = compound.m_128471_("opponent");
            blh.board_state = compound.m_128441_("board_state") ? BoardState.valueOf(compound.m_128461_("board_state")) : null;
            blh.delay = compound.m_128451_("delay");
            blh.resource = compound.m_128441_("resource") ? new ResourceLocation(compound.m_128461_("resource")) : null;
            blh.ship_state = compound.m_128441_("ship_state") ? ShipState.valueOf(compound.m_128461_("ship_state")) : null;
            blh.sound = compound.m_128441_("sound") ? (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(compound.m_128461_("sound"))) : null;
            blh.volume = compound.m_128457_("volume");
            blh.pitch = compound.m_128457_("pitch");
            blh.offset = compound.m_128451_("offset");
            blh.dir = compound.m_128441_("dir") ? Direction.m_122402_((String)compound.m_128461_("dir")) : null;
            String string = blh.message = compound.m_128441_("message") ? compound.m_128461_("message") : null;
            if (compound.m_128441_("positions")) {
                ListTag list = compound.m_128437_("positions", 3);
                blh.positions = new ArrayList();
                for (Tag tag : list) {
                    IntTag itag = (IntTag)tag;
                    blh.positions.add(itag.m_7047_());
                }
            }
            return blh;
        }
        catch (Exception e) {
            NavalWarfare.LOGGER.warn("Tried reading corrupt BLH: " + compound);
            return new BattleLogHelper();
        }
    }

    private static CompoundTag safePutBoolean(String name, boolean value, boolean default_val, CompoundTag compound) {
        try {
            compound.m_128379_(name, value);
        }
        catch (NullPointerException e) {
            compound.m_128379_(name, default_val);
        }
        return compound;
    }

    private static CompoundTag safePutBoolean(String name, boolean value, CompoundTag compound) {
        return NBTHelper.safePutBoolean(name, value, false, compound);
    }

    private static CompoundTag safePutInt(String name, int value, int default_val, CompoundTag compound) {
        try {
            compound.m_128405_(name, value);
        }
        catch (NullPointerException e) {
            compound.m_128405_(name, default_val);
        }
        return compound;
    }

    private static CompoundTag safePutInt(String name, int value, CompoundTag compound) {
        return NBTHelper.safePutInt(name, value, 0, compound);
    }

    private static CompoundTag safePutFloat(String name, float value, float default_val, CompoundTag compound) {
        try {
            compound.m_128350_(name, value);
        }
        catch (NullPointerException e) {
            compound.m_128350_(name, default_val);
        }
        return compound;
    }

    private static CompoundTag safePutFloat(String name, float value, CompoundTag compound) {
        return NBTHelper.safePutFloat(name, value, 0.0f, compound);
    }

    private static CompoundTag safePutString(String name, String value, String default_val, CompoundTag compound) {
        try {
            compound.m_128359_(name, value);
        }
        catch (NullPointerException e) {
            compound.m_128359_(name, default_val);
        }
        return compound;
    }

    private static CompoundTag safePutString(String name, String value, CompoundTag compound) {
        return NBTHelper.safePutString(name, value, "", compound);
    }
}

