/*
 * Decompiled with CFR 0.152.
 */
package com.caveore.config;

import com.caveore.CaveOre;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class CommonConfiguration {
    public List<String> caveblocks = Lists.newArrayList((Object[])new String[]{"minecraft:air", "minecraft:cave_air", "minecraft:water", "minecraft:lava"});
    public List<String> excludedOres = new ArrayList<String>();
    public int spawnchance = 100;
    public double airChance = 10.0;
    public boolean inverted = false;

    protected CommonConfiguration() {
    }

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "List of blocks to which ores are allowed to spawn next to. This does not override existing spawn restrictions of the ores, as those are restrictions on the block they can spawn instead of.  e.g. format :  [\"minecraft:air\", \"minecraft:cave_air\"]");
        JsonArray list = new JsonArray();
        for (String name : this.caveblocks) {
            list.add(name);
        }
        entry.add("caveblocks", (JsonElement)list);
        root.add("caveblocks", (JsonElement)entry);
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "List of excluded ores beeing affected, these are mod-specific. : e.g. format :  [\"mod:orename\", \"minecraft:iron_ore\"]");
        JsonArray list2 = new JsonArray();
        for (String name : this.excludedOres) {
            list2.add(name);
        }
        entry2.add("excludedOres", (JsonElement)list2);
        root.add("excludedOres", (JsonElement)entry2);
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "Inverts the exluded list to an included only list, of which ores are affected. Default : false");
        entry3.addProperty("inverted", Boolean.valueOf(this.inverted));
        root.add("inverted", (JsonElement)entry3);
        JsonObject entry4 = new JsonObject();
        entry4.addProperty("desc:", "Chance for an ore vein to appear, reduced below 100% to reduce spawn rates.");
        entry4.addProperty("spawnchance", (Number)this.spawnchance);
        root.add("spawnchance", (JsonElement)entry4);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "Alters chance of ores to not get spawned on air, increase to have more ores spawning on air.");
        entry5.addProperty("airChance", (Number)this.airChance);
        root.add("airChance", (JsonElement)entry5);
        return root;
    }

    public void deserialize(JsonObject data) {
        if (data == null) {
            CaveOre.LOGGER.error("Config file was empty!");
            return;
        }
        try {
            this.caveblocks = new ArrayList<String>();
            for (JsonElement element : data.get("caveblocks").getAsJsonObject().get("caveblocks").getAsJsonArray()) {
                this.caveblocks.add(element.getAsString());
            }
            this.excludedOres = new ArrayList<String>();
            for (JsonElement element : data.get("excludedOres").getAsJsonObject().get("excludedOres").getAsJsonArray()) {
                this.excludedOres.add(element.getAsString());
            }
            this.inverted = data.get("inverted").getAsJsonObject().get("inverted").getAsBoolean();
            this.spawnchance = data.get("spawnchance").getAsJsonObject().get("spawnchance").getAsInt();
            this.airChance = data.get("airChance").getAsJsonObject().get("airChance").getAsDouble();
        }
        catch (Exception e) {
            CaveOre.LOGGER.error("Could not parse config file", (Throwable)e);
        }
    }
}

