/*
 * Decompiled with CFR 0.152.
 */
package com.inpulsa.reskillable.client;

import com.inpulsa.reskillable.Configuration;
import com.inpulsa.reskillable.client.screen.SkillScreen;
import com.inpulsa.reskillable.common.capabilities.SkillCapability;
import com.inpulsa.reskillable.common.capabilities.SkillModel;
import com.inpulsa.reskillable.common.skills.Requirement;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class Overlay
extends GuiComponent {
    protected static List<Requirement> requirements = null;
    private static int showTicks = 0;
    protected static int SHOW_TICKS_DEFAULT = 60;

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.LAYER && showTicks > 0) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ != null && minecraft.f_91074_.getCapability(SkillCapability.INSTANCE).isPresent()) {
                PoseStack stack = event.getMatrixStack();
                GL11.glEnable((int)3042);
                int centerPosX = event.getWindow().m_85445_() / 2;
                int centerPosY = event.getWindow().m_85446_() / 4;
                this.renderMessageTitle(stack, minecraft.f_91062_, centerPosX, centerPosY);
                this.renderSkillRequirementsIcons(stack, centerPosX, centerPosY, minecraft.f_91062_);
            }
        }
    }

    protected void renderMessageTitle(PoseStack stack, Font font, int centerPosX, int centerPosY) {
        TranslatableComponent message = new TranslatableComponent("overlay.message");
        int textPosX = centerPosX - font.m_92895_(message.getString()) / 2;
        font.m_92883_(stack, message.getString(), (float)textPosX, (float)centerPosY, 0xFF5555);
    }

    protected void renderSkillRequirementsIcons(PoseStack stack, int centerPosX, int centerPosY, Font font) {
        int requirementsCount = requirements.size();
        int posY = centerPosY + 15;
        for (int requirementIndex = 0; requirementIndex < requirementsCount; ++requirementIndex) {
            Requirement requirement = requirements.get(requirementIndex);
            int posX = this.calculateIconPosXInOverlay(centerPosX, requirementsCount, requirementIndex);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)SkillScreen.RESOURCES);
            this.m_93228_(stack, posX, posY, SkillScreen.SkillIconTextureResolver.getTexturePosX(requirement.level), SkillScreen.SkillIconTextureResolver.getTexturePosY(requirement.skill), 16, 16);
            this.renderSkillRequirementNumber(stack, requirement, posX, posY, font);
        }
    }

    protected void renderSkillRequirementNumber(PoseStack stack, Requirement requirement, int iconPosX, int iconPosY, Font font) {
        boolean isSkillLevelAchieved = SkillModel.get().getSkillLevel(requirement.skill) >= requirement.level;
        int color = isSkillLevelAchieved ? 0x55FF55 : 0xFF5555;
        font.m_92883_(stack, Integer.toString(requirement.level), (float)(iconPosX + 17), (float)(iconPosY + 9), color);
    }

    protected int calculateIconPosXInOverlay(int centerX, int requirementCount, int index) {
        return centerX + index * 20 - requirementCount * 10 + 2;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (showTicks > 0) {
            --showTicks;
        }
    }

    public static void showWarning(ResourceLocation resource) {
        requirements = Arrays.asList(Configuration.getRequirements(resource));
        showTicks = SHOW_TICKS_DEFAULT;
    }

    protected static interface OverlayPositions {
        public static final int ICON_ITEM_WIDTH = 20;
        public static final int ICONS_OFFSET_Y = 15;
    }
}

