/*
 * Decompiled with CFR 0.152.
 */
package com.inpulsa.reskillable.client;

import com.inpulsa.reskillable.Configuration;
import com.inpulsa.reskillable.common.capabilities.SkillModel;
import com.inpulsa.reskillable.common.skills.Requirement;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Tooltip {
    protected static String componentName = "tooltip.requirements";

    @SubscribeEvent
    public void onTooltipDisplay(ItemTooltipEvent event) {
        Requirement[] requirements;
        ResourceLocation registryName;
        if (Minecraft.m_91087_().f_91074_ != null && (registryName = event.getItemStack().m_41720_().getRegistryName()) != null && (requirements = Configuration.getRequirements(registryName)) != null) {
            List tooltips = event.getToolTip();
            tooltips.add(TextComponent.f_131282_);
            tooltips.add(this.getRequirementsTextComponentToAdd());
            for (Requirement requirement : requirements) {
                tooltips.add(this.getSkillNameTextComponentToAdd(requirement));
            }
        }
    }

    protected MutableComponent getRequirementsTextComponentToAdd() {
        TranslatableComponent componentToAdd = new TranslatableComponent(componentName);
        componentToAdd.m_130946_(":");
        componentToAdd.m_130940_(ChatFormatting.GRAY);
        return componentToAdd;
    }

    protected MutableComponent getSkillNameTextComponentToAdd(Requirement requirement) {
        TranslatableComponent componentToAdd = new TranslatableComponent(requirement.skill.displayName);
        componentToAdd.m_130946_(" " + requirement.level);
        componentToAdd.m_130940_(this.getColorByRequirement(requirement));
        return componentToAdd;
    }

    protected ChatFormatting getColorByRequirement(Requirement requirement) {
        return SkillModel.get().getSkillLevel(requirement.skill) >= requirement.level ? ChatFormatting.GREEN : ChatFormatting.RED;
    }
}

