/*
 * Decompiled with CFR 0.152.
 */
package com.inpulsa.reskillable.client.screen;

import com.inpulsa.reskillable.client.screen.SkillScreen;
import com.inpulsa.reskillable.client.screen.buttons.TabButton;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class InventoryTabs {
    @SubscribeEvent
    public void onGuiInit(ScreenEvent.InitScreenEvent.Post event) {
        Screen screen = event.getScreen();
        if (this.isAffectedScreen(screen)) {
            InventoryScreen inventoryScreen;
            boolean isCreativeOpen = screen instanceof CreativeModeInventoryScreen;
            boolean skillsOpen = screen instanceof SkillScreen;
            int posX = (screen.f_96543_ - (isCreativeOpen ? 195 : 176)) / 2 - 28;
            int posY = (screen.f_96544_ - (isCreativeOpen ? 136 : 166)) / 2;
            int buttonsPaddingY = 7;
            TabButton inventoryButton = new TabButton(posX, posY + buttonsPaddingY, TabButton.TabType.INVENTORY, !skillsOpen);
            TabButton skillsButton = new TabButton(posX, posY + 27 + buttonsPaddingY, TabButton.TabType.SKILLS, skillsOpen);
            if (screen instanceof InventoryScreen && (inventoryScreen = (InventoryScreen)screen).m_5564_().m_100385_()) {
                return;
            }
            screen.f_169369_.add(inventoryButton);
            screen.f_169369_.add(skillsButton);
            if (screen instanceof InventoryScreen) {
                for (TabButton button : List.of(inventoryButton, skillsButton)) {
                    PoseStack poseStack = new PoseStack();
                    button.render(poseStack);
                }
            }
        }
    }

    private boolean isAffectedScreen(Screen screen) {
        return screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen || screen instanceof SkillScreen;
    }

    @SubscribeEvent
    public void onPotionShift(ScreenEvent.PotionShiftEvent event) {
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void mouseClicked(ScreenEvent.MouseClickedEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen) {
            InventoryScreen inventoryScreen = (InventoryScreen)screen;
            if (inventoryScreen.m_5564_().m_100385_()) {
                for (Widget button : screen.f_169369_) {
                    if (!(button instanceof TabButton)) continue;
                    tabButton = (TabButton)button;
                    tabButton.hide();
                }
            } else {
                for (Widget button : screen.f_169369_) {
                    if (!(button instanceof TabButton)) continue;
                    tabButton = (TabButton)button;
                    tabButton.show();
                }
            }
        }
        if (this.isAffectedScreen(screen)) {
            for (Widget button : screen.f_169369_) {
                if (!(button instanceof TabButton)) continue;
                TabButton tabButton = (TabButton)button;
                tabButton.m_6375_(event.getMouseX(), event.getMouseY(), 0);
            }
        }
    }
}

