/*
 * Decompiled with CFR 0.152.
 */
package com.inpulsa.reskillable.client.screen;

import com.inpulsa.reskillable.client.screen.buttons.SkillButton;
import com.inpulsa.reskillable.common.skills.Skill;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SkillScreen
extends Screen {
    public static final ResourceLocation RESOURCES = new ResourceLocation("reskillable", "textures/gui/skills.png");

    public SkillScreen() {
        super((Component)new TranslatableComponent("container.skills"));
    }

    protected void m_7856_() {
        int left = (this.f_96543_ - 174) / 2;
        int top = (this.f_96544_ - 146) / 2;
        int counter = 0;
        for (Skill skill : Skill.values()) {
            int x = left + counter % 2 * 83;
            int y = top + counter / 2 * 36;
            this.m_142416_((GuiEventListener)new SkillButton(x, y, skill));
            ++counter;
        }
    }

    public void m_6305_(@NotNull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        this.renderBg(stack);
        this.renderTitle(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    protected float calculateRenderWidth() {
        return this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void renderTitle(PoseStack stack) {
        this.f_96547_.m_92889_(stack, this.f_96539_, this.calculateRenderWidth(), (float)(this.getTopOffset() + 5), 0x3F3F3F);
    }

    protected void renderBg(PoseStack stack) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)RESOURCES);
        this.m_93228_(stack, this.getLeftOffset(), this.getTopOffset(), 0, 0, 176, 166);
    }

    protected int getLeftOffset() {
        return (this.f_96543_ - 176) / 2;
    }

    protected int getTopOffset() {
        return (this.f_96544_ - 166) / 2;
    }

    public boolean m_7933_(int keyCode, int p_96553_, int p_96554_) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ != null) {
            if (keyCode == 69) {
                if (minecraft.f_91074_ != null) {
                    minecraft.m_91152_((Screen)new InventoryScreen((Player)minecraft.f_91074_));
                    return false;
                }
            } else if (keyCode == 71) {
                minecraft.f_91080_.m_7379_();
                return false;
            }
        }
        return super.m_7933_(keyCode, p_96553_, p_96554_);
    }

    private static interface BackgroundPositions {
        public static final int RESOURCE_OFFSET_X = 0;
        public static final int RESOURCE_OFFSET_Y = 0;
        public static final int WIDTH = 176;
        public static final int HEIGHT = 166;
    }

    public static class SkillIconTextureResolver {
        public static int LEVEL_STEP = 8;

        private static int calculateIconLevel(int skillLevel) {
            BigDecimal rawValue = new BigDecimal(skillLevel / LEVEL_STEP);
            return rawValue.setScale(1, RoundingMode.DOWN).intValue();
        }

        public static int getTexturePosX(int level) {
            return 176 + SkillIconTextureResolver.calculateIconLevel(level) * 16;
        }

        public static int getTexturePosY(Skill skill) {
            return 128 + skill.index * 16;
        }
    }

    public static interface IconTextureParams {
        public static final int OFFSET_X = 176;
        public static final int OFFSET_Y = 128;
        public static final int WIDTH = 16;
        public static final int HEIGHT = 16;
    }
}

