/*
 * Decompiled with CFR 0.152.
 */
package com.inpulsa.reskillable.client.screen.buttons;

import com.inpulsa.reskillable.Configuration;
import com.inpulsa.reskillable.client.screen.SkillScreen;
import com.inpulsa.reskillable.common.capabilities.SkillModel;
import com.inpulsa.reskillable.common.network.RequestLevelUp;
import com.inpulsa.reskillable.common.skills.Skill;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SkillButton
extends Button {
    private final Skill skill;

    public SkillButton(int x, int y, Skill skill) {
        super(x, y, 79, 32, (Component)new TranslatableComponent(""), SkillButton::onButtonPress);
        this.skill = skill;
    }

    public void m_6305_(@NotNull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        int maxLevel;
        Minecraft minecraft = Minecraft.m_91087_();
        int level = SkillModel.get().getSkillLevel(this.skill);
        if (level == (maxLevel = Configuration.getMaxLevel())) {
            this.renderMaxLevelBg(stack);
        } else {
            this.renderDefaultBg(stack);
        }
        this.renderIcon(stack, level);
        this.drawButtonTitle(stack, minecraft.f_91062_);
        this.drawButtonLevels(stack, minecraft.f_91062_, level, maxLevel);
        if (this.m_5953_(mouseX, mouseY) && level < maxLevel) {
            this.drawIncreaseCost(stack, minecraft, level);
        }
    }

    protected void drawButtonTitle(PoseStack stack, Font font) {
        int posX = this.f_93620_ + 30;
        int posY = this.f_93621_ + 14;
        font.m_92889_(stack, (Component)new TranslatableComponent(this.skill.displayName), (float)posX, (float)posY, 0xFFFFFF);
    }

    protected void drawButtonLevels(PoseStack stack, Font font, int level, int maxLevel) {
        int posX = this.f_93620_ + 30;
        int posY = this.f_93621_ + 25;
        String levelsString = level + "/" + maxLevel;
        font.m_92883_(stack, levelsString, (float)posX, (float)posY, 0xBEBEBE);
    }

    protected void drawIncreaseCost(PoseStack stack, Minecraft minecraft, int level) {
        int cost = RequestLevelUp.calculateLevelUpCost(level);
        if (minecraft.f_91074_ != null) {
            int colour = minecraft.f_91074_.f_36078_ >= cost ? 8322080 : 16536660;
            String text = Integer.toString(cost);
            int posX = this.f_93620_ + 78 - minecraft.f_91062_.m_92895_(text);
            int posY = this.f_93621_ + 25;
            minecraft.f_91062_.m_92883_(stack, text, (float)posX, (float)posY, colour);
        }
    }

    protected void renderDefaultBg(PoseStack stack) {
        this.renderBg(stack, 176, 0);
    }

    protected void renderMaxLevelBg(PoseStack stack) {
        this.renderBg(stack, 176, 64);
    }

    protected void renderBg(PoseStack stack, int offsetX, int offsetY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SkillScreen.RESOURCES);
        this.m_93228_(stack, this.f_93620_ + 6, this.f_93621_ + 8, offsetX, offsetY, 79, 32);
    }

    protected void renderIcon(PoseStack stack, int level) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SkillScreen.RESOURCES);
        this.m_93228_(stack, this.f_93620_ + 6 + 5, this.f_93621_ + 8 + 8, SkillScreen.SkillIconTextureResolver.getTexturePosX(level), SkillScreen.SkillIconTextureResolver.getTexturePosY(this.skill), 16, 16);
    }

    public static void onButtonPress(Button button) {
        RequestLevelUp.send(((SkillButton)button).skill);
    }

    private static interface BackgroundPositions {
        public static final int RESOURCE_OFFSET_X = 176;
        public static final int RESOURCE_OFFSET_Y = 0;
        public static final int RESOURCE_MAX_LEVEL_OFFSET_X = 175;
        public static final int RESOURCE_MAX_LEVEL_OFFSET_Y = 64;
        public static final int WIDTH = 79;
        public static final int HEIGHT = 32;
    }
}

