/*
 * Decompiled with CFR 0.152.
 */
package com.inpulsa.reskillable.common;

import com.inpulsa.reskillable.Configuration;
import com.inpulsa.reskillable.common.capabilities.SkillModel;
import com.inpulsa.reskillable.common.capabilities.SkillProvider;
import com.inpulsa.reskillable.common.network.SyncToClient;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (this.shouldCancelBlockInteraction((PlayerInteractEvent)event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (this.shouldCancelBlockInteraction((PlayerInteractEvent)event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItemStack();
        if (!player.m_7500_() && !SkillModel.get(player).canUseItem(player, item)) {
            event.setCanceled(true);
        }
    }

    private boolean shouldCancelBlockInteraction(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!player.m_7500_()) {
            ItemStack item = event.getItemStack();
            BlockState blockState = event.getWorld().m_8055_(event.getPos());
            Block block = blockState.m_60734_();
            SkillModel skillModel = SkillModel.get(player);
            return !skillModel.canUseItem(player, item) || !skillModel.canUseBlock(player, block);
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (this.shouldCancelEntityInteraction((PlayerEvent)event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackEntity(AttackEntityEvent event) {
        if (this.shouldCancelEntityInteraction((PlayerEvent)event)) {
            event.setCanceled(true);
        }
    }

    private boolean shouldCancelEntityInteraction(PlayerEvent event) {
        boolean result = false;
        Player player = event.getPlayer();
        if (!player.m_7500_()) {
            ItemStack item = player.m_21205_();
            boolean bl = result = !SkillModel.get(player).canUseItem(player, item);
            if (!result && event instanceof PlayerInteractEvent.EntityInteract) {
                Entity entity = ((PlayerInteractEvent.EntityInteract)event).getTarget();
                result = !SkillModel.get(player).canUseEntity(player, entity);
            }
        }
        return result;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChangeEquipment(LivingEquipmentChangeEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && !(player = (Player)entity).m_7500_() && event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
            ItemStack item = event.getTo();
            if (!SkillModel.get(player).canUseItem(player, item)) {
                ItemStack previousItem = event.getFrom();
                int slotIndex = event.getSlot().m_20749_();
                player.m_150109_().f_35975_.set(slotIndex, (Object)previousItem);
                player.m_150109_().m_36054_(item);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDrops(LivingDropsEvent event) {
        if (Configuration.getDisableWool() && event.getEntity() instanceof Sheep) {
            Collection drops = event.getDrops();
            drops.removeIf(drop -> {
                ResourceLocation itemRegistryName = drop.m_32055_().m_41720_().getRegistryName();
                if (itemRegistryName != null) {
                    return itemRegistryName.toString().equals("wool");
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (Configuration.getDeathReset() && event.getEntity() instanceof Player) {
            SkillModel.get((Player)((Player)event.getEntity())).skillLevels = new int[]{1, 1, 1, 1, 1, 1, 1, 1};
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            SkillModel skillModel = new SkillModel();
            SkillProvider provider = new SkillProvider(skillModel);
            event.addCapability(new ResourceLocation("reskillable", "cap_skills"), (ICapabilityProvider)provider);
            event.addListener(provider::invalidate);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        SkillModel.get((Player)event.getPlayer()).skillLevels = SkillModel.get((Player)event.getOriginal()).skillLevels;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        SyncToClient.send(e.getPlayer());
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent e) {
        SyncToClient.send(e.getPlayer());
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        SyncToClient.send(e.getPlayer());
    }
}

