/*
 * Decompiled with CFR 0.152.
 */
package com.inpulsa.reskillable.common.capabilities;

import com.inpulsa.reskillable.Configuration;
import com.inpulsa.reskillable.common.capabilities.SkillCapability;
import com.inpulsa.reskillable.common.network.NotifyWarning;
import com.inpulsa.reskillable.common.skills.Requirement;
import com.inpulsa.reskillable.common.skills.Skill;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class SkillModel
implements INBTSerializable<CompoundTag> {
    public int[] skillLevels = new int[]{1, 1, 1, 1, 1, 1, 1, 1};

    public int getSkillLevel(@NotNull Skill skill) {
        return this.skillLevels[skill.index];
    }

    public void setSkillLevel(@NotNull Skill skill, int level) {
        this.skillLevels[skill.index] = level;
    }

    public void increaseSkillLevel(@NotNull Skill skill) {
        int n = skill.index;
        this.skillLevels[n] = this.skillLevels[n] + 1;
    }

    public boolean canUseItem(Player player, @NotNull ItemStack item) {
        return this.canUse(player, item.m_41720_().getRegistryName());
    }

    public boolean canUseBlock(Player player, @NotNull Block block) {
        return this.canUse(player, block.getRegistryName());
    }

    public boolean canUseEntity(Player player, @NotNull Entity entity) {
        return this.canUse(player, entity.m_6095_().getRegistryName());
    }

    private boolean canUse(Player player, ResourceLocation resource) {
        Requirement[] requirements = Configuration.getRequirements(resource);
        if (requirements != null) {
            for (Requirement currentRequirement : requirements) {
                if (this.getSkillLevel(currentRequirement.skill) >= currentRequirement.level) continue;
                if (player instanceof ServerPlayer) {
                    NotifyWarning.send(player, resource);
                }
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static SkillModel get() {
        LocalPlayer player = Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        return SkillModel.get((Player)player);
    }

    @NotNull
    public static SkillModel get(@NotNull Player player) {
        return (SkillModel)player.getCapability(SkillCapability.INSTANCE).orElseThrow(() -> {
            String name = player.m_7755_().getString();
            throw new IllegalArgumentException("Player " + name + " does not have a Skill Model!");
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("mining", this.skillLevels[0]);
        compound.m_128405_("gathering", this.skillLevels[1]);
        compound.m_128405_("attack", this.skillLevels[2]);
        compound.m_128405_("defense", this.skillLevels[3]);
        compound.m_128405_("building", this.skillLevels[4]);
        compound.m_128405_("farming", this.skillLevels[5]);
        compound.m_128405_("agility", this.skillLevels[6]);
        compound.m_128405_("magic", this.skillLevels[7]);
        return compound;
    }

    public void deserializeNBT(@NotNull CompoundTag compoundTag) {
        this.skillLevels[0] = compoundTag.m_128451_("mining");
        this.skillLevels[1] = compoundTag.m_128451_("gathering");
        this.skillLevels[2] = compoundTag.m_128451_("attack");
        this.skillLevels[3] = compoundTag.m_128451_("defense");
        this.skillLevels[4] = compoundTag.m_128451_("building");
        this.skillLevels[5] = compoundTag.m_128451_("farming");
        this.skillLevels[6] = compoundTag.m_128451_("agility");
        this.skillLevels[7] = compoundTag.m_128451_("magic");
    }
}

