/*
 * Decompiled with CFR 0.152.
 */
package com.inpulsa.reskillable.common.capabilities;

import com.inpulsa.reskillable.common.capabilities.SkillCapability;
import com.inpulsa.reskillable.common.capabilities.SkillModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillProvider
implements ICapabilitySerializable<CompoundTag> {
    private final SkillModel skillModel;
    private LazyOptional<SkillModel> optional;

    public SkillProvider(SkillModel skillModel) {
        this.skillModel = skillModel;
        this.optional = LazyOptional.of(() -> this.skillModel);
    }

    public void invalidate() {
        this.optional.addListener(this::recreateCapability);
        this.optional.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        return capability == SkillCapability.INSTANCE ? this.optional.cast() : LazyOptional.empty();
    }

    public void recreateCapability(LazyOptional<SkillModel> lazy) {
        this.optional = LazyOptional.of(() -> this.skillModel);
    }

    public CompoundTag serializeNBT() {
        return this.skillModel.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.skillModel.deserializeNBT(nbt);
    }
}

