/*
 * Decompiled with CFR 0.152.
 */
package com.inpulsa.reskillable.common.commands;

import com.inpulsa.reskillable.common.capabilities.SkillModel;
import com.inpulsa.reskillable.common.skills.Skill;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.command.EnumArgument;

public class GetCommand {
    static LiteralArgumentBuilder<CommandSourceStack> register() {
        RequiredArgumentBuilder playerArg = Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_());
        RequiredArgumentBuilder skillArg = Commands.m_82129_((String)"skill", (ArgumentType)EnumArgument.enumArgument(Skill.class));
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"get").then(((RequiredArgumentBuilder)playerArg.then(skillArg.executes(GetCommand::execute))).executes(GetCommand::executeWithoutSkill));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        Skill skill = (Skill)((Object)context.getArgument("skill", Skill.class));
        int level = SkillModel.get((Player)player).getSkillLevel(skill);
        TranslatableComponent component = new TranslatableComponent(skill.displayName);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)component.m_130946_(": " + level), false);
        return level;
    }

    private static int executeWithoutSkill(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        ArrayList<Skill> skills = new ArrayList<Skill>(List.of());
        skills.addAll(Arrays.asList(Skill.values()));
        for (Skill skill : skills) {
            int level = SkillModel.get((Player)player).getSkillLevel(skill);
            TranslatableComponent component = new TranslatableComponent(skill.displayName);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)component.m_130946_(": " + level), false);
        }
        return 0;
    }
}

