/*
 * Decompiled with CFR 0.152.
 */
package com.inpulsa.reskillable.common.commands;

import com.inpulsa.reskillable.Configuration;
import com.inpulsa.reskillable.common.capabilities.SkillModel;
import com.inpulsa.reskillable.common.network.SyncToClient;
import com.inpulsa.reskillable.common.skills.Skill;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.command.EnumArgument;

public class SetCommand {
    static LiteralArgumentBuilder<CommandSourceStack> register() {
        RequiredArgumentBuilder playerArg = Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_());
        RequiredArgumentBuilder skillArg = Commands.m_82129_((String)"skill", (ArgumentType)EnumArgument.enumArgument(Skill.class));
        RequiredArgumentBuilder levelArg = Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Configuration.getMaxLevel()));
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"set").then(playerArg.then(skillArg.then(levelArg.executes(SetCommand::execute))));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        Skill skill = (Skill)((Object)context.getArgument("skill", Skill.class));
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        SkillModel.get((Player)player).setSkillLevel(skill, level);
        SyncToClient.send((Player)player);
        TranslatableComponent message = new TranslatableComponent("Skill level was updated");
        ((CommandSourceStack)context.getSource()).m_81354_((Component)message, false);
        return 1;
    }
}

