/*
 * Decompiled with CFR 0.152.
 */
package com.inpulsa.reskillable.common.network;

import com.inpulsa.reskillable.Configuration;
import com.inpulsa.reskillable.Network;
import com.inpulsa.reskillable.common.capabilities.SkillModel;
import com.inpulsa.reskillable.common.network.SyncToClient;
import com.inpulsa.reskillable.common.skills.Skill;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class RequestLevelUp {
    private final int skill;

    public RequestLevelUp(Skill skill) {
        this.skill = skill.index;
    }

    public RequestLevelUp(FriendlyByteBuf buffer) {
        this.skill = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.skill);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            int cost;
            Skill skill;
            SkillModel skillModel;
            int skillLevel;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null && this.isLevelCanBeUpped(player, skillLevel = (skillModel = SkillModel.get((Player)player)).getSkillLevel(skill = Skill.values()[this.skill]), cost = RequestLevelUp.calculateLevelUpCost(skillLevel))) {
                if (!player.m_7500_()) {
                    player.m_6749_(-cost);
                }
                skillModel.increaseSkillLevel(skill);
                SyncToClient.send((Player)player);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static int calculateLevelUpCost(int skillLevel) {
        return Configuration.getStartCost() + (skillLevel - 1) * Configuration.getCostIncrease();
    }

    private boolean isLevelCanBeUpped(ServerPlayer player, int skillLevel, int cost) {
        return skillLevel < Configuration.getMaxLevel() && (player.m_7500_() || player.f_36078_ >= cost);
    }

    public static void send(Skill skill) {
        Network.NETWORK.sendToServer((Object)new RequestLevelUp(skill));
    }
}

