/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.ambientenvironment;

import java.util.stream.IntStream;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.level.ColorResolver;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="ambientenvironment")
public class AmbientEnvironment {
    public AmbientEnvironment() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ColorResolver grassColor = BiomeColors.field_180291_a;
        ColorResolver waterColor = BiomeColors.field_180290_c;
        int levels = 2;
        PerlinNoiseGenerator NOISE_GRASS = new PerlinNoiseGenerator(new SharedSeedRandom((long)"NOISE_GRASS".hashCode()), IntStream.rangeClosed(0, levels));
        PerlinNoiseGenerator NOISE_WATER = new PerlinNoiseGenerator(new SharedSeedRandom((long)"NOISE_WATER".hashCode()), IntStream.rangeClosed(0, levels));
        BiomeColors.field_180291_a = (biome, posX, posZ) -> {
            int newColor = grassColor.getColor(biome, posX, posZ);
            float scale = 8.0f;
            double value = NOISE_GRASS.func_215464_a(posX / (double)scale, posZ / (double)scale, false);
            double darkness = 0.25;
            value = AmbientEnvironment.curve(0.0, 1.0, AmbientEnvironment.remap(value, -((1 << levels) - 1), (1 << levels) - 1, 0.0, 1.0), 1.0) * darkness;
            return AmbientEnvironment.blend(newColor, 0, (float)value);
        };
        BiomeColors.field_180290_c = (biome, posX, posZ) -> {
            int newColor = waterColor.getColor(biome, posX, posZ);
            float scale = 16.0f;
            double value = NOISE_WATER.func_215464_a(posX / (double)scale, posZ / (double)scale, false);
            double darkness = 0.3f;
            value = AmbientEnvironment.curve(0.0, 1.0, AmbientEnvironment.remap(value, -((1 << levels) - 1), (1 << levels) - 1, 0.0, 1.0), 1.0) * darkness;
            return AmbientEnvironment.blend(newColor, 0, (float)value);
        };
    }

    public static double remap(double value, double currentLow, double currentHigh, double newLow, double newHigh) {
        return newLow + (value - currentLow) * (newHigh - newLow) / (currentHigh - currentLow);
    }

    private static float getRed(int hex) {
        return (float)(hex >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int hex) {
        return (float)(hex >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int hex) {
        return (float)(hex & 0xFF) / 255.0f;
    }

    private static float getAlpha(int hex) {
        return (float)(hex >> 24 & 0xFF) / 255.0f;
    }

    private static float[] getARGB(int hex) {
        return new float[]{AmbientEnvironment.getAlpha(hex), AmbientEnvironment.getRed(hex), AmbientEnvironment.getGreen(hex), AmbientEnvironment.getBlue(hex)};
    }

    private static int toInt(float[] argb) {
        int r = (int)Math.floor(argb[1] * 255.0f) & 0xFF;
        int g = (int)Math.floor(argb[2] * 255.0f) & 0xFF;
        int b = (int)Math.floor(argb[3] * 255.0f) & 0xFF;
        int a = (int)Math.floor(argb[0] * 255.0f) & 0xFF;
        return (a << 24) + (r << 16) + (g << 8) + b;
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double curve(double start, double end, double amount, double waves) {
        amount = AmbientEnvironment.clamp(amount, 0.0, 1.0);
        amount = AmbientEnvironment.clamp((amount - start) / (end - start), 0.0, 1.0);
        return AmbientEnvironment.clamp(0.5 + 0.5 * Math.sin(Math.cos(Math.PI * Math.tan(90.0 * amount))) * Math.cos(Math.sin(Math.tan(amount))), 0.0, 1.0);
    }

    public static int blend(int color1, int color2, float ratio) {
        float ir = 1.0f - ratio;
        float[] rgb1 = AmbientEnvironment.getARGB(color2);
        float[] rgb2 = AmbientEnvironment.getARGB(color1);
        return AmbientEnvironment.toInt(new float[]{rgb1[0] * ratio + rgb2[0] * ir, rgb1[1] * ratio + rgb2[1] * ir, rgb1[2] * ratio + rgb2[2] * ir, rgb1[3] * ratio + rgb2[3] * ir});
    }
}

