/*
 * Decompiled with CFR 0.152.
 */
package net.pinaz993.simpleshelves;

import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2746;
import net.minecraft.class_3965;
import net.pinaz993.simpleshelves.AbstractShelf;
import net.pinaz993.simpleshelves.LocalHorizontalSide;
import net.pinaz993.simpleshelves.ShelfQuadrant;

public enum BookPosition {
    ALPHA_1(0, AbstractShelf.BOOK_ALPHA_1, 3),
    ALPHA_2(1, AbstractShelf.BOOK_ALPHA_2, 1),
    ALPHA_3(2, AbstractShelf.BOOK_ALPHA_3, 4),
    BETA_1(3, AbstractShelf.BOOK_BETA_1, 2),
    BETA_2(4, AbstractShelf.BOOK_BETA_2, 3),
    BETA_3(5, AbstractShelf.BOOK_BETA_3, 3),
    GAMMA_1(6, AbstractShelf.BOOK_GAMMA_1, 3),
    GAMMA_2(7, AbstractShelf.BOOK_GAMMA_2, 2),
    GAMMA_3(8, AbstractShelf.BOOK_GAMMA_3, 3),
    DELTA_1(9, AbstractShelf.BOOK_DELTA_1, 2),
    DELTA_2(10, AbstractShelf.BOOK_DELTA_2, 4),
    DELTA_3(11, AbstractShelf.BOOK_DELTA_3, 2);

    public final int SLOT;
    public final class_2746 BLOCK_STATE_PROPERTY;
    public final double WIDTH;

    private BookPosition(int slot, class_2746 blockStateProperty, int pixels) {
        this.SLOT = slot;
        this.BLOCK_STATE_PROPERTY = blockStateProperty;
        this.WIDTH = (double)pixels * 0.0625;
    }

    public static BookPosition getBookPos(class_3965 hit, class_2350 facing) {
        LocalHorizontalSide localSide = LocalHorizontalSide.getLocalSide(hit.method_17780(), facing);
        class_243 localCoords = hit.method_17784().method_1020(class_243.method_24954((class_2382)hit.method_17777()));
        ShelfQuadrant q = ShelfQuadrant.getQuadrant(hit, facing);
        switch (localSide) {
            case LEFT: {
                return switch (q) {
                    case ShelfQuadrant.ALPHA -> ALPHA_1;
                    case ShelfQuadrant.GAMMA -> GAMMA_1;
                    default -> throw new IllegalStateException("Cannot access " + q + " from " + localSide + " side.");
                };
            }
            case RIGHT: {
                return switch (q) {
                    case ShelfQuadrant.BETA -> BETA_3;
                    case ShelfQuadrant.DELTA -> DELTA_3;
                    default -> throw new IllegalStateException("Cannot access " + q + " from " + localSide + " side.");
                };
            }
            case TOP: {
                double u = switch (facing) {
                    case class_2350.field_11043 -> 1.0 - localCoords.field_1352;
                    case class_2350.field_11034 -> 1.0 - localCoords.field_1350;
                    case class_2350.field_11035 -> localCoords.field_1352;
                    case class_2350.field_11039 -> localCoords.field_1350;
                    default -> throw new IllegalStateException("Shelves cannot face " + facing + ".");
                };
                if (q == ShelfQuadrant.BETA) {
                    u -= 0.5;
                }
                for (BookPosition bp : q.BOOK_POSITIONS) {
                    if (!(u >= BookPosition.getLeftEdge(bp, q)) || !(u < BookPosition.getRightEdge(bp, q))) continue;
                    return bp;
                }
                throw new IllegalStateException("Horizontal Position " + u + " doesn't hit any book in " + q);
            }
            case FRONT: {
                double u = switch (facing) {
                    case class_2350.field_11043 -> 1.0 - localCoords.field_1352;
                    case class_2350.field_11034 -> 1.0 - localCoords.field_1350;
                    case class_2350.field_11035 -> localCoords.field_1352;
                    case class_2350.field_11039 -> localCoords.field_1350;
                    default -> throw new IllegalStateException("Shelves cannot face ".concat(facing.toString()).concat("."));
                };
                if (q == ShelfQuadrant.BETA || q == ShelfQuadrant.DELTA) {
                    u -= 0.5;
                }
                for (BookPosition bp : q.BOOK_POSITIONS) {
                    if (!(u >= BookPosition.getLeftEdge(bp, q)) || !(u < BookPosition.getRightEdge(bp, q))) continue;
                    return bp;
                }
                throw new IllegalStateException("Horizontal Position " + u + " doesn't hit any book in " + q);
            }
        }
        throw new IllegalStateException(String.format("No books are accessible from the %s side.", new Object[]{localSide}));
    }

    public static double getLeftEdge(BookPosition pos, ShelfQuadrant quadrant) {
        double rtn = 0.0;
        for (BookPosition bp : quadrant.BOOK_POSITIONS) {
            if (bp == pos) {
                return rtn;
            }
            rtn += bp.WIDTH;
        }
        throw new IllegalArgumentException("Book Position " + pos.toString() + " is not located in Shelf Quadrant " + quadrant);
    }

    public static double getRightEdge(BookPosition pos, ShelfQuadrant quadrant) {
        double rtn = 0.0;
        for (BookPosition bp : quadrant.BOOK_POSITIONS) {
            rtn += bp.WIDTH;
            if (bp != pos) continue;
            return rtn;
        }
        throw new IllegalArgumentException("Book Position " + pos.toString() + " is not located in Shelf Quadrant " + quadrant);
    }
}

