/*
 * Decompiled with CFR 0.152.
 */
package net.pinaz993.simpleshelves;

import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_3532;
import net.pinaz993.simpleshelves.BookPosition;
import net.pinaz993.simpleshelves.ItemTags;
import net.pinaz993.simpleshelves.ShelfQuadrant;
import org.jetbrains.annotations.Nullable;

public interface ShelfInventory
extends class_1278 {
    public static boolean isBookLike(class_1799 stack) {
        return ItemTags.BOOK_LIKE.method_15141((Object)stack.method_7909());
    }

    default public int method_5439() {
        return this.getItems().size();
    }

    public static int[] getBookSlots() {
        return new int[]{BookPosition.ALPHA_1.SLOT, BookPosition.ALPHA_2.SLOT, BookPosition.ALPHA_3.SLOT, BookPosition.BETA_1.SLOT, BookPosition.BETA_2.SLOT, BookPosition.BETA_3.SLOT, BookPosition.GAMMA_1.SLOT, BookPosition.GAMMA_2.SLOT, BookPosition.GAMMA_3.SLOT, BookPosition.DELTA_1.SLOT, BookPosition.DELTA_2.SLOT, BookPosition.DELTA_3.SLOT};
    }

    public static int[] getGenericSlots() {
        return new int[]{ShelfQuadrant.ALPHA.GENERIC_ITEM_SLOT, ShelfQuadrant.BETA.GENERIC_ITEM_SLOT, ShelfQuadrant.GAMMA.GENERIC_ITEM_SLOT, ShelfQuadrant.DELTA.GENERIC_ITEM_SLOT};
    }

    public class_2371<class_1799> getItems();

    default public boolean method_5442() {
        for (class_1799 s : this.getItems()) {
            if (s.method_7960()) continue;
            return false;
        }
        return true;
    }

    default public void method_5448() {
        this.getItems().clear();
    }

    default public boolean method_5437(int slot, class_1799 stack) {
        for (int i : ShelfInventory.getBookSlots()) {
            if (slot != i) continue;
            return ShelfInventory.isBookLike(stack);
        }
        for (int i : ShelfInventory.getGenericSlots()) {
            if (slot != i) continue;
            return true;
        }
        throw new IllegalArgumentException(String.format("Invalid slot index for shelf: %s", slot));
    }

    default public class_1799 attemptInsertion(int slot, class_1799 newStack) {
        class_1799 oldStack = this.method_5438(slot);
        if (oldStack.method_7960()) {
            this.getItems().set(slot, (Object)newStack);
            this.method_5431();
            return class_1799.field_8037;
        }
        if (oldStack.method_7946() && oldStack.method_7929(newStack) && oldStack.method_7947() < oldStack.method_7914()) {
            if (newStack.method_7947() <= oldStack.method_7914() - oldStack.method_7947()) {
                oldStack.method_7939(oldStack.method_7947() + newStack.method_7947());
                this.method_5431();
                return class_1799.field_8037;
            }
            int diff = oldStack.method_7914() - oldStack.method_7947();
            newStack.method_7939(newStack.method_7947() - diff);
            oldStack.method_7939(oldStack.method_7914());
            return newStack;
        }
        return newStack;
    }

    default public class_1799 method_5438(int slot) {
        return (class_1799)this.getItems().get(slot);
    }

    default public void method_5447(int slot, class_1799 stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    default public class_1799 method_5441(int slot) {
        class_1799 rtn = class_1262.method_5428(this.getItems(), (int)slot);
        if (!rtn.method_7960()) {
            this.method_5431();
        }
        return rtn;
    }

    default public class_1799 method_5434(int slot, int amount) {
        class_1799 rtn = class_1262.method_5430(this.getItems(), (int)slot, (int)amount);
        if (!rtn.method_7960()) {
            this.method_5431();
        }
        return rtn;
    }

    default public boolean method_5443(class_1657 player) {
        return true;
    }

    default public boolean quadrantHasBook(ShelfQuadrant quadrant) {
        for (BookPosition bpos : quadrant.BOOK_POSITIONS) {
            if (((class_1799)this.getItems().get(bpos.SLOT)).method_7960()) continue;
            return true;
        }
        return false;
    }

    default public boolean quadrantHasGenericItem(ShelfQuadrant quadrant) {
        return !this.method_5438(quadrant.GENERIC_ITEM_SLOT).method_7960();
    }

    default public boolean shelfHasGenericItem() {
        for (ShelfQuadrant q : (ShelfQuadrant[])ShelfQuadrant.class.getEnumConstants()) {
            if (!this.quadrantHasGenericItem(q)) continue;
            return true;
        }
        return false;
    }

    default public int[] method_5494(class_2350 side) {
        return ShelfInventory.getBookSlots();
    }

    default public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (!ShelfInventory.isBookLike(stack)) {
            return false;
        }
        for (ShelfQuadrant q : (ShelfQuadrant[])ShelfQuadrant.class.getEnumConstants()) {
            for (BookPosition bp : q.BOOK_POSITIONS) {
                if (slot != bp.SLOT) continue;
                return !this.quadrantHasGenericItem(q);
            }
        }
        return false;
    }

    default public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        for (int i : ShelfInventory.getBookSlots()) {
            if (slot != i) continue;
            return true;
        }
        return false;
    }

    default public int getComparatorOutput() {
        float c = 0.0f;
        for (BookPosition bp : (BookPosition[])BookPosition.class.getEnumConstants()) {
            class_1799 stack = this.method_5438(bp.SLOT);
            c += (float)stack.method_7947() / (float)Math.min(this.method_5444(), stack.method_7914());
        }
        return class_3532.method_15375((float)((c /= (float)ShelfInventory.getBookSlots().length) * 14.0f)) + 1;
    }
}

