/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.client.render;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidRenderMap<V>
extends Object2ObjectOpenCustomHashMap<FluidStack, V> {
    public FluidRenderMap() {
        super((Hash.Strategy)FluidHashStrategy.INSTANCE);
    }

    public static TextureAtlasSprite getFluidTexture(@Nonnull FluidStack fluidStack, @Nonnull FluidType type) {
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getAttributes().getStillTexture(fluidStack) : fluid.getAttributes().getFlowingTexture(fluidStack);
        return FluidRenderMap.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(spriteLocation);
    }

    public static class FluidHashStrategy
    implements Hash.Strategy<FluidStack> {
        public static FluidHashStrategy INSTANCE = new FluidHashStrategy();

        public int hashCode(FluidStack stack) {
            if (stack == null || stack.isEmpty()) {
                return 0;
            }
            int code = 1;
            code = 31 * code + stack.getFluid().hashCode();
            if (stack.hasTag()) {
                code = 31 * code + stack.getTag().hashCode();
            }
            return code;
        }

        public boolean equals(FluidStack a, FluidStack b) {
            return a == null ? b == null : b != null && a.isFluidEqual(b);
        }
    }

    public static enum FluidType {
        STILL,
        FLOWING;

    }
}

