/*
 * Decompiled with CFR 0.152.
 */
package geni.witherutilsexp.api.common.block;

import geni.witherutilsexp.api.common.util.UtilSound;
import geni.witherutilsexp.registry.BlockRegistry;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BaseBlock
extends Block {
    private boolean hasFluidInteract = false;

    public BaseBlock(AbstractBlock.Properties properties) {
        super(properties);
        BlockRegistry.blocks.add(this);
    }

    protected BaseBlock setHasFluidInteract() {
        this.hasFluidInteract = true;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent a = new TranslationTextComponent("Information/About:                ");
        a.func_240699_a_(TextFormatting.GOLD);
        TranslationTextComponent b = new TranslationTextComponent("");
        b.func_240699_a_(TextFormatting.GOLD);
        TranslationTextComponent t = new TranslationTextComponent(this.func_149739_a() + ".tooltip");
        t.func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.WHITE});
        TranslationTextComponent ts = new TranslationTextComponent("ID: witherutilsexp" + (Object)((Object)this));
        ts.func_240701_a_(new TextFormatting[]{TextFormatting.RESET, TextFormatting.DARK_GREEN, TextFormatting.UNDERLINE});
        tooltip.add((ITextComponent)b);
        tooltip.add((ITextComponent)a);
        tooltip.add((ITextComponent)b);
        tooltip.add((ITextComponent)t);
        tooltip.add((ITextComponent)b);
        tooltip.add((ITextComponent)ts);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List dropsOriginal = super.func_220076_a(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((IItemProvider)this, 1));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (this.hasFluidInteract) {
            IFluidHandler handler;
            TileEntity tankHere;
            if (!world.field_72995_K && (tankHere = world.func_175625_s(pos)) != null && (handler = (IFluidHandler)tankHere.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.func_216354_b()).orElse(null)) != null) {
                if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)handler)) {
                    if (handler.getFluidInTank(0) != null) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(BaseBlock.getFluidRatioName(handler)), true);
                    }
                    if (player instanceof ServerPlayerEntity) {
                        UtilSound.playSoundFromServer((ServerPlayerEntity)player, SoundEvents.field_187630_M);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent(BaseBlock.getFluidRatioName(handler)), true);
                }
            }
            if (FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)).isPresent()) {
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public static String getFluidRatioName(IFluidHandler handler) {
        String ratio = handler.getFluidInTank(0).getAmount() + "/" + handler.getTankCapacity(0);
        if (!handler.getFluidInTank(0).isEmpty()) {
            ratio = ratio + " " + handler.getFluidInTank(0).getDisplayName().getString();
        }
        return ratio;
    }
}

